/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.descriptors;

public class JobLink {
    String title;
    LinkType type = LinkType.Manual;
    String url;

    public String getTitle() {
        return this.title;
    }

    public LinkType getType() {
        return this.type;
    }

    public String getUrl() {
        return this.url;
    }

    public JobLink setTitle(String title) {
        this.title = title;
        return this;
    }

    public JobLink setType(LinkType type) {
        this.type = type;
        return this;
    }

    public JobLink setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getHTMLLink() {
        String prefix = "";
        if (this.type == LinkType.Manual) {
            prefix = "Manual : ";
        }
        if (this.type == LinkType.Tutorial) {
            prefix = "Tutorial : ";
        }
        return String.format("%s<a href=\"%s\">%s</a>", prefix, this.url, this.title);
    }

    public static enum LinkType {
        Manual(2),
        Other(3),
        Tutorial(1);

        int id;

        private LinkType(int id) {
            this.id = id;
        }
    }
}

