/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.descriptors;

import com.biotechvana.workflow.ITaskDescriptor;
import com.biotechvana.workflow.descriptors.DescFilters;
import com.biotechvana.workflow.descriptors.JobLink;
import com.biotechvana.workflow.descriptors.Publication;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

public class JobDescriptor
implements ITaskDescriptor {
    public String jobId;
    private HashMap<String, VariableDescriptor.VariableType> inputVariables = new LinkedHashMap<String, VariableDescriptor.VariableType>();
    private HashMap<String, VariableDescriptor.VariableType> outputVariables = new LinkedHashMap<String, VariableDescriptor.VariableType>();
    private HashMap<String, VariableDescriptor> variables = new LinkedHashMap<String, VariableDescriptor>();
    private HashMap<String, ArrayList<VariableDescriptor>> variablesGroup = new LinkedHashMap<String, ArrayList<VariableDescriptor>>();
    private HashMap<String, VariableDescriptor.VariableRole> groupTypes = new LinkedHashMap<String, VariableDescriptor.VariableRole>();
    private HashMap<Integer, VariableDescriptor> orderedVariables = new LinkedHashMap<Integer, VariableDescriptor>();
    private int varCount = 0;
    String desc = "";
    @Deprecated
    String jobRef = null;
    Boolean hasOptionsVar = false;
    String defaultTaskKey;
    HashMap<String, List<Publication>> publicationsPerTool = new HashMap();
    HashMap<String, List<JobLink>> jobLinksPerTool = new HashMap();
    CLIToolInfo mainTaskCmd;
    List<CLIToolInfo> subTaskCmd = new ArrayList<CLIToolInfo>();
    HashMap<String, String> variableTransformationMap = new HashMap();
    String toolGroup = null;
    List<DescFilters.JobDescriptorFilterExtractor> jobFilterExtractors = new ArrayList<DescFilters.JobDescriptorFilterExtractor>();
    List<DescFilters.JobDescriptorFilterBase> jobDescriptorThresholdFilters = new ArrayList<DescFilters.JobDescriptorFilterBase>();
    String version;
    boolean latest = false;
    JobDescriptor validationJobDesc;

    public JobDescriptor() {
        this.publicationsPerTool.put(this.defaultTaskKey, new ArrayList());
        this.jobLinksPerTool.put(this.defaultTaskKey, new ArrayList());
    }

    public JobDescriptor(String jobID) {
        this.jobId = jobID;
        this.publicationsPerTool.put(this.defaultTaskKey, new ArrayList());
        this.jobLinksPerTool.put(this.defaultTaskKey, new ArrayList());
    }

    public Collection<VariableDescriptor> getAllVariables() {
        return this.orderedVariables.values();
    }

    public void addVariable(VariableDescriptor var) {
        String varKey = var.getKey();
        if (varKey == null || varKey.isEmpty()) {
            throw new NullPointerException("Variable Key can not be null not Empty.");
        }
        if (this.variables.containsKey(var.getKey())) {
            return;
        }
        String tempKey = var.getKey();
        if (tempKey.equals("auto")) {
            Object keyPostfix = "_Var_" + this.varCount;
            if (!var.getCommandParamaterAlt().isEmpty()) {
                keyPostfix = var.getCommandParamaterAlt();
                keyPostfix = ((String)keyPostfix).replace("--", "_");
                keyPostfix = ((String)keyPostfix).replace("-", "_");
                keyPostfix = ((String)keyPostfix).replace(".", "_");
                keyPostfix = ((String)keyPostfix).replace(" ", "_");
            } else if (!var.getCommandParamater().isEmpty()) {
                keyPostfix = var.getCommandParamater();
                keyPostfix = ((String)keyPostfix).replace("--", "_");
                keyPostfix = ((String)keyPostfix).replace("-", "_");
                keyPostfix = ((String)keyPostfix).replace(".", "_");
                keyPostfix = ((String)keyPostfix).replace(" ", "_");
            }
            if (var.isSubProg()) {
                keyPostfix = "_" + var.getSubProgName() + (String)keyPostfix;
            }
            var.setKey("opt" + (String)keyPostfix);
        }
        this.variables.put(var.getKey(), var);
        this.orderedVariables.put(this.varCount, var);
        ++this.varCount;
        if (var.getVarRole() == VariableDescriptor.VariableRole.Input) {
            this.inputVariables.put(var.getKey(), var.getVarType());
        }
        if (var.getVarRole() == VariableDescriptor.VariableRole.Output) {
            this.outputVariables.put(var.getKey(), var.getVarType());
        }
        if (var.getVarRole() == VariableDescriptor.VariableRole.Option) {
            this.hasOptionsVar = true;
        }
        if (var.hasGroup()) {
            String groupName = var.getVarGroup();
            if (!this.variablesGroup.containsKey(groupName)) {
                ArrayList group = new ArrayList();
                this.variablesGroup.put(groupName, group);
                this.groupTypes.put(groupName, var.getVarRole());
            }
            this.variablesGroup.get(groupName).add(var);
        }
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getHelpMsgAll() {
        String msg = this.desc + "\n";
        for (VariableDescriptor var : this.orderedVariables.values()) {
            if (var.getVarRole() != VariableDescriptor.VariableRole.Input || var.hasActions()) continue;
            msg = msg + "\t" + var.getHelpMsgAll();
        }
        return msg;
    }

    @Deprecated
    public void setRef(String ref) {
        this.jobRef = ref;
    }

    @Deprecated
    public String getRef() {
        return this.jobRef;
    }

    public Set<String> getVarGroups() {
        return this.variablesGroup.keySet();
    }

    public VariableDescriptor.VariableRole groupType(String groupName) {
        return this.groupTypes.get(groupName);
    }

    public ArrayList<VariableDescriptor> getGroupVars(String groupName) {
        return this.variablesGroup.get(groupName);
    }

    public boolean hasVar(String name) {
        return this.variables.containsKey(name);
    }

    public boolean hasOptions() {
        return this.hasOptionsVar;
    }

    public VariableDescriptor getVariableDescByCMDSwitch(String cmdSwitch) {
        if (cmdSwitch == null) {
            return null;
        }
        for (VariableDescriptor varDesc : this.variables.values()) {
            if (!cmdSwitch.equals(varDesc.getCommandParamater()) && !cmdSwitch.equals(varDesc.getCommandParamaterAlt())) continue;
            return varDesc;
        }
        return null;
    }

    public VariableDescriptor getVariableDescById(String varId) {
        return this.variables.get(varId);
    }

    public void addPublication(Publication pub) {
        this.publicationsPerTool.get(this.defaultTaskKey).add(pub);
    }

    public void clearPublications() {
        this.publicationsPerTool.get(this.defaultTaskKey).clear();
    }

    public Publication[] getPublications() {
        return this.publicationsPerTool.get(this.defaultTaskKey).toArray(new Publication[0]);
    }

    public void addPublication(Publication pub, String subTask) {
        if (!this.publicationsPerTool.containsKey(subTask)) {
            this.publicationsPerTool.put(subTask, new ArrayList());
        }
        this.publicationsPerTool.get(subTask).add(pub);
    }

    public Publication[] getPublications(String subTask) {
        if (this.publicationsPerTool.containsKey(subTask)) {
            return this.publicationsPerTool.get(subTask).toArray(new Publication[0]);
        }
        return new Publication[0];
    }

    public void addLink(JobLink link) {
        this.jobLinksPerTool.get(this.defaultTaskKey).add(link);
    }

    public JobLink[] getLinks() {
        return this.jobLinksPerTool.get(this.defaultTaskKey).toArray(new JobLink[0]);
    }

    public void addCLITool(CLIToolInfo cliToolInfo) {
        this.addCLITool(cliToolInfo, false);
    }

    public void addCLITool(CLIToolInfo cliToolInfo, boolean mainTool) {
        this.subTaskCmd.add(cliToolInfo);
        if (mainTool) {
            this.mainTaskCmd = cliToolInfo;
            this.mainTaskCmd.mainTool = true;
        }
        if (cliToolInfo.mainInputVariable != null && cliToolInfo.generatedOutputVariable != null) {
            this.variableTransformationMap.put(cliToolInfo.generatedOutputVariable, cliToolInfo.mainInputVariable);
        }
    }

    public void setToolGroup(String toolGroup) {
        this.toolGroup = toolGroup;
    }

    public String getToolGroup() {
        return this.toolGroup;
    }

    public void addExtractor(DescFilters.JobDescriptorFilterExtractor qRF) {
        this.jobFilterExtractors.add(qRF);
        this.variableTransformationMap.put(qRF.getStoreVariable().getKey(), qRF.getInputVariable().getKey());
    }

    public List<DescFilters.JobDescriptorFilterExtractor> getExtractors() {
        return this.jobFilterExtractors;
    }

    public void addThresholdFilter(DescFilters.JobDescriptorFilterBase jobDescriptorThresholdFilter) {
        this.jobDescriptorThresholdFilters.add(jobDescriptorThresholdFilter);
    }

    public List<DescFilters.JobDescriptorFilterBase> getFilters() {
        return this.jobDescriptorThresholdFilters;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setVersion(String version, boolean latest) {
        this.version = version;
        this.latest = latest;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isLatestVersion() {
        return this.latest;
    }

    public void setValidationDesc(JobDescriptor validationJobDesc) {
        this.validationJobDesc = validationJobDesc;
    }

    public JobDescriptor getValidationDesc() {
        return this.validationJobDesc;
    }

    public DescFilters.JobDescriptorFilterBase getThresholdFilter(String filterName) {
        for (DescFilters.JobDescriptorFilterBase thresholdFilter : this.jobDescriptorThresholdFilters) {
            if (!thresholdFilter.getName().equals(filterName)) continue;
            return thresholdFilter;
        }
        return null;
    }

    public DescFilters.JobDescriptorFilterExtractor getFilterExtractor(String extractorName) {
        for (DescFilters.JobDescriptorFilterExtractor filterExtractor : this.jobFilterExtractors) {
            if (!filterExtractor.getName().equals(extractorName)) continue;
            return filterExtractor;
        }
        return null;
    }

    public List<CLIToolInfo> getTaskCmdTools() {
        return this.subTaskCmd;
    }

    public static class CLIToolInfo {
        String id;
        String name;
        String baseCLI;
        String baseCLISubtool;
        public String mainInputVariable = null;
        public String generatedOutputVariable = null;
        public boolean mainTool;

        public String getId() {
            if (this.id != null) {
                return this.id;
            }
            if (this.baseCLISubtool != null) {
                return String.format("%s_%s", this.baseCLI, this.baseCLISubtool);
            }
            return this.baseCLI;
        }

        public CLIToolInfo setId(String id) {
            this.id = id;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public CLIToolInfo setName(String name) {
            this.name = name;
            return this;
        }

        public String getBaseCLI() {
            return this.baseCLI;
        }

        public CLIToolInfo setBaseCLI(String baseCLI) {
            this.baseCLI = baseCLI;
            return this;
        }

        public String getBaseCLISubtool() {
            return this.baseCLISubtool;
        }

        public CLIToolInfo setBaseCLISubtool(String baseCLISubtool) {
            this.baseCLISubtool = baseCLISubtool;
            return this;
        }

        public String toString() {
            return this.getId();
        }

        public CLIToolInfo setMainInputVariable(String inputVariableKey) {
            this.mainInputVariable = inputVariableKey;
            return this;
        }

        public CLIToolInfo setGeneratedOutputVariable(String outputVariableKey) {
            this.generatedOutputVariable = outputVariableKey;
            return this;
        }
    }
}

