/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow;

import com.biotechvana.users.UserManager;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class Tracking {
    public static String SUBMISSION_TIMESTAMP_VARNAME = "submission_data";
    public static String SCRIPT_ID_VARNAME = "script_id";
    static String TRACK_LOG_FILE_NAME_VAR = "trackLogFileName";
    static String TRACK_LOG_G_STATUS_VAR = "_log_g_status_";
    public static final String GENERAL_FILTER_STATUS = "_g_filter_status";
    public static final String GENERAL_JOB_STATUS = "_g_job_exec_status";
    static String TRACK_LOG_LOCK_HANDLER = "TRACK_LOG_LOCK_HANDLER";
    static String TRACK_LOG_LOCK_FILENAME = "TRACK_LOG_LOCK_FILENAME";

    public static String trackLog(String logMsg) {
        return Tracking.trackLog(logMsg, false);
    }

    public static String trackLog(String logMsg, boolean doEcho) {
        String tLogMsg = "printf \"$(date +%s )\\t" + String.valueOf((Object)TrackEventType.LogMsg) + "\\t" + logMsg + "\\n\" >> \"${" + TRACK_LOG_FILE_NAME_VAR + "}\" \n";
        if (doEcho) {
            tLogMsg = tLogMsg + "echo \"" + logMsg + "\"\n\n";
        }
        return BashHelper.mutex(tLogMsg, TRACK_LOG_LOCK_HANDLER, TRACK_LOG_LOCK_FILENAME);
    }

    public static String trackLog(TrackEventType event, String jobName, String logMsg) {
        String eventStr = String.valueOf((Object)event) + "\\t" + jobName + "\\t" + logMsg;
        return "logEvent \"" + eventStr + "\" \n";
    }

    public static String trackLogFail(String jobName, String logMsg) {
        String eventStr = String.valueOf((Object)TrackEventType.Failed) + "\\t" + jobName + "\\t" + logMsg;
        return "logEvent " + Tracking.quotes(eventStr) + " \n";
    }

    public static String trackLogWarning(String logMsg) {
        String eventStr = String.valueOf((Object)TrackEventType.Warning) + "\\t" + logMsg;
        return "logEvent " + Tracking.quotes(eventStr) + " \n";
    }

    public static String trackLogCheck(String fileName, String filterName, TrackCheckType checkType, TrackCheckLevels level, String logMsg) {
        String eventStr = String.valueOf((Object)TrackEventType.Check) + "\\t" + fileName + "\\t" + String.valueOf((Object)checkType) + "\\t" + String.valueOf((Object)level) + "\\t" + filterName + "\\t" + logMsg;
        return "logEvent " + Tracking.quotes(eventStr) + " \n";
    }

    public static String trackLogCheck(String fileName, String filterName, TrackCheckType checkType, String level, String logMsg) {
        String eventStr = String.valueOf((Object)TrackEventType.Check) + "\\t" + fileName + "\\t" + String.valueOf((Object)checkType) + "\\t" + level + "\\t" + filterName + "\\t" + logMsg;
        return "logEvent " + Tracking.quotes(eventStr) + " \n";
    }

    public static String trackLog(TrackEventType event, String jobName) {
        String eventStr = String.valueOf((Object)event) + "\\t" + jobName;
        return "logEvent " + Tracking.quotes(eventStr) + " \n";
    }

    public static String setLogFileName(UserManager userManager, String submissionDate, String jobName) {
        String TRACK_LOG_FOLDER_VAR = userManager.getHostPathManager().sanitizeFilePathWithTelda(userManager.getHostPathManager().getRemoteAppTrackFolder());
        String remoteLockFolder = userManager.getHostPathManager().sanitizeFilePathWithTelda(userManager.getHostPathManager().getRemoteLockFolder());
        return TRACK_LOG_LOCK_HANDLER + "=\"500\"\n" + TRACK_LOG_LOCK_FILENAME + "=\"" + remoteLockFolder + submissionDate + "_" + jobName + "_track.lock\" \n" + BashHelper.SCREEN_LOG_LOCK_FILENAME + "=\"" + remoteLockFolder + submissionDate + "_" + jobName + "_screen.lock\" \n" + BashHelper.SCREEN_LOG_LOCK_HANDLER + "=\"501\"\n" + SCRIPT_ID_VARNAME + "=\"" + submissionDate + "_" + jobName + "\"\n[ -d " + TRACK_LOG_FOLDER_VAR + " ] || mkdir " + TRACK_LOG_FOLDER_VAR + " \n" + TRACK_LOG_FILE_NAME_VAR + "=\"" + TRACK_LOG_FOLDER_VAR + "/" + jobName + "_" + submissionDate + ".track\"\n";
    }

    public static String trackStart(String scriptName) {
        String tLogMsg = "printf \"$(date +%s )\\t" + String.valueOf((Object)TrackEventType.Started) + "\\t" + scriptName + "\\t$$\\n\" >> \"${" + TRACK_LOG_FILE_NAME_VAR + "}\" \n";
        return BashHelper.mutex(tLogMsg, TRACK_LOG_LOCK_HANDLER, TRACK_LOG_LOCK_FILENAME);
    }

    public static String trackEnd(String jobName, TrackEndStatus status, String msg) {
        String eventStr = String.valueOf((Object)TrackEventType.Ended) + "\\t" + jobName + "\\t" + String.valueOf((Object)status);
        if (msg != null && !msg.isEmpty()) {
            eventStr = eventStr + "\\t" + msg;
        }
        return "logEvent " + Tracking.quotes(eventStr) + " \n";
    }

    public static String submitEntry(UserManager userManager, String commandFile, String scritFolder, String taskType, String taskName, String taskID) {
        String moduleName = userManager.getModuleId();
        StringBuilder commandBuilder = new StringBuilder();
        commandBuilder.append("script_filename=\"" + commandFile + "\"\n");
        commandBuilder.append("script_folder=\"" + scritFolder + "\"\n");
        commandBuilder.append("script_type=\"" + taskType + "\"\n");
        commandBuilder.append("software_name=\"" + moduleName + "\"\n");
        commandBuilder.append("task_Id=\"" + taskID + "\"\n");
        commandBuilder.append("submission_data=$(date +%s)\n");
        String appFolder = userManager.getHostPathManager().sanitizeFilePathWithTelda(userManager.getHostPathManager().getRemoteAppUserFolder());
        String histFile = userManager.getHostPathManager().sanitizeFilePathWithTelda(userManager.getHostPathManager().getRemoteUserHistoryFile());
        commandBuilder.append("[ -d " + appFolder + " ] || mkdir " + appFolder + " \n");
        String sep = ";";
        commandBuilder.append("printf  \"$submission_data" + sep + taskName + sep + "$script_filename" + sep + "$script_folder" + sep + "$script_type" + sep + "$software_name" + sep + taskID + "\\n\" >> " + histFile + " \n");
        commandBuilder.append(Tracking.setLogFileName(userManager, "${submission_data}", taskName));
        commandBuilder.append("touch " + histFile + " \n");
        return commandBuilder.toString();
    }

    public static String trackProcessing(String files) {
        return "processingLogEvent  " + String.valueOf((Object)TrackEventType.Processing) + "  " + Tracking.quotes(files) + "\n";
    }

    public static String trackProcessing(String files, String msg) {
        return "processingLogEvent  " + String.valueOf((Object)TrackEventType.Processing) + "  " + Tracking.quotes(files) + "  " + Tracking.quotes(msg) + " \n";
    }

    public static String trackProcessed(String files) {
        return "processingLogEvent  " + String.valueOf((Object)TrackEventType.Processed) + "  " + Tracking.quotes(files) + "\n";
    }

    public static String trackProcessed(String files, String subProg) {
        return "processingLogEvent " + String.valueOf((Object)TrackEventType.Processed) + " " + Tracking.quotes(files) + " " + Tracking.quotes(subProg) + "\n";
    }

    public static String trackProcessedFail(String files) {
        return "processingLogEvent  " + String.valueOf((Object)TrackEventType.ProcessingFail) + "  " + Tracking.quotes(files) + "\n";
    }

    public static String trackProcessedFail(String files, String subProg) {
        return "processingLogEvent " + String.valueOf((Object)TrackEventType.ProcessingFail) + " " + Tracking.quotes(files) + " " + Tracking.quotes(subProg) + "\n";
    }

    public static String cacheLog(UserManager userManager, String logFile, String jobName) {
        String logsFolder = userManager.getHostPathManager().sanitizeFilePathWithTelda(userManager.getHostPathManager().getRemoteAppLogFolder());
        String command = "[ -d " + logsFolder + " ] || mkdir " + logsFolder + " \n";
        command = command + "[ -s " + logFile + " ] && cp " + logFile + " " + logsFolder + jobName + "_${submission_data}.log\n";
        return command;
    }

    public static String TrackInfo(TrackInfoType infoType, JobVariable var) {
        Object tLogMsg = "";
        tLogMsg = var instanceof FileListVariable ? (String)tLogMsg + "infoStr=$(gInfoFilesPair  \"" + var.getFullKey() + "\"  " + var.getBashVarName() + " ) \n" : (String)tLogMsg + "infoStr=$(gInfoFiles \"" + var.getFullKey() + "\"  " + var.getBashVarName("@") + " ) \n";
        String isTracked = "";
        if (var.getDescIsTracked()) {
            isTracked = "\\tTrack";
        }
        String eventStr = String.valueOf((Object)TrackEventType.Info) + "\\t" + String.valueOf((Object)infoType) + "\\t${infoStr}" + isTracked;
        tLogMsg = (String)tLogMsg + "logEvent " + Tracking.quotes(eventStr) + " \n";
        return tLogMsg;
    }

    public static String TrackInfo(TrackInfoType infoType, String key, String varWithAtAll) {
        String tLogMsg = "infoStr=$(gInfoFiles \"" + key + "\"  " + varWithAtAll + " ) \n";
        String eventStr = String.valueOf((Object)TrackEventType.Info) + "\\t" + String.valueOf((Object)infoType) + "\\t${infoStr}";
        tLogMsg = tLogMsg + "logEvent " + Tracking.quotes(eventStr) + " \n";
        return tLogMsg;
    }

    public static String trackProcessTrack(JobVariable var, String baseCML, String baseCMLID) {
        String eventStr = String.valueOf((Object)TrackEventType.SubProcess) + "\\t" + var.getFullKey();
        if (baseCML != null && !baseCML.isEmpty()) {
            eventStr = eventStr + "\\t" + baseCML;
        }
        if (baseCMLID != null && !baseCMLID.isEmpty()) {
            eventStr = eventStr + "\\t" + baseCMLID;
        }
        return "logEvent " + Tracking.quotes(eventStr) + " \n";
    }

    public static String trackProcessTrack(JobVariable var) {
        Object finalStr = "";
        if (var.getDescVarRole() != VariableDescriptor.VariableRole.Input) {
            finalStr = Tracking.TrackInfo(TrackInfoType.Output, var);
        }
        String eventStr = String.valueOf((Object)TrackEventType.SubProcess) + "\\t" + var.getFullKey();
        finalStr = (String)finalStr + "logEvent " + Tracking.quotes(eventStr) + " \n";
        return finalStr;
    }

    static String quotes(String str) {
        return "\"" + str + "\"";
    }

    public static enum TrackCheckLevels {
        Pass,
        Fail,
        Warning;

    }

    public static enum TrackCheckType {
        Output,
        Filter;

    }

    public static enum TrackEndStatus {
        Finished,
        Failed,
        Warning;

    }

    public static enum TrackEventType {
        Started,
        Ended,
        WarnEnded,
        Error,
        Warning,
        Paused,
        Failed,
        Resumed,
        Canceled,
        LogMsg,
        Info,
        Processing,
        Processed,
        ProcessingFail,
        Check,
        SubProcess;

    }

    public static enum TrackInfoType {
        Input,
        Output,
        Parameter,
        Process,
        Other;

    }
}

