/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.pipelineCommander;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ActivationHardware {
    public static String getActiveHardwareAddress() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                String macString;
                NetworkInterface nif = interfaces.nextElement();
                if (nif.isLoopback() || nif.isVirtual() || !nif.isUp() || (macString = ActivationHardware.getMacAddressAsString(nif.getHardwareAddress())) == null || macString.length() <= 0 || !ActivationHardware.validateMacAddress(macString)) continue;
                return macString;
            }
        }
        catch (SocketException e) {
            return null;
        }
        return null;
    }

    public static List<String> getHardwareAddresses() {
        ArrayList<String> macList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                try {
                    ActivationHardware.displayInterfaceInformation(netint);
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (SocketException e1) {
            e1.printStackTrace();
        }
        return macList;
    }

    static void displayInterfaceInformation(NetworkInterface netint) throws SocketException {
        System.out.printf("Display name: %s\n", netint.getDisplayName());
        System.out.printf("Name: %s\n", netint.getName());
        Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
        for (InetAddress inetAddress : Collections.list(inetAddresses)) {
            System.out.printf("InetAddress: %s\n", inetAddress);
        }
        System.out.printf("\n", new Object[0]);
    }

    private static String getMacAddressAsString(byte[] mac) {
        if (mac == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < mac.length) {
            builder.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            ++i;
        }
        return builder.toString();
    }

    public static boolean validateMacAddress(String mac) {
        if (mac == null || mac.length() == 0) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9A-F]{2}([:-][0-9A-F]{2}){5}");
        Matcher matcher = pattern.matcher(mac);
        return matcher.matches();
    }

    public static void main(String[] args) {
        System.out.println("Active MAC: " + ActivationHardware.getActiveHardwareAddress());
        System.out.println("List of interfaces:");
        for (String s : ActivationHardware.getHardwareAddresses()) {
            System.out.println(s);
        }
    }
}

