/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.csvUtils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CSVUtils3 {
    private File csvFile;
    private List<String> listHeaders;
    public static final char DELIMITER_SEMICOLON = ';';
    public static final char DELIMITER_COLON = ';';
    public static final char DELIMITER_TAB = '\t';
    public static final char DELIMITER_SPACE = ' ';
    public static final char ENCLOSURE_DOUBLE_QUOTE = '\"';
    public static final char ENCLOSURE_SINGLE_QUOTE = '\'';
    private static char COMMENT_CHAR = (char)35;
    private static char ESCAPE_CHAR = (char)92;
    private static char NEW_LINE_N = (char)10;
    private static char NEW_LINE_R = (char)13;
    private char delimiter = (char)59;
    private char enclosure = (char)34;
    private int colCount = 0;
    private int rowCount = 0;
    private List<List<String>> model;
    private boolean hasHeader = true;
    private boolean hasEnclosure = true;
    private boolean verbose = false;

    public CSVUtils3(File csvFile) {
        this.csvFile = csvFile;
    }

    public CSVUtils3(String path) {
        this(new File(path));
    }

    public CSVUtils3(File csvFile, char delimiter, char enclosure) {
        this.csvFile = csvFile;
        this.delimiter = delimiter;
        this.enclosure = enclosure;
    }

    public CSVUtils3(File csvFile, char delimiter) {
        this.csvFile = csvFile;
        this.delimiter = delimiter;
    }

    public File getCsvFile() {
        return this.csvFile;
    }

    public void parse() throws IOException {
        this.parse(0);
    }

    public void parse(int maxLines) throws IOException {
        this.parseHeaders();
        this.readCsv(maxLines);
    }

    public List<String> getHeaders() {
        return this.listHeaders;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public void setEnclosure(char enclosure) {
        this.enclosure = enclosure;
    }

    public void setHasHeader(boolean hasHeader) {
        this.hasHeader = hasHeader;
    }

    public boolean getHasHeader() {
        return this.hasHeader;
    }

    public void setHasEnclosure(boolean hasEnclosure) {
        this.hasEnclosure = hasEnclosure;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public boolean getHasEnclosure() {
        return this.hasEnclosure;
    }

    public void printHeaders() {
        System.out.println(String.valueOf(Arrays.toString(this.listHeaders.toArray(new String[this.listHeaders.size()]))) + " (" + this.listHeaders.size() + " cols)");
    }

    public void printModel() {
        this.printModel(0);
    }

    public void printModel(int limit) {
        int modelSize = this.model.size();
        boolean stop = false;
        int i = 0;
        while (i < modelSize && !stop) {
            List<String> row = this.model.get(i);
            System.out.println(String.valueOf(i + 1) + ":" + Arrays.toString(row.toArray(new String[row.size()])) + " (" + row.size() + " cols)");
            if (limit != 0 && i == limit - 1) {
                stop = true;
            }
            ++i;
        }
    }

    private void readCsv(int maxLines) throws IOException {
        boolean headerFound = false;
        if (!this.hasHeader) {
            headerFound = true;
        }
        if (this.model == null) {
            this.model = new ArrayList<List<String>>();
        }
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.length() <= 0 || line.charAt(0) == COMMENT_CHAR) continue;
                if (headerFound) {
                    this.model.add(this.parseCsvLine(line));
                    continue;
                }
                headerFound = true;
            }
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseHeaders() throws IOException {
        this.listHeaders = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));){
            block7: {
                String line;
                boolean headerFound;
                block6: {
                    headerFound = false;
                    if (!true) break block6;
                    line = reader.readLine();
                    if (line == null) return;
                    if (headerFound) break block7;
                }
                do {
                    if (!line.trim().isEmpty() && line.trim().charAt(0) != COMMENT_CHAR) {
                        this.listHeaders = this.parseCsvLine(line);
                        headerFound = true;
                    }
                    line = reader.readLine();
                    if (line == null) return;
                } while (!headerFound);
            }
            return;
        }
    }

    private List<String> parseCsvLine(String line) {
        line = line.trim();
        ArrayList<String> cols = new ArrayList<String>();
        int length = line.length();
        StringBuilder builder = new StringBuilder();
        boolean enclosureOpen = false;
        int i = 0;
        while (i < length) {
            if (line.charAt(i) == this.delimiter) {
                if (enclosureOpen) {
                    builder.append(line.charAt(i));
                } else {
                    cols.add(builder.toString());
                    builder = new StringBuilder();
                }
            } else if (line.charAt(i) == this.enclosure) {
                if (i - 1 >= 0 && line.charAt(i - 1) == ESCAPE_CHAR) {
                    builder.append(line.charAt(i));
                } else {
                    enclosureOpen = !enclosureOpen;
                }
            } else if (line.charAt(i) == ESCAPE_CHAR) {
                if (i - 1 >= 0 && line.charAt(i - 1) == ESCAPE_CHAR) {
                    builder.append(line.charAt(i));
                }
            } else if (line.charAt(i) != NEW_LINE_N && line.charAt(i) != NEW_LINE_R) {
                builder.append(line.charAt(i));
            }
            ++i;
        }
        cols.add(builder.toString());
        if (cols.size() > this.colCount) {
            this.colCount = cols.size();
        }
        return cols;
    }

    private void parseLineCount() throws IOException {
        this.rowCount = 0;
        try (BufferedReader reader = new BufferedReader(new FileReader(this.csvFile));){
            while (reader.readLine() != null) {
                ++this.rowCount;
            }
        }
    }

    public int getLineCount(boolean force) throws IOException {
        if (this.rowCount == 0 || force) {
            this.parseLineCount();
        }
        return this.rowCount;
    }

    public List<List<String>> getModel() {
        return this.model;
    }

    public static void main(String[] args) {
        long startMillis = System.currentTimeMillis();
        CSVUtils3 csvUtils = new CSVUtils3("/home/rfutami/Escritorio/material_gpro/ap_transcriptome_annotated_isoforms.csv");
        try {
            csvUtils.parse();
            csvUtils.setVerbose(true);
            List<List<String>> model = csvUtils.getModel();
            System.out.println("Colcount: " + csvUtils.getHeaders().size());
            System.out.println("Linecount: " + csvUtils.getLineCount(true));
            System.out.println("Last row:");
            List<String> lastRow = model.get(model.size() - 1);
            System.out.println(Arrays.toString(lastRow.toArray(new String[lastRow.size()])));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long endMillis = System.currentTimeMillis();
        long diffMillis = endMillis - startMillis;
        System.out.println(String.valueOf(diffMillis) + "ms");
    }
}

