/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.commons.model;

public class RemoteServerInfo {
    public static String Scheme_FTP = "ftp";
    public static String Scheme_SFTP = "sftp";
    public static String Scheme_FTPS = "ftps";
    public static int DEFAULT_API_PORT = 80;
    public static int DEFAULT_API_PORT_HTTPS = 443;
    public static int DEFAULT_SSH_PORT = 22;
    public static int DEFAULT_FTP_PORT = 22;
    public static String DEFAULT_FTP_SCHEME = Scheme_SFTP;
    private String serverURL;
    private String serverName;
    private String scheme = DEFAULT_FTP_SCHEME;
    private int httpPort = 80;
    private int sshPort = DEFAULT_SSH_PORT;
    private int ftpPort = DEFAULT_FTP_PORT;
    private String userHomePath = "";

    public RemoteServerInfo(String serverURL, String serverName, int httpPort, int sshPort, int ftpPort) {
        this(serverURL, serverName, httpPort, sshPort, ftpPort, "");
    }

    public RemoteServerInfo(String serverURL, String serverName, int httpPort, int sshPort, int ftpPort, String homePath) {
        this.serverURL = serverURL;
        this.serverName = serverName;
        this.httpPort = httpPort;
        this.sshPort = sshPort;
        this.ftpPort = ftpPort;
        this.userHomePath = homePath;
    }

    public RemoteServerInfo(String serverURL, String serverName) {
        this.serverURL = serverURL;
        this.serverName = serverName;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public int getFtpPort() {
        return this.ftpPort;
    }

    public void setFtpPort(int ftpPort) {
        this.ftpPort = ftpPort;
    }

    public String getUserHomePath() {
        return this.userHomePath;
    }

    public void setUserHomePath(String userHomePath) {
        this.userHomePath = userHomePath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.ftpPort;
        result = 31 * result + this.httpPort;
        result = 31 * result + (this.serverURL == null ? 0 : this.serverURL.hashCode());
        result = 31 * result + this.sshPort;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteServerInfo other = (RemoteServerInfo)obj;
        if (this.ftpPort != other.ftpPort) {
            return false;
        }
        if (this.httpPort != other.httpPort) {
            return false;
        }
        if (this.serverURL == null ? other.serverURL != null : !this.serverURL.equals(other.serverURL)) {
            return false;
        }
        return this.sshPort == other.sshPort;
    }

    public String toString() {
        return "Host Info [URL=" + this.serverURL + ":" + this.httpPort + "/ssh:" + this.sshPort + "/ftp:" + this.ftpPort + "]";
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }
}

