/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.commons.model;

import com.biotechvana.commons.ServiceHelper;
import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.model.FTPDropManager;
import com.biotechvana.commons.model.LocalDropManager;
import com.biotechvana.javabiotoolkit.io.FASTAReader;
import com.biotechvana.utils.FilenameUtils;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public abstract class DropManager {
    public static final int MODE_LOCAL = 1;
    public static final int MODE_FTP = 2;
    public static final int TYPE_FILE = 3;
    public static final int TYPE_FOLDER = 4;
    public static final int TYPE_FILES_AND_FOLDERS = 5;
    public static final int TYPE_BLAST = 6;
    public static final int TYPE_HMM = 7;
    public static final int TYPE_FASTA = 8;
    public static final int TYPE_FOLDER_ONLY = 9;
    public static final int TYPE_LIBRARY_CONFIG = 10;
    protected int operations;
    protected int mode;
    protected int type;
    protected Control control;
    protected Transfer[] transfers;
    String filesFilter = null;
    protected DropTarget target;

    protected DropManager() {
    }

    protected abstract void perfromDrop(DropTargetEvent var1);

    protected void addDropListener() {
        this.target = new DropTarget(this.control, this.operations);
        this.target.setTransfer(this.transfers);
        this.target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                DropManager.this.perfromDrop(event);
                if (!DropManager.this.control.isDisposed()) {
                    DropManager.this.control.notifyListeners(24, new Event());
                }
                if (!DropManager.this.control.isDisposed()) {
                    DropManager.this.control.notifyListeners(16, new Event());
                }
            }

            public void dragOver(DropTargetEvent event) {
            }
        });
    }

    private void addDropListener(DropTargetAdapter listener) {
        if (this.target != null && !this.target.isDisposed()) {
            this.target.addDropListener((DropTargetListener)listener);
        }
    }

    private void addDropListener(DropTargetAdapter listener, DropTargetEvent event) {
        if (this.target != null && !this.target.isDisposed()) {
            this.target.getDropListeners()[0].drop(event);
            this.target.addDropListener((DropTargetListener)listener);
        }
    }

    protected void removeManager() {
        if (this.target != null && !this.target.isDisposed()) {
            this.target.dispose();
        }
    }

    protected boolean isFastaFile(File f) throws Exception {
        boolean isFasta = false;
        try {
            FASTAReader fastaReader = new FASTAReader(f);
            fastaReader.parse();
            isFasta = fastaReader.getFastaRecords().size() != 0;
        }
        catch (Exception e) {
            throw new Exception("Cannot determine if file is FASTA");
        }
        return isFasta;
    }

    public void setFilesFilter(String filter) {
        if (!filter.isEmpty()) {
            this.filesFilter = filter;
        }
    }

    protected boolean passFilter(String ftpFile) {
        if (this.filesFilter == null) {
            return true;
        }
        String fileExt = FilenameUtils.getExtension((String)ftpFile);
        if (fileExt != null && fileExt.startsWith(".")) {
            fileExt = fileExt.substring(1);
        }
        return fileExt != null && this.filesFilter.contains(fileExt) && !fileExt.isEmpty();
    }

    public static String[] filterDatabase(String path, String[] dblist) {
        ArrayList<CallSite> filteredList = new ArrayList<CallSite>();
        String[] stringArray = dblist;
        int n = dblist.length;
        int n2 = 0;
        while (n2 < n) {
            String dbName;
            String s = stringArray[n2];
            int firstDot = s.indexOf(46);
            if (!((s.equals(".") || s.equals("..") || s.indexOf(".nhr") < 0) && s.indexOf(".phr") < 0 || filteredList.contains(path + "/" + (dbName = s.substring(0, firstDot))))) {
                filteredList.add((CallSite)((Object)(path + "/" + dbName)));
            }
            ++n2;
        }
        return filteredList.toArray(new String[filteredList.size()]);
    }

    public static String[] filterHMM(String path, String[] dblist) {
        HashSet<CallSite> nameSet = new HashSet<CallSite>();
        String[] stringArray = dblist;
        int n = dblist.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int firstDot = s.lastIndexOf(".");
            if (!s.equals(".") && !s.equals("..") && (s.contains(".hmm") || s.contains(".HMM") || s.contains(".h3m"))) {
                if (firstDot > 0) {
                    nameSet.add((CallSite)((Object)(path + "/" + s.substring(0, firstDot))));
                } else {
                    nameSet.add((CallSite)((Object)(path + "/" + s)));
                }
            }
            ++n2;
        }
        return nameSet.toArray(new String[nameSet.size()]);
    }

    public static DropManager create(Control control, int mode, int type) {
        if (mode == 1) {
            return new LocalDropManager(control, type);
        }
        if (mode == 2) {
            IFTPManager ftpManager = (IFTPManager)ServiceHelper.getEclipseContext().get(IFTPManager.class);
            FTPDropManager ftpDropManager = new FTPDropManager(control, type);
            ftpDropManager.setFTPManager(ftpManager);
            return ftpDropManager;
        }
        return null;
    }

    @Deprecated
    public static FTPDropManager create(Control control, int type, String ftpHost, String ftpPort, String ftpUser, String ftpPassword) {
        IFTPManager ftpManager = (IFTPManager)ServiceHelper.getEclipseContext().get(IFTPManager.class);
        FTPDropManager ftpDropManager = new FTPDropManager(control, type, ftpHost, ftpPort, ftpUser, ftpPassword);
        ftpDropManager.setFTPManager(ftpManager);
        return ftpDropManager;
    }

    @Deprecated
    public static DropManager create(Control control, int operations, Transfer[] transfers, int mode, int type) {
        if (mode == 1) {
            return new LocalDropManager(control, operations, transfers, mode, type);
        }
        if (mode == 2) {
            IFTPManager ftpManager = (IFTPManager)ServiceHelper.getEclipseContext().get(IFTPManager.class);
            FTPDropManager ftpDropManager = new FTPDropManager(control, operations, transfers, type);
            ftpDropManager.setFTPManager(ftpManager);
            return ftpDropManager;
        }
        return null;
    }
}

