/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.wizards.pages;

import com.biotechvana.utils.FilenameUtils;
import com.biotechvana.workflow.VariablesRule;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.configuration.IConfigurationWithReference;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.wizards.pages.WorkflowWizardPage;
import org.eclipse.swt.widgets.Label;

public class MapperReferenceJobCollector
extends WorkflowJob {
    public static final String INPUT_INDEX_CHOICE = "INPUT_INDEX_CHOICE";
    public static final String INPUT_INDEX_FILE = "INPUT_INDEX_FILE";
    public static final String INPUT_INDEX_FASTA_FILE = "INDEX_FASTA_FILE";
    public static final String INPUT_INDEX_PREFIX = "INPUT_INDEX_PREFIX";
    public static final String INPUT_GTF_FILE = "INPUT_GTF_FILE";
    public static final String INPUT_INDEX_MAPPER = "INPUT_INDEX_MAPPER";
    static final String Mapper_Bwa = "bwa";
    static final String Mapper_Bowtie2 = "Bowtie2";
    static final String Mapper_Tophat = "Tophat";
    static final String Mapper_Hisat2 = "hisat2";
    static final String Mapper_STAR = "STAR";
    private IConfigurationWithReference expConfig;
    private Label infoLabel;
    private boolean isPairEnd;
    boolean withGTF;
    String pipelineMapper;
    WorkflowWizardPage wizardPage;

    public MapperReferenceJobCollector(IConfigurationWithReference expConfig, Label infoLabel, WorkflowWizardPage wizardPage) {
        this.expConfig = expConfig;
        this.infoLabel = infoLabel;
        this.jobName = "Reference Options";
        this.jobDesc = new JobDescriptor("Reference_Options");
        this.isPairEnd = expConfig.getWorkflow().getMetadata().hasTag("pairend");
        this.withGTF = expConfig.isWithGTF() || expConfig.getWorkflow().getMetadata().hasTag("GTF/GFF");
        this.pipelineMapper = expConfig.getMapperName();
        this.wizardPage = wizardPage;
        VariableDescriptor varIndexChioce = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_CHOICE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varIndexChioce.isRequired = true;
        varIndexChioce.setVariableName("Create new index from a Fasta File");
        varIndexChioce.setHelpMsg("Create new Index from a Fasta File or Use an exisiting index.");
        varIndexChioce.setDefaultValue("false");
        this.jobDesc.addVariable(varIndexChioce);
        if (this.pipelineMapper == Mapper_STAR) {
            varUsedIndexFile = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Folder, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
            varUsedIndexFile.isRequired = true;
            varUsedIndexFile.setVariableName("Genome Index Directory");
            varUsedIndexFile.setShortHelpMsg("Drag an Existing STAR referenece genome index folder");
            varUsedIndexFile.setHelpMsg("Directory where genome indices files are stored and genereted by STAR from prevoius runs.");
            varUsedIndexFile.setCommandParamater("--genomeDir");
            varUsedIndexFile.setSubProgName("_NO_CMD_");
            this.jobDesc.addVariable(varUsedIndexFile);
            varIndexFile = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
            varIndexFile.isRequired = true;
            varIndexFile.setVariableName("Input Reference Fasta File");
            varIndexFile.setHelpMsg("Reference Fasta file with genome reference sequences to build a new index.");
            varIndexFile.setShortHelpMsg("Drag a Fasta file to build a new index.");
            varIndexFile.setCommandParamater("--genomeFastaFiles");
            varIndexFile.setSubProgName("_NO_CMD_");
            this.jobDesc.addVariable(varIndexFile);
            VariableDescriptor varIndexFilePrefix = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_PREFIX, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Folder, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
            varIndexFilePrefix.setVariableName("Genome directory");
            varIndexFilePrefix.setHelpMsg("Specifies path to the directory, where the genome indices are stored. The file system needs to have at least 100GB of diskspace available for a typical mammalian genome. It is recommended to remove all files from the genome directory before running the genome generation step. This directory path will be supplied at the mapping step to identify the reference genome. If not provided a directory will be created insided the job output folder.");
            varIndexFilePrefix.setCommandParamater("--genomeDir");
            varIndexFilePrefix.setSubProgName("_NO_CMD_");
            this.jobDesc.addVariable(varIndexFilePrefix);
        } else {
            varUsedIndexFile = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
            varUsedIndexFile.isRequired = true;
            varUsedIndexFile.setVariableName("Index File");
            varUsedIndexFile.setShortHelpMsg("Drag an Existing index file.");
            varUsedIndexFile.setHelpMsg("Make sure that the index is in the same format used by the mapper that is selected in the protocol.");
            this.jobDesc.addVariable(varUsedIndexFile);
            varIndexFile = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
            varIndexFile.isRequired = true;
            varIndexFile.setVariableName("Input Reference Fasta File");
            varIndexFile.setHelpMsg("Reference Fasta file to build a new index.");
            varIndexFile.setShortHelpMsg("Drag a Fasta file to build a new index.");
            this.jobDesc.addVariable(varIndexFile);
            VariableDescriptor varIndexFilePrefix = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_PREFIX, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
            varIndexFilePrefix.setVariableName("Prefix");
            varIndexFilePrefix.setIsFileName(true);
            varIndexFilePrefix.setHelpMsg("A prefix name for the output index file. Defualt value is the same as the prefix of the input Fasta File Name.");
            this.jobDesc.addVariable(varIndexFilePrefix);
        }
        VariableDescriptor tempVar = VariableDescriptor.createDescriptorFor((String)"RM", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        tempVar.setVariableName("Stop the pipeline if the % of reads successfully mapped against the reference less than:");
        tempVar.setHelpMsg("Mapping filter rule to control pipeline execution.");
        tempVar.setDefaultValue("80");
        tempVar.setVariableGroup("Mapping filter rules");
        this.jobDesc.addVariable(tempVar);
        tempVar = VariableDescriptor.createDescriptorFor((String)INPUT_INDEX_MAPPER, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        tempVar.setVariableName("Mapper Type");
        this.jobDesc.addVariable(tempVar);
        if (this.withGTF) {
            VariableDescriptor varGTFFile = VariableDescriptor.createDescriptorFor((String)INPUT_GTF_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
            varGTFFile.isRequired = !expConfig.isOptionalGTF();
            varGTFFile.setVariableName("GTF-guide file");
            varGTFFile.setHelpMsg("Reference genome GTF guide file");
            this.jobDesc.addVariable(varGTFFile);
        }
        this.initJobFromDesc(this.jobDesc, false, false, false);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_FILE), VariablesRule.Condition.False, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_FASTA_FILE), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
        new VariablesRule(this.getVariable(INPUT_INDEX_CHOICE), this.getVariable(INPUT_INDEX_PREFIX), VariablesRule.Condition.True, VariablesRule.Action.Enable, true);
    }

    public boolean notifyVarValueChanged(String varKey, String value) {
        if (varKey.equals(INPUT_INDEX_FASTA_FILE)) {
            this.expConfig.setReferenceIndexSourceFastaFile(value, true);
        }
        if (varKey.equals(INPUT_INDEX_PREFIX)) {
            this.expConfig.setReferenecePrefix(value);
        }
        if (varKey.equals(INPUT_INDEX_FILE)) {
            this.expConfig.setReferenceIndex(value);
        }
        if (varKey.equals(INPUT_GTF_FILE)) {
            this.expConfig.setRefereneceGTF(value);
        }
        varKey.equals(INPUT_INDEX_MAPPER);
        if (varKey.equals(INPUT_INDEX_CHOICE)) {
            if (value.equals("true")) {
                this.infoLabel.setVisible(true);
                this.infoLabel.setText("");
            } else {
                this.infoLabel.setVisible(true);
            }
        }
        return true;
    }

    public String notifyVarValueChanging(String varKey, String value) {
        try {
            if (varKey.equals(INPUT_INDEX_FILE)) {
                this.infoLabel.setForeground(this.infoLabel.getDisplay().getSystemColor(9));
                String refIndex = value;
                String ext = FilenameUtils.getExtension((String)refIndex);
                System.out.println(value);
                if (this.pipelineMapper == Mapper_STAR) {
                    this.infoLabel.setText("A directory is selected.");
                    this.setValue(INPUT_INDEX_MAPPER, Mapper_STAR);
                    return value;
                }
                if (ext != null && (ext.equals(".bt2") || ext.equals(".bt") || ext.equals(".bt2l"))) {
                    String raw = FilenameUtils.getBasename((String)refIndex, (boolean)true);
                    raw = FilenameUtils.getBasename((String)raw, (boolean)true);
                    String path = org.apache.commons.io.FilenameUtils.getPath((String)refIndex);
                    System.out.println(path);
                    this.getVariable(INPUT_INDEX_FILE).setWarning("Bowtie Index detected.");
                    this.infoLabel.setText("Bowtie Index detected.");
                    this.setValue(INPUT_INDEX_MAPPER, Mapper_Bowtie2);
                    return "/" + path + raw;
                }
                if (ext != null && (ext.equals(".ht2") || ext.equals(".ht"))) {
                    String raw = FilenameUtils.getBasename((String)refIndex, (boolean)true);
                    String ext2 = FilenameUtils.getExtension((String)(raw = FilenameUtils.getBasename((String)raw, (boolean)true)), (boolean)true);
                    if (ext2 != null && ext2.equals(".rev")) {
                        raw = FilenameUtils.getBasename((String)raw, (boolean)true);
                    }
                    String path = org.apache.commons.io.FilenameUtils.getPath((String)refIndex);
                    this.getVariable(INPUT_INDEX_FILE).setWarning("Hisat2 Index detected.");
                    this.infoLabel.setText("Hisat2 Index detected.");
                    this.setValue(INPUT_INDEX_MAPPER, Mapper_Hisat2);
                    return "/" + path + raw;
                }
                if (ext != null && (ext.equals(".amb") || ext.equals(".ann") || ext.equals(".bwt") || ext.equals(".pac") || ext.equals(".sa"))) {
                    String raw = FilenameUtils.getBasename((String)refIndex, (boolean)true);
                    String path = org.apache.commons.io.FilenameUtils.getPath((String)refIndex);
                    this.getVariable(INPUT_INDEX_FILE).setWarning("BWA Index detected.");
                    this.infoLabel.setText("BWA Index detected.");
                    this.setValue(INPUT_INDEX_MAPPER, Mapper_Bwa);
                    return "/" + path + raw;
                }
                this.infoLabel.setText("Unable to detect the index type.");
                this.setValue(INPUT_INDEX_MAPPER, "");
                this.getVariable(INPUT_INDEX_FILE).setWarning("Unable to detect the index type.");
            }
        }
        catch (Exception ex) {
            System.out.println("notifyVarValueChanging Error in " + varKey + "  " + this.getJobDescID());
        }
        return value;
    }

    public boolean isValid() {
        String targetMapper;
        boolean match;
        boolean isValid = super.isValid();
        if (!this.expConfig.isBuildNew() && !(match = this.expConfig.checkMapperRefAgaisntWorkflowMapper(targetMapper = this.getValue(INPUT_INDEX_MAPPER)))) {
            isValid = false;
            this.getVariable(INPUT_INDEX_FILE).setExternalErrMsg("Selected Reference does not match selected pipeline mapper.");
        }
        return isValid;
    }
}

