/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.wizards.pages;

import com.biotechvana.workflow.configuration.IConfigurationWithGroups;
import com.biotechvana.workflow.configuration.IConfigurationWithInputFileList;
import com.biotechvana.workflow.groups.ExperimentGroup;
import com.biotechvana.workflow.groups.GroupAssignment;
import com.biotechvana.workflow.groups.ui.GroupAssignmentControl;
import com.biotechvana.workflow.groups.ui.GroupManagementControl;
import com.biotechvana.workflow.groups.ui.InputExpGroupJobCollector;
import com.biotechvana.workflow.wizards.pages.WorkflowWizardPage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

@Creatable
public class ExperimentGroupsPage
extends WorkflowWizardPage {
    private InputExpGroupJobCollector refJobCollector;
    GroupAssignmentControl groupAssignmentControl;
    private GroupManagementControl groupManagementControl;
    IConfigurationWithGroups wfConfigWithGroups;
    boolean isValid = false;
    boolean groupsIsValid = false;
    boolean assignemntAreValid = false;
    String validMsg = "";

    public ExperimentGroupsPage() {
        super("Manage Experiments Groups");
        this.setTitle("Manage Experiments Groups");
        this.setDescription("Define and/or assign experiments group to your Library/Samples");
    }

    @Override
    protected void validate() {
        this.setErrorMessage(null);
        if (!this.isValid && !this.validMsg.isEmpty()) {
            this.setErrorMessage(this.validMsg);
        }
        this.setPageComplete(this.isValid);
    }

    @Override
    protected void onCreatePageControl(Composite container) {
        Assert.isLegal((boolean)(this.wfConfig instanceof IConfigurationWithGroups));
        this.wfConfigWithGroups = (IConfigurationWithGroups)this.wfConfig;
        Label infoLabel = new Label(container, 0);
        infoLabel.setForeground(container.getDisplay().getSystemColor(9));
        infoLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite row = this.createRow(container, 3);
        this.groupManagementControl = new GroupManagementControl();
        this.groupManagementControl.createControl(row);
        this.groupAssignmentControl = new GroupAssignmentControl();
        this.groupAssignmentControl.setLibrary(((IConfigurationWithInputFileList)this.wfConfig).getLibrary());
        this.groupManagementControl.setGroupAssignmentControl(this.groupAssignmentControl);
        this.groupAssignmentControl.createControl(container);
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg) {
                List<ExperimentGroup> groups;
                boolean localIsValid = true;
                ExperimentGroupsPage.this.validMsg = "";
                if (arg.getPropertyName().equals("groups")) {
                    ExperimentGroupsPage.this.groupsIsValid = false;
                    groups = ExperimentGroupsPage.this.groupManagementControl.getExperimentGroups();
                    if (groups.size() <= 1) {
                        localIsValid = false;
                        ExperimentGroupsPage.this.validMsg = "You need to add at least two groups;";
                    }
                    if (localIsValid) {
                        ExperimentGroupsPage.this.wfConfigWithGroups.setGroups(groups.toArray(new ExperimentGroup[0]));
                        ExperimentGroupsPage.this.groupsIsValid = true;
                    }
                }
                if (arg.getPropertyName().equals("groupsAssignment") || ExperimentGroupsPage.this.groupsIsValid) {
                    ExperimentGroupsPage.this.assignemntAreValid = false;
                    groups = ExperimentGroupsPage.this.groupAssignmentControl.getGroups();
                    if (groups == null) {
                        localIsValid = false;
                        ExperimentGroupsPage.this.validMsg = "You need to add at least two groups;";
                    } else {
                        for (ExperimentGroup group : groups) {
                            if (group.getNumberOfSample() != 0) continue;
                            localIsValid = false;
                            ExperimentGroupsPage.this.validMsg = "Group " + group.getGroupLabel() + " Does not Contains any assignment";
                            break;
                        }
                    }
                    if (localIsValid) {
                        GroupAssignment[] assignments;
                        GroupAssignment[] groupAssignmentArray = assignments = ExperimentGroupsPage.this.groupAssignmentControl.getGroupAssignments();
                        int n = assignments.length;
                        int n2 = 0;
                        while (n2 < n) {
                            GroupAssignment assignment = groupAssignmentArray[n2];
                            if (assignment.getExperimentGroup() == null) {
                                localIsValid = false;
                                ExperimentGroupsPage.this.validMsg = "Still missing some Sample/Library assignment.";
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (localIsValid) {
                        for (ExperimentGroup group : groups) {
                            ExperimentGroupsPage.this.wfConfigWithGroups.setGroupAssignment(group.getGroupLabel(), group.getSamples());
                        }
                        ExperimentGroupsPage.this.assignemntAreValid = true;
                    }
                }
                ExperimentGroupsPage.this.isValid = ExperimentGroupsPage.this.assignemntAreValid && ExperimentGroupsPage.this.groupsIsValid;
                ExperimentGroupsPage.this.validate();
            }
        };
        this.groupManagementControl.addPropertyChangeListener(pcl);
        this.groupAssignmentControl.addPropertyChangeListener(pcl);
    }

    @Override
    public void onPageDisplay() {
        if (this.groupAssignmentControl != null) {
            this.groupAssignmentControl.setLibrary(((IConfigurationWithInputFileList)this.wfConfig).getLibrary());
            this.groupAssignmentControl.setGroupAssignments(this.wfConfigWithGroups.getGroupAssignments());
        }
    }
}

