/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.views;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.users.UserManager;
import com.biotechvana.workflow.IWorkflowJobComposite;
import com.biotechvana.workflow.VariableControl;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.ui.variables.VariableComposite;
import com.biotechvana.workflow.variables.JobVariable;
import java.util.ArrayList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class VariableSearchViewer {
    Composite helpFromComposite;
    Composite helpFormCompositeBody = null;
    ScrolledComposite scrolledComposite_HelpForm = null;
    SashForm container;
    private boolean searchIsVisable = false;
    int[] weightsMainToHelp = new int[]{3, 1};

    public VariableSearchViewer(SashForm container) {
        this.container = container;
    }

    public void close() {
        if (this.searchIsVisable) {
            this.weightsMainToHelp = this.container.getWeights();
            this.helpFromComposite.dispose();
            this.helpFormCompositeBody = null;
            this.helpFromComposite = null;
            this.scrolledComposite_HelpForm = null;
            this.container.setWeights(new int[]{1});
            this.searchIsVisable = false;
        }
    }

    public boolean isVisable() {
        return this.searchIsVisable;
    }

    public void show(final WorkflowJob workflowJob) {
        if (!this.searchIsVisable) {
            this.helpFromComposite = new Composite((Composite)this.container, 2048);
            this.helpFromComposite.setLayout((Layout)new GridLayout(1, false));
            CTabFolder tabFolder = new CTabFolder(this.helpFromComposite, 2048);
            tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            tabFolder.setTabHeight(30);
            CTabItem tbtmNewItem = new CTabItem(tabFolder, 0);
            tbtmNewItem.setShowClose(true);
            tbtmNewItem.setText("Search");
            tbtmNewItem.setImage(SharedImages.SEARCH);
            tabFolder.setSelection(tbtmNewItem);
            this.scrolledComposite_HelpForm = new ScrolledComposite((Composite)tabFolder, 768);
            tbtmNewItem.setControl((Control)this.scrolledComposite_HelpForm);
            this.scrolledComposite_HelpForm.setExpandHorizontal(true);
            this.scrolledComposite_HelpForm.setExpandVertical(true);
            this.helpFormCompositeBody = new Group((Composite)this.scrolledComposite_HelpForm, 2048);
            ((Group)this.helpFormCompositeBody).setText("Search Result :");
            this.helpFormCompositeBody.setLayout((Layout)new GridLayout(1, false));
            final IWorkflowJobComposite miniCompo = new IWorkflowJobComposite(){
                WorkflowJob job;

                public void update(Observable o, Object arg) {
                    VariableSearchViewer.this.helpFormCompositeBody.layout(true);
                    Point newSize = VariableSearchViewer.this.helpFormCompositeBody.computeSize(VariableSearchViewer.this.helpFormCompositeBody.getSize().x, -1, true);
                    VariableSearchViewer.this.scrolledComposite_HelpForm.setMinHeight(newSize.y);
                }

                public void requestShowHelp(JobVariable var) {
                }

                public void removeVarComposite(VariableControl variableComposite) {
                }

                public void addVarComposite(VariableControl variableComposite) {
                    variableComposite.toggleHelpMsg();
                }

                public void bindWorkflowJob(WorkflowJob job) {
                    this.job = job;
                    job.addObserver((Observer)((Object)this));
                }

                public int varsCommandParamaterMaxStrLen() {
                    return 0;
                }

                public WorkflowJob getWorkflowJob() {
                    return this.job;
                }

                public boolean supportShowHelp() {
                    return false;
                }

                public UserManager getUserManager() {
                    return null;
                }
            };
            miniCompo.bindWorkflowJob(workflowJob);
            this.helpFormCompositeBody.setData((Object)miniCompo);
            this.helpFormCompositeBody.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    workflowJob.deleteObserver((Observer)miniCompo);
                }
            });
            this.scrolledComposite_HelpForm.setContent((Control)this.helpFormCompositeBody);
            tabFolder.addCTabFolder2Listener(new CTabFolder2Listener(){

                public void showList(CTabFolderEvent event) {
                }

                public void restore(CTabFolderEvent event) {
                }

                public void minimize(CTabFolderEvent event) {
                }

                public void maximize(CTabFolderEvent event) {
                }

                public void close(CTabFolderEvent event) {
                    VariableSearchViewer.this.close();
                }
            });
            this.searchIsVisable = true;
            this.container.setWeights(this.weightsMainToHelp);
        } else if (this.helpFormCompositeBody != null) {
            Control[] controlArray = this.helpFormCompositeBody.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.dispose();
                ++n2;
            }
        }
    }

    void bindSearchResult(ArrayList<JobVariable> vars) {
        if (vars == null || vars.isEmpty()) {
            Label resultLabel = new Label(this.helpFormCompositeBody, 0);
            resultLabel.setText("No Result Found !");
        } else {
            int colorIndex = 0;
            for (JobVariable var : vars) {
                if (var.descHasEnableActions()) continue;
                VariableComposite varComposite = VariableComposite.createJobVariableComposite((Composite)this.helpFormCompositeBody, (IWorkflowJobComposite)((IWorkflowJobComposite)this.helpFormCompositeBody.getData()), (JobVariable)var, (int)0);
                GridData layoutData = new GridData(4, 1, true, false, 1, 1);
                varComposite.setLayoutData((Object)layoutData);
                varComposite.setColor(colorIndex);
                varComposite.toggleHelpMsg();
                ++colorIndex;
            }
        }
        this.helpFormCompositeBody.layout(true);
        Point newSize = this.helpFormCompositeBody.computeSize(this.helpFormCompositeBody.getSize().x, -1, true);
        this.scrolledComposite_HelpForm.setMinHeight(newSize.y);
    }
}

