/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.views;

import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.manager.WorkflowCatalog;
import com.biotechvana.workflow.template.WorkflowTemplate;
import com.biotechvana.workflow.ui.widgets.WorkflowVis;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PipelineSelectorDialog
extends Dialog {
    IWorkflowManager workflowManager;
    private TableViewer tableViewer;
    private Table table;
    WorkflowVis workflowVis;
    Composite container;
    WorkflowTemplate curSelected = null;
    WorkflowTemplate[] allSavedWorkflows;
    boolean hasFilters = false;
    boolean negateFilter = false;
    String tag = "";
    String isPE = "";

    public PipelineSelectorDialog(Shell parentShell, IWorkflowManager workflowManager) {
        super(parentShell);
        this.workflowManager = workflowManager;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Pipeline");
    }

    protected Point getInitialSize() {
        return new Point(1024, 800);
    }

    protected Control createDialogArea(Composite parent) {
        this.container = (Composite)super.createDialogArea(parent);
        this.createPartControl(this.container);
        return this.container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, "Cancel", false);
        this.createButton(parent, 0, "Ok", true);
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite upperPart = new Composite(parent, 2048);
        GridData layoutData = new GridData(4, 1, true, false);
        upperPart.setLayoutData((Object)layoutData);
        upperPart.setLayout((Layout)new GridLayout(2, false));
        Label headingText = new Label(upperPart, 0);
        layoutData = new GridData(4, 4, true, true, 2, 1);
        headingText.setLayoutData((Object)layoutData);
        headingText.setText("Select A Pipeline");
        this.tableViewer = new TableViewer(upperPart, 68352);
        layoutData = new GridData(4, 1, true, false, 1, 3);
        layoutData.heightHint = 250;
        layoutData.widthHint = 400;
        this.tableViewer.getControl().setLayoutData((Object)layoutData);
        this.table = this.tableViewer.getTable();
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Name");
        tblclmn.setWidth(150);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Author");
        tblclmn.setWidth(150);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tableViewerColumn = new TableViewerColumn(this.tableViewer, 0);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Type");
        tblclmn.setWidth(100);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tableViewerColumn = new TableViewerColumn(this.tableViewer, 8);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Ref");
        tblclmn.setWidth(200);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tableViewerColumn = new TableViewerColumn(this.tableViewer, 8);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Desc");
        tblclmn.setWidth(250);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(16384);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                String missing = "--";
                WorkflowTemplate entry = (WorkflowTemplate)element;
                switch (columnIndex) {
                    case 0: {
                        if (entry.getMetadata() != null) {
                            return entry.getMetadata().getName();
                        }
                        return entry.getDefaultWorkflowName();
                    }
                    case 1: {
                        if (entry.getMetadata() != null) {
                            return entry.getMetadata().getAuthor();
                        }
                        return missing;
                    }
                    case 2: {
                        return missing;
                    }
                    case 3: {
                        if (entry.getMetadata() != null) {
                            return entry.getMetadata().getRef();
                        }
                        return missing;
                    }
                    case 4: {
                        if (entry.getMetadata() != null) {
                            return entry.getMetadata().getDesc();
                        }
                        return missing;
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                WorkflowTemplate entry;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                PipelineSelectorDialog.this.curSelected = entry = (WorkflowTemplate)selection.getFirstElement();
                if (entry != null) {
                    PipelineSelectorDialog.this.workflowVis.setWorkflow(entry);
                }
            }
        });
        Composite lowerPart = new Composite(parent, 2048);
        layoutData = new GridData(4, 4, true, true);
        lowerPart.setLayoutData((Object)layoutData);
        lowerPart.setLayout((Layout)new FillLayout());
        TabFolder upperFolder = new TabFolder(lowerPart, 128);
        upperFolder.setLayout((Layout)new FillLayout());
        TabItem item1 = new TabItem(upperFolder, 2048);
        this.workflowVis = new WorkflowVis((Composite)upperFolder, 0, this.workflowManager);
        item1.setControl((Control)this.workflowVis);
        item1.setText("Selected Pipeline");
        this.refreshWorkflow();
    }

    private void refreshWorkflow() {
        WorkflowCatalog catalog = this.workflowManager.getWorkflowCatalog();
        if (catalog != null) {
            if (this.hasFilters) {
                ArrayList list = WorkflowCatalog.filterTemplatesByHasTag((List)catalog.getWorkflowTemplates(), (String[])new String[]{this.tag}, (!this.negateFilter ? 1 : 0) != 0, (boolean)true);
                if (!this.isPE.isEmpty()) {
                    list = WorkflowCatalog.filterTemplatesByHasTag((List)list, (String[])new String[]{this.isPE}, (boolean)true, (boolean)true);
                }
                this.allSavedWorkflows = list.toArray(new WorkflowTemplate[list.size()]);
            } else {
                this.allSavedWorkflows = catalog.getWorkflowTemplatesAsArray();
            }
            this.tableViewer.setInput((Object)this.allSavedWorkflows);
        }
    }

    public WorkflowTemplate getSelectedWorkflow() {
        if (this.curSelected != null) {
            return this.curSelected;
        }
        return null;
    }

    public void setFilter(String tag) {
        this.hasFilters = true;
        this.tag = tag;
    }

    public void setFilter(String tag, boolean not) {
        this.hasFilters = true;
        this.negateFilter = not;
        this.tag = tag;
    }

    public void setFilterPE() {
        this.isPE = "pair";
    }

    public void setFilterSE() {
        this.isPE = "single";
    }
}

