/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ui.menus;

import com.biotechvana.workflow.ui.menus.JobsToolBoxItem;
import com.biotechvana.workflow.ui.menus.JobsToolBoxItemList;
import java.util.ArrayList;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class JobsToolBox {
    String toolBoxName = "JOBS View";
    public ArrayList<JobsToolBoxItem> items = new ArrayList();

    public void addItem(JobsToolBoxItem item) {
        this.items.add(item);
    }

    public void setName(String name) {
        this.toolBoxName = name;
    }

    public void renderAsToolBarItems(ToolBar toolBar, SelectionAdapter menuClick) {
        this.renderAsToolBarItems(toolBar, menuClick, true);
    }

    public void renderAsToolBarItems(final ToolBar toolBar, SelectionAdapter menuClick, boolean jobsOnly) {
        SelectionAdapter showMenu = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolItem selected = (ToolItem)e.getSource();
                Menu selectedMenu = (Menu)selected.getData();
                Rectangle rect = selected.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = toolBar.toDisplay(pt);
                selectedMenu.setLocation(pt.x, pt.y);
                selectedMenu.setVisible(true);
            }
        };
        for (JobsToolBoxItem item : this.items) {
            int style = 8;
            if (item instanceof JobsToolBoxItemList) {
                style = 4;
            }
            ToolItem toolItem = new ToolItem(toolBar, style);
            toolItem.setText(item.getName());
            if (item instanceof JobsToolBoxItemList) {
                Menu itemMenu = new Menu((Control)toolBar.getShell());
                item.renderAsToolBarItems(itemMenu, menuClick);
                toolItem.setData((Object)itemMenu);
                toolItem.addSelectionListener((SelectionListener)showMenu);
                continue;
            }
            toolItem.setData((Object)item);
            toolItem.addSelectionListener((SelectionListener)menuClick);
        }
    }

    public void renderAsMenuItems(IMenuManager menuBar) {
        for (JobsToolBoxItem item : this.items) {
            MenuManager menuItem = new MenuManager(item.getName());
            menuBar.add((IContributionItem)menuItem);
            item.renderAsMenuItem(menuItem);
        }
    }

    public String getName() {
        return this.toolBoxName;
    }
}

