/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.workflow.ext;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.Workflow;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.submissionhistory.RawTrackingLogEntry;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.biotechvana.workflow.tracking.ITrackerInfo;
import com.biotechvana.workflow.tracking.TrackInfo;
import com.biotechvana.workflow.tracking.TrackerInfoEntry;
import com.biotechvana.workflow.tracking.UITaskTrackInfo;
import com.biotechvana.workflow.tracking.events.CheckTrackEvent;
import com.biotechvana.workflow.ui.WorkflowUI;
import com.biotechvana.workflow.ui.widgets.ConsoleLog;
import com.biotechvana.workflow.ui.widgets.WorkflowVis;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TrackingComposite
extends Composite {
    private SashForm topForm;
    private SashForm upperFrom;
    private Group jobHolder;
    private Group tabelCompsite;
    int[] upperFromW = new int[]{1, 2};
    ConsoleLog consoleLog;
    WorkflowVis preWorkflowVis;
    TableViewer rawTrackViewer;
    TableViewer taskTableViewer;
    TableColumn tblclmnTasksOrFiles;
    private SubmissionHistoryEntry curEntry;
    private TrackInfo selectedLogInfo = null;
    boolean tmpClearSelection = true;
    WorkflowJob preSelectedJob = null;

    public TrackingComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout(256));
        this.topForm = new SashForm((Composite)this, 68096);
        this.upperFrom = new SashForm((Composite)this.topForm, 2048);
        this.tabelCompsite = new Group((Composite)this.upperFrom, 0);
        this.tabelCompsite.setLayout((Layout)new FillLayout());
        this.tabelCompsite.setText("Track Events : ");
        TabFolder tabFolder = new TabFolder((Composite)this.tabelCompsite, 1024);
        TabItem taskTab = new TabItem(tabFolder, 0);
        taskTab.setText("Tasks");
        Composite taskTableComosite = new Composite((Composite)tabFolder, 0);
        this.createTaskTable(taskTableComosite);
        taskTab.setControl((Control)taskTableComosite);
        taskTab.setImage(SharedImages.DEFAULTEDITOR);
        TabItem warningTab = new TabItem(tabFolder, 0);
        warningTab.setText("Warning");
        warningTab.setImage(SharedImages.LOG_WARNNING);
        TabItem rawTrackTab = new TabItem(tabFolder, 0);
        rawTrackTab.setText("Raw Track");
        Composite rawTrackComosite = new Composite((Composite)tabFolder, 0);
        this.createRawTrackTable(rawTrackComosite);
        rawTrackTab.setControl((Control)rawTrackComosite);
        rawTrackTab.setImage(SharedImages.FILE);
        this.upperFrom.setWeights(new int[]{1});
        TabFolder composite_2 = new TabFolder((Composite)this.topForm, 0);
        composite_2.setLayout((Layout)new FillLayout(256));
        TabItem logPage = new TabItem(composite_2, 0);
        logPage.setText("Log File");
        logPage.setImage(SharedImages.LOG);
        Group grpLogFile = new Group((Composite)composite_2, 0);
        logPage.setControl((Control)grpLogFile);
        grpLogFile.setLayout((Layout)new FillLayout(256));
        this.consoleLog = new ConsoleLog((Composite)grpLogFile);
        this.topForm.setWeights(new int[]{1, 1});
    }

    private void createRawTrackTable(Composite rawTrackComosite) {
        rawTrackComosite.setLayout((Layout)new FillLayout());
        this.rawTrackViewer = new TableViewer(rawTrackComosite, 68352);
        Table table = this.rawTrackViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setToolTipText("Raw Track Event generated by th Job on the server.");
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.rawTrackViewer, 0);
        TableColumn tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Time");
        tblclmn.setWidth(150);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tableViewerColumn = new TableViewerColumn(this.rawTrackViewer, 0);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Event");
        tblclmn.setWidth(500);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(16384);
        this.rawTrackViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                TrackInfo trackInfo = (TrackInfo)inputElement;
                List entries = trackInfo.getRawTrackingLogEntries();
                Object[] allList = entries.toArray(new RawTrackingLogEntry[entries.size()]);
                return allList;
            }
        });
        this.rawTrackViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                RawTrackingLogEntry entry = (RawTrackingLogEntry)element;
                switch (columnIndex) {
                    case 0: {
                        return entry.time;
                    }
                    case 1: {
                        return entry.msg;
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                if (columnIndex == 1) {
                    RawTrackingLogEntry entry = (RawTrackingLogEntry)element;
                    if (entry.type == Tracking.TrackEventType.Check && entry.entry != null && entry.entry instanceof CheckTrackEvent) {
                        if (((CheckTrackEvent)entry.entry).getCheckStatus() == Tracking.TrackCheckLevels.Fail) {
                            return SharedImages.FILE_ERROR;
                        }
                        if (((CheckTrackEvent)entry.entry).getCheckStatus() == Tracking.TrackCheckLevels.Pass) {
                            return SharedImages.FILE_OK;
                        }
                        if (((CheckTrackEvent)entry.entry).getCheckStatus() == Tracking.TrackCheckLevels.Warning) {
                            return SharedImages.FILE_WARNING;
                        }
                    }
                    if (entry.type == Tracking.TrackEventType.Processing) {
                        return SharedImages.PROCESS_INFO;
                    }
                    if (entry.type == Tracking.TrackEventType.Warning) {
                        return SharedImages.FILE_WARNING;
                    }
                    if (entry.type == Tracking.TrackEventType.Started) {
                        return SharedImages.PROCESS_INFO;
                    }
                    if (entry.type == Tracking.TrackEventType.Paused) {
                        return SharedImages.PROCESS_INFO;
                    }
                    if (entry.type == Tracking.TrackEventType.Resumed) {
                        return SharedImages.PROCESS_INFO;
                    }
                    if (entry.type == Tracking.TrackEventType.Processed) {
                        return SharedImages.PROCESS_OK;
                    }
                    if (entry.type == Tracking.TrackEventType.ProcessingFail) {
                        return SharedImages.PROCESS_ERROR;
                    }
                    if (entry.type == Tracking.TrackEventType.Failed) {
                        return SharedImages.PROCESS_ERROR;
                    }
                    if (entry.type == Tracking.TrackEventType.Canceled) {
                        return SharedImages.PROCESS_ERROR;
                    }
                    if (entry.type == Tracking.TrackEventType.Ended) {
                        return SharedImages.PROCESS_OK;
                    }
                    return SharedImages.FILE_INFO;
                }
                return null;
            }
        });
    }

    @Deprecated
    void expandRaw(ArrayList<RawTrackingLogEntry> entries, TrackInfo trackInfo) {
        RawTrackingLogEntry taskInfos = new RawTrackingLogEntry();
        taskInfos.time = trackInfo.getTime();
        taskInfos.msg = "Start Running : " + trackInfo.getTaskName() + ". ";
        taskInfos.type = Tracking.TrackEventType.Started;
        if (trackInfo.getScriptPID() != -1L) {
            taskInfos.msg = String.valueOf(taskInfos.msg) + "With pid : " + trackInfo.getScriptPID();
        }
        if (trackInfo.getTaskName() != null) {
            entries.add(taskInfos);
        }
        List trackerInfoEntries = trackInfo.getTrackerInfoEntries();
        int i = 0;
        while (i < trackerInfoEntries.size()) {
            ITrackerInfo trackerInfo = (ITrackerInfo)trackerInfoEntries.get(i);
            if (trackerInfo instanceof TrackerInfoEntry) {
                if (((TrackerInfoEntry)trackerInfo).getEventtype() != Tracking.TrackEventType.Info) {
                    taskInfos = new RawTrackingLogEntry();
                    taskInfos.time = trackerInfo.getTime();
                    taskInfos.msg = trackerInfo.getLogMsg();
                    taskInfos.type = ((TrackerInfoEntry)trackerInfo).getEventtype();
                    taskInfos.entry = (TrackerInfoEntry)trackerInfo;
                    entries.add(taskInfos);
                }
            } else if (trackerInfo instanceof TrackInfo) {
                this.expandRaw(entries, (TrackInfo)trackerInfo);
            }
            ++i;
        }
        if (trackInfo.getExecStatus() == ExecStatus.Failed) {
            taskInfos = new RawTrackingLogEntry();
            taskInfos.time = trackInfo.getTime();
            taskInfos.msg = trackInfo.getTaskName() + " has failed.";
            taskInfos.msg = trackInfo.getEndLogMsg();
            taskInfos.type = Tracking.TrackEventType.Failed;
            entries.add(taskInfos);
        }
        if (trackInfo.getExecStatus() == ExecStatus.Finished) {
            taskInfos = new RawTrackingLogEntry();
            taskInfos.time = trackInfo.getTime();
            taskInfos.msg = trackInfo.getTaskName() + " has Finished.";
            taskInfos.msg = trackInfo.getEndLogMsg();
            taskInfos.type = Tracking.TrackEventType.Ended;
            entries.add(taskInfos);
        }
        if (trackInfo.getExecStatus() == ExecStatus.Warning) {
            taskInfos = new RawTrackingLogEntry();
            taskInfos.time = trackInfo.getTime();
            taskInfos.msg = trackInfo.getTaskName() + " has Finished With Warning.";
            taskInfos.msg = trackInfo.getEndLogMsg();
            taskInfos.type = Tracking.TrackEventType.Ended;
            entries.add(taskInfos);
        }
    }

    private void createTaskTable(Composite taskTableComosite) {
        taskTableComosite.setLayout((Layout)new FillLayout());
        this.taskTableViewer = new TableViewer(taskTableComosite, 68352);
        Table table = this.taskTableViewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setToolTipText("List of tasks/files running by the Job");
        TableViewerColumn tableViewerColumn = new TableViewerColumn(this.taskTableViewer, 0);
        TableColumn tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Start Time");
        tblclmn.setWidth(150);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tblclmn.setToolTipText("Execution Start time on the server");
        tableViewerColumn = new TableViewerColumn(this.taskTableViewer, 0);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("File(s)");
        tblclmn.setWidth(200);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tblclmn.setToolTipText("File(s) being processed by the current Job.");
        this.tblclmnTasksOrFiles = tblclmn;
        tableViewerColumn = new TableViewerColumn(this.taskTableViewer, 8);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Finish Time");
        tblclmn.setWidth(100);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tblclmn.setToolTipText("Execution Finish time on the server.");
        tableViewerColumn = new TableViewerColumn(this.taskTableViewer, 8);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Status");
        tblclmn.setWidth(100);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        tblclmn.setToolTipText("Execution Status for the file(s) after finishing.");
        tableViewerColumn = new TableViewerColumn(this.taskTableViewer, 0);
        tblclmn = tableViewerColumn.getColumn();
        tblclmn.setText("Info");
        tblclmn.setWidth(150);
        tblclmn.setResizable(true);
        tblclmn.setMoveable(false);
        tblclmn.setAlignment(0x1000000);
        this.taskTableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                TrackingComposite.this.tblclmnTasksOrFiles.setText("File(s)");
                TrackingComposite.this.tblclmnTasksOrFiles.setToolTipText("File(s) being processed by the current Job.");
                TrackInfo trackInfo = (TrackInfo)inputElement;
                List entries = trackInfo.getUITaskTrackInfos();
                if (entries.size() > 0 && ((UITaskTrackInfo)entries.get((int)0)).mainTask) {
                    TrackingComposite.this.tblclmnTasksOrFiles.setText("Task");
                    TrackingComposite.this.tblclmnTasksOrFiles.setToolTipText("Task being processed.");
                }
                Object[] allList = entries.toArray(new UITaskTrackInfo[entries.size()]);
                return allList;
            }
        });
        this.taskTableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                UITaskTrackInfo entry = (UITaskTrackInfo)element;
                switch (columnIndex) {
                    case 0: {
                        return entry.startTime;
                    }
                    case 1: {
                        return entry.files;
                    }
                    case 2: {
                        return entry.finishTime;
                    }
                    case 3: {
                        return entry.status;
                    }
                    case 4: {
                        return entry.info;
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                UITaskTrackInfo entry = (UITaskTrackInfo)element;
                if (columnIndex == 3) {
                    if (entry.status.equals("Finished")) {
                        return SharedImages.ACCEPT;
                    }
                    if (entry.status.equals("Failed")) {
                        return SharedImages.CANCEL;
                    }
                }
                return null;
            }
        });
        this.taskTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                UITaskTrackInfo entry = (UITaskTrackInfo)selection.getFirstElement();
                if (TrackingComposite.this.tmpClearSelection) {
                    TrackingComposite.this.consoleLog.updateSelected(entry);
                }
            }
        });
        this.taskTableViewer.getTable().addListener(3, event -> {
            TableItem item = table.getItem(new Point(event.x, event.y));
            if (item == null) {
                table.deselectAll();
                this.consoleLog.updateSelected(null);
            }
        });
    }

    protected void checkSubclass() {
    }

    public void setEntry(IWorkflowManager workflowManager, SubmissionHistoryEntry entry) {
        boolean clearSelection = entry != this.curEntry;
        this.adjustView(entry);
        this.consoleLog.setCurrentEntry(entry);
        if (this.curEntry == entry) {
            if (entry.getTaskType() == SubmissionHistoryEntry.TaskType.Pipeline) {
                this.preWorkflowVis.setTrackInfo(entry);
                if (this.preSelectedJob != null) {
                    TrackInfo info = (TrackInfo)this.curEntry.getTrackInfo().getSubInfoByTaskName(this.preSelectedJob.getJobID());
                    this.consoleLog.updateLogText(info);
                    this.updateTrackText(info, clearSelection);
                } else {
                    this.updateTrackText(this.curEntry.getTrackInfo(), clearSelection);
                    if (clearSelection) {
                        this.consoleLog.updateLogText(this.curEntry.getTrackInfo());
                    } else {
                        this.consoleLog.updateLogText();
                    }
                }
            } else {
                if (clearSelection) {
                    this.consoleLog.updateLogText(entry.getTrackInfo());
                } else {
                    this.consoleLog.updateLogText();
                }
                this.updateTrackText(entry.getTrackInfo(), clearSelection);
            }
        } else {
            this.curEntry = entry;
            if (entry.getTaskType() == SubmissionHistoryEntry.TaskType.Pipeline) {
                Workflow selectedPipeline = workflowManager.getWorkflowCatalog().getExpPipelineByID(entry.getTaskTemplateId());
                this.preWorkflowVis.setWorkflow(selectedPipeline, true);
                this.preWorkflowVis.setTrackInfo(entry);
                this.consoleLog.updateLogText(entry.getTrackInfo());
                this.setupTrackText(entry.getTrackInfo());
                this.preSelectedJob = null;
            } else {
                this.consoleLog.updateLogText(entry.getTrackInfo());
                this.setupTrackText(entry.getTrackInfo());
            }
        }
    }

    private void setupTrackText(TrackInfo trackInfo) {
        this.rawTrackViewer.setInput((Object)trackInfo);
        this.taskTableViewer.setInput((Object)trackInfo);
    }

    private void updateTrackText(TrackInfo info, boolean clearSelection) {
        int[] selectedIndeces = this.taskTableViewer.getTable().getSelectionIndices();
        this.tmpClearSelection = clearSelection;
        this.rawTrackViewer.setInput((Object)info);
        this.taskTableViewer.setInput((Object)info);
        this.tmpClearSelection = true;
        if (!clearSelection && selectedIndeces != null) {
            this.taskTableViewer.getTable().setSelection(selectedIndeces);
        }
    }

    private void updateTrackText(TrackInfo info) {
        this.updateTrackText(info, true);
    }

    private void adjustView(SubmissionHistoryEntry entry) {
        if (this.curEntry == null || this.curEntry.getTaskType() != entry.getTaskType()) {
            if (entry.getTaskType() == SubmissionHistoryEntry.TaskType.Job) {
                if (this.upperFrom.getWeights().length == 2) {
                    this.upperFromW = this.upperFrom.getWeights();
                }
                if (this.jobHolder != null) {
                    this.jobHolder.dispose();
                    this.jobHolder = null;
                    if (this.preWorkflowVis != null) {
                        this.preWorkflowVis.dispose();
                    }
                    this.preWorkflowVis = null;
                    this.preSelectedJob = null;
                    this.upperFrom.setWeights(new int[]{1});
                }
            } else if (this.jobHolder == null) {
                this.jobHolder = new Group((Composite)this.upperFrom, 0);
                this.jobHolder.moveAbove((Control)this.tabelCompsite);
                this.jobHolder.setLayout((Layout)new FillLayout(256));
                this.jobHolder.setText("Pipeline");
                IWorkflowManager manager = (IWorkflowManager)WorkflowUI.getEclipseContext().get(IWorkflowManager.class);
                this.preWorkflowVis = new WorkflowVis((Composite)this.jobHolder, 0, manager);
                this.preWorkflowVis.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        System.out.println(TrackingComposite.this.preWorkflowVis.getSelectedWorkflowJob());
                        WorkflowJob job = TrackingComposite.this.preWorkflowVis.getSelectedWorkflowJob();
                        SubmissionHistoryEntry visCurEnrtry = TrackingComposite.this.preWorkflowVis.getTrackEntry();
                        if (job == null) {
                            TrackInfo info = visCurEnrtry.getTrackInfo();
                            TrackingComposite.this.consoleLog.setCurrentEntry(visCurEnrtry);
                            TrackingComposite.this.consoleLog.updateLogText(info);
                            TrackingComposite.this.updateTrackText(info);
                            TrackingComposite.this.preSelectedJob = null;
                        } else if (TrackingComposite.this.preSelectedJob == null || !job.getJobID().equals(TrackingComposite.this.preSelectedJob.getJobID())) {
                            TrackInfo info = (TrackInfo)visCurEnrtry.getTrackInfo().getSubInfoByTaskName(job.getJobID());
                            TrackingComposite.this.consoleLog.setCurrentEntry(visCurEnrtry);
                            if (info != null) {
                                TrackingComposite.this.consoleLog.updateLogText(info);
                                TrackingComposite.this.setupTrackText(info);
                                TrackingComposite.this.preSelectedJob = job;
                            }
                        } else {
                            TrackInfo info = (TrackInfo)visCurEnrtry.getTrackInfo().getSubInfoByTaskName(job.getJobID());
                            TrackingComposite.this.consoleLog.setCurrentEntry(visCurEnrtry);
                            TrackingComposite.this.consoleLog.updateLogText(info);
                            TrackingComposite.this.updateTrackText(info);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                this.upperFrom.setWeights(this.upperFromW);
            }
        }
    }

    public void clearTracker() {
        this.consoleLog.updateLogText(null);
        this.rawTrackViewer.setInput(null);
        this.taskTableViewer.setInput(null);
        this.curEntry = null;
        this.consoleLog.setCurrentEntry(this.curEntry);
        if (this.jobHolder != null) {
            this.upperFromW = this.upperFrom.getWeights();
            this.jobHolder.dispose();
            this.jobHolder = null;
            this.preWorkflowVis.dispose();
            this.preWorkflowVis = null;
            this.preSelectedJob = null;
            this.upperFrom.setWeights(new int[]{1});
        }
    }
}

