package com.biotechvana.netools.ui.editors.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

import com.biotechvana.netools.INetworkView;
import com.biotechvana.netools.ISelectionEvent;
import com.biotechvana.netools.ISelectionListener;
import com.biotechvana.netools.ISelectionManager;
import com.biotechvana.netools.models.INode;
import com.biotechvana.netools.models.Node;
import com.biotechvana.netools.ui.editors.INetworkEditor;
import com.biotechvana.netools.ui.editors.INodeEditor;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;

public class NodeEditor implements INodeEditor {

    private INetworkEditor networkEditor;

    private DataBindingContext bindingContext;
    private WritableValue<Node> selectedNode;
    private Text idText;
    private Spinner borderWidthSpinner;
    private Spinner borderWidthSelectedSpinner;
    private Text opacityText;
    private Text groupText;
    private Text hiddenText;
    private Text labelText;
    private Text labelHighlightBoldText;
    private Spinner levelSpinner;
    private Text massText;
    //private Text shapeText;
    private Combo shapeCombo;
    private Text physicsText;
    private Spinner sizeSpinner;
    private Text titleText;
    private Text valueText;
    private Text xText;
    private Text yText;
    private Text colorText;
    private Text colorBorderText;
    private Text colorHighlightText;
    private Text colorHighlightBorderText;
    private Text colorHoverText;
    private Text colorHoverBorderText;
    
    Set<Node> selectedNodes = new HashSet<>();
    
    
    ISelectionManager selectionManager;
     
    INetworkView networkViewer;
    
    ISelectionListener currentSelectionListener;
    
    @Inject  
	public void setSelectionManager(@Optional ISelectionManager selectionManager) {
    	
    	if (this.selectionManager != null && currentSelectionListener != null) {
    		this.selectionManager.removeSelectionListener(currentSelectionListener);
    	}
    	
    	if (selectionManager == null) {
    		this.selectionManager = null;
    		return;
    	}
    	
    	
		this.selectionManager = selectionManager;
		if (currentSelectionListener == null) {
			currentSelectionListener = new ISelectionListener() {

				

				@Override
				public void nodesSelectionChanged(ISelectionEvent event) {
					// TODO Auto-generated method stub
					// handle selection change event here
					System.out.println("Node Selection Changed");
					System.out.println(event);
					selectedNodes = event.getSelectedNodes();
					
					if (selectedNodes.size() == 1) {
						setNode((INode) selectedNodes.toArray()[0]);
					} else {
						resetParameters();
					}					
				}

				@Override
				public void edgesSelectionChanged(ISelectionEvent event) {
					// TODO Auto-generated method stub
					
				}
			};
		}
		
		this.selectionManager.addSelectionListener(currentSelectionListener);
	}
    
    @Inject
	public void setNetworkViewer(@Optional INetworkView networkViewer) {
		this.networkViewer = networkViewer;
	}
    
    
    @PostConstruct
    public void initEditor(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.bindingContext = new DataBindingContext();
        this.selectedNode = new WritableValue<>(null, Node.class);

        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);

        Composite editorComposite = toolkit.createComposite(scrolledComposite);
        editorComposite.setLayout(new GridLayout(1, false));
        editorComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
        ((GridLayout) editorComposite.getLayout()).marginWidth = 10;
        ((GridLayout) editorComposite.getLayout()).marginHeight = 10;

        // GENERAL SECTION
        /*Section generalSection = toolkit.createSection(editorComposite, Section.TITLE_BAR | Section.TWISTIE | Section.EXPANDED);
        generalSection.setText("General");
        generalSection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
        Composite generalComposite = toolkit.createComposite(generalSection);
        generalComposite.setLayout(new GridLayout(2, false));
        generalSection.setClient(generalComposite);

        // ID
        toolkit.createLabel(generalComposite, "ID:");
        idText = toolkit.createText(generalComposite, "", SWT.BORDER);
        idText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        // Label
        toolkit.createLabel(generalComposite, "Label:");
        labelText = toolkit.createText(generalComposite, "", SWT.BORDER);
        labelText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        // Group
        toolkit.createLabel(generalComposite, "Group:");
        groupText = toolkit.createText(generalComposite, "", SWT.BORDER);
        groupText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));*/

        // APPEARANCE SECTION
        Section appearanceSection = toolkit.createSection(editorComposite, Section.TITLE_BAR | Section.TWISTIE | Section.EXPANDED);
        appearanceSection.setText("Customize Appearance");
        appearanceSection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
        Composite appearanceComposite = toolkit.createComposite(appearanceSection);
        appearanceComposite.setLayout(new GridLayout(3, false)); // Adjusted to 3 columns for color buttons
        appearanceSection.setClient(appearanceComposite);

        // Border Width
        toolkit.createLabel(appearanceComposite, "Border Width:");
        borderWidthSpinner = new Spinner(appearanceComposite, SWT.BORDER);
        borderWidthSpinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        toolkit.adapt(borderWidthSpinner);
        borderWidthSpinner.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                int newValue = borderWidthSpinner.getSelection();
                networkViewer.changeNodeBorderWidth(selectedNodes, newValue);
            }
        });

        // Border Width Selected
        toolkit.createLabel(appearanceComposite, "Border Width Selected:");
        borderWidthSelectedSpinner = new Spinner(appearanceComposite, SWT.BORDER);
        borderWidthSelectedSpinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false,2, 1));
        toolkit.adapt(borderWidthSelectedSpinner);
        borderWidthSelectedSpinner.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                int newValue = borderWidthSelectedSpinner.getSelection();
                networkViewer.changeNodeBorderWidthSelected(selectedNodes, newValue);
            }
        });

        // Opacity
        toolkit.createLabel(appearanceComposite, "Opacity:");
        opacityText = toolkit.createText(appearanceComposite, "", SWT.BORDER);
        opacityText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
        opacityText.addKeyListener(new KeyAdapter() {
            @Override
            public void keyPressed(KeyEvent e) {
                if (e.keyCode == SWT.CR || e.keyCode == SWT.KEYPAD_CR) {
                    String textValue = opacityText.getText(); 
                    try {
                        float newValue = Float.parseFloat(textValue);
                        networkViewer.changeNodeOpacity(selectedNodes, newValue);
                    } catch (NumberFormatException ex) {
                        System.out.println("Invalid opacity value: " + textValue);
                    }
                }
            }
        });

        // Color
        toolkit.createLabel(appearanceComposite, "Color:");
        colorText = toolkit.createText(appearanceComposite, "", SWT.BORDER);
        colorText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        Button colorButton = toolkit.createButton(appearanceComposite, "Choose...", SWT.PUSH);
        colorButton.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ColorDialog colorDialog = new ColorDialog(parent.getShell());
                RGB rgb = colorDialog.open();
                //String colorHex = null;
                if (rgb != null) {
                    String colorHex = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
                    //colorText.setText(colorHex);
                    //Color backgroundColor = new Color(parent.getDisplay(), rgb);
                    //colorText.setBackground(backgroundColor);           
                    updateColorInput(colorText, rgb);
                    
                    // CHANGE ASSOCIATED COLOR ATTRIBUTES
                    RGB darker = deriveColor(rgb, 0.75);
                    RGB lighter = deriveColor(rgb, 1.25);
                    updateColorInput(colorBorderText, darker);
                    updateColorInput(colorHighlightText, lighter);
                    updateColorInput(colorHighlightBorderText, darker);
                    updateColorInput(colorHoverText, lighter);
                    updateColorInput(colorHoverBorderText, darker);
                    
                    networkViewer.changeNodeColor(selectedNodes, colorHex);
                }
               
            }
        });

        // Color Border
        toolkit.createLabel(appearanceComposite, "Color Border:");
        colorBorderText = toolkit.createText(appearanceComposite, "", SWT.BORDER);
        colorBorderText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        Button colorBorderButton = toolkit.createButton(appearanceComposite, "Choose...", SWT.PUSH);
        colorBorderButton.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ColorDialog colorDialog = new ColorDialog(parent.getShell());
                RGB rgb = colorDialog.open();
                //String colorHex = null;
                if (rgb != null) {
                    String colorHex = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
                    //colorBorderText.setText(colorHex);
                    //Color backgroundColor = new Color(parent.getDisplay(), rgb);
                    //colorBorderText.setBackground(backgroundColor);
                    updateColorInput(colorBorderText, rgb);
                    networkViewer.changeNodeColorBorder(selectedNodes, colorHex);
                }
            }
        });

        // Color Highlight
        toolkit.createLabel(appearanceComposite, "Color Highlight:");
        colorHighlightText = toolkit.createText(appearanceComposite, "", SWT.BORDER);
        colorHighlightText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        Button colorHighlightButton = toolkit.createButton(appearanceComposite, "Choose...", SWT.PUSH);
        colorHighlightButton.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ColorDialog colorDialog = new ColorDialog(parent.getShell());
                RGB rgb = colorDialog.open();
                //String colorHex = null;
                if (rgb != null) {
                    String colorHex = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
                    //colorHighlightText.setText(colorHex);
                    //Color backgroundColor = new Color(parent.getDisplay(), rgb);
                    //colorHighlightText.setBackground(backgroundColor);
                    updateColorInput(colorHighlightText, rgb);
                    networkViewer.changeNodeColorHighlight(selectedNodes, colorHex);
                }
            }
        });

        // Color Highlight Border
        toolkit.createLabel(appearanceComposite, "Color Highlight Border:");
        colorHighlightBorderText = toolkit.createText(appearanceComposite, "", SWT.BORDER);
        colorHighlightBorderText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        Button colorHighlightBorderButton = toolkit.createButton(appearanceComposite, "Choose...", SWT.PUSH);
        colorHighlightBorderButton.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ColorDialog colorDialog = new ColorDialog(parent.getShell());
                RGB rgb = colorDialog.open();
                //String colorHex = null;
                if (rgb != null) {
                    String colorHex = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
                    //colorHighlightBorderText.setText(colorHex);
                    //Color backgroundColor = new Color(parent.getDisplay(), rgb);
                    //colorHighlightBorderText.setBackground(backgroundColor);
                    updateColorInput(colorHighlightBorderText, rgb);
                    networkViewer.changeNodeColorHighlightBorder(selectedNodes, colorHex);
                }
            }
        });

        // Color Hover
        toolkit.createLabel(appearanceComposite, "Color Hover:");
        colorHoverText = toolkit.createText(appearanceComposite, "", SWT.BORDER);
        colorHoverText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        Button colorHoverButton = toolkit.createButton(appearanceComposite, "Choose...", SWT.PUSH);
        colorHoverButton.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ColorDialog colorDialog = new ColorDialog(parent.getShell());
                RGB rgb = colorDialog.open();
                // String colorHex = null;
                if (rgb != null) {
                	String colorHex = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
                    //colorHoverText.setText(colorHex);
                    //Color backgroundColor = new Color(parent.getDisplay(), rgb);
                    //colorHoverText.setBackground(backgroundColor);
                	updateColorInput(colorHoverText,rgb);
                    networkViewer.changeNodeColorHover(selectedNodes, colorHex);
                }
                
            }
        });

        // Color Hover Border
        toolkit.createLabel(appearanceComposite, "Color Hover Border:");
        colorHoverBorderText = toolkit.createText(appearanceComposite, "", SWT.BORDER);
        colorHoverBorderText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        Button colorHoverBorderButton = toolkit.createButton(appearanceComposite, "Choose...", SWT.PUSH);
        colorHoverBorderButton.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                ColorDialog colorDialog = new ColorDialog(parent.getShell());
                RGB rgb = colorDialog.open();
                //String colorHex = null;
                if (rgb != null) {
                    String colorHex = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
                    //colorHoverBorderText.setText(colorHex);
                    //Color backgroundColor = new Color(parent.getDisplay(), rgb);
                    //colorHoverBorderText.setBackground(backgroundColor);
                    updateColorInput(colorHoverBorderText, rgb);
                    networkViewer.changeNodeColorHoverBorder(selectedNodes, colorHex);
                }
            }
        });
        
        // Shape
        toolkit.createLabel(appearanceComposite, "Shape:");
        shapeCombo = new Combo(appearanceComposite, SWT.DROP_DOWN | SWT.READ_ONLY);
        shapeCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        String[] shapes = { "ellipse", "circle", "box", "diamond", "star", "triangle", "square" }; 
        shapeCombo.setItems(shapes);

        shapeCombo.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                String selectedShape = shapeCombo.getText();
                networkViewer.changeNodeShape(selectedNodes, selectedShape);
            }
        });

        
        // Size
        toolkit.createLabel(appearanceComposite, " ");
        toolkit.createLabel(appearanceComposite, "Size:");
        sizeSpinner = new Spinner(appearanceComposite, SWT.BORDER);
        sizeSpinner.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
        toolkit.adapt(sizeSpinner);
        sizeSpinner.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                int newValue = sizeSpinner.getSelection();
                networkViewer.changeNodeSize(selectedNodes, newValue);
            }
        });

        // POSITION SECTION
        /*Section positionSection = toolkit.createSection(editorComposite, Section.TITLE_BAR | Section.TWISTIE | Section.EXPANDED);
        positionSection.setText("Position");
        positionSection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
        Composite positionComposite = toolkit.createComposite(positionSection);
        positionComposite.setLayout(new GridLayout(2, false));
        positionSection.setClient(positionComposite);

        // X
        toolkit.createLabel(positionComposite, "X:");
        xText = toolkit.createText(positionComposite, "", SWT.BORDER);
        xText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        // Y
        toolkit.createLabel(positionComposite, "Y:");
        yText = toolkit.createText(positionComposite, "", SWT.BORDER);
        yText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));*/

        // PHYSICS SECTION
        /*Section physicsSection = toolkit.createSection(editorComposite, Section.TITLE_BAR | Section.TWISTIE | Section.EXPANDED);
        physicsSection.setText("Physics");
        physicsSection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
        Composite physicsComposite = toolkit.createComposite(physicsSection);
        physicsComposite.setLayout(new GridLayout(2, false));
        physicsSection.setClient(physicsComposite);

        // Mass
        toolkit.createLabel(physicsComposite, "Mass:");
        massText = toolkit.createText(physicsComposite, "", SWT.BORDER);
        massText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        // Physics
        toolkit.createLabel(physicsComposite, "Physics:");
        physicsText = toolkit.createText(physicsComposite, "", SWT.BORDER);
        physicsText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        // Title
        toolkit.createLabel(physicsComposite, "Title:");
        titleText = toolkit.createText(physicsComposite, "", SWT.BORDER);
        titleText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

        // Value
        toolkit.createLabel(physicsComposite, "Value:");
        valueText = toolkit.createText(physicsComposite, "", SWT.BORDER);
        valueText.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));*/

        scrolledComposite.setContent(editorComposite);
        scrolledComposite.setMinSize(editorComposite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
    }
    
    private void updateColorInput( Text colorInput, RGB rgb) {
        if (rgb != null) {
        	String colorHex = String.format("#%02x%02x%02x", rgb.red, rgb.green, rgb.blue);
        	colorInput.setText(colorHex);
            Color backgroundColor = new Color(colorInput.getDisplay(), rgb);
            colorInput.setBackground(backgroundColor);
            return;
        /*} else {
        	// if null reset or clear
            colorInput.setBackground(null);
            colorInput.setText(null);*/
        }
    }
    
    private void updateColorInput( Text colorInput, String colorHex) {
        if (colorHex != "") {
        	colorInput.setText(colorHex);
        	if (colorHex.startsWith("#")) colorHex = colorHex.substring(1);
        	int r = Integer.valueOf(colorHex.substring(0, 2), 16);
        	int g = Integer.valueOf(colorHex.substring(2, 4), 16);
        	int b = Integer.valueOf(colorHex.substring(4, 6), 16);
            RGB rgb = new RGB(r, g, b); // convert colorHex to RGB
            Color backgroundColor = new Color(colorInput.getDisplay(),rgb);
            colorInput.setBackground(backgroundColor);
            return;
        } else {
        	// if null reset or clear
            colorInput.setBackground(null);
            colorInput.setText("");
        }
    }
    
    private RGB deriveColor(RGB color, double factor) {
    	int r = Math.max(0, Math.min(255, (int)Math.round(color.red   * factor)));
	    int g = Math.max(0, Math.min(255, (int)Math.round(color.green * factor)));
	    int b = Math.max(0, Math.min(255, (int)Math.round(color.blue  * factor)));
	    return new RGB(r, g, b);
    }
    
    public void setNode(INode node) {
        //idText.setText(node.getId());
        borderWidthSpinner.setSelection(node.getBorderWidth());
        borderWidthSelectedSpinner.setSelection(node.getBorderWidthSelected());
        opacityText.setText(String.valueOf(node.getOpacity()));
        //groupText.setText(node.getGroup());
        //hiddenText.setText(String.valueOf(node.isHidden()));
        //labelText.setText(node.getLabel());
       // labelHighlightBoldText.setText(String.valueOf(node.isLabelHighlightBold()));
        //levelSpinner.setSelection(node.getLevel());
        //massText.setText(String.valueOf(node.getMass()));
        //shapeText.setText(node.getShape());
        shapeCombo.setText(node.getShape());
        //physicsText.setText(String.valueOf(node.isPhysics()));
        sizeSpinner.setSelection(node.getSize());
        //titleText.setText(node.getTitle());
        //valueText.setText(String.valueOf(node.getValue()));
        //xText.setText(String.valueOf(node.getX()));
        //yText.setText(String.valueOf(node.getY()));
        
        updateColorInput(colorText, node.getGroup() != null ? networkViewer.getVisNodeColor(node) : node.getColor());
        //colorText.setText(node.getColor());
        updateColorInput(colorBorderText, node.getGroup() != null ? networkViewer.getVisNodeColorBorder(node) : node.getColorBorder());
        //colorBorderText.setText(node.getColorBorder());
        updateColorInput(colorHighlightText, node.getGroup() != null ? networkViewer.getVisNodeColorHighlight(node) : node.getColorHighlight());
        //colorHighlightText.setText(node.getColorHighlight());
        updateColorInput(colorHighlightBorderText, node.getGroup() != null ? networkViewer.getVisNodeColorHighlightBorder(node) : node.getColorHighlightBorder());
        //colorHighlightBorderText.setText(node.getColorHighlightBorder());
        updateColorInput(colorHoverText, node.getGroup() != null ? networkViewer.getVisNodeColorHover(node) : node.getColorHover());
        //colorHoverText.setText(node.getColorHover());
        updateColorInput(colorHoverBorderText, node.getGroup() != null ? networkViewer.getVisNodeColorHoverBorder(node) : node.getColorHoverBorder());
        //colorHoverBorderText.setText(node.getColorHoverBorder());
    }
    
    public void resetParameters() {
    	borderWidthSpinner.setSelection(0);
        borderWidthSelectedSpinner.setSelection(0);
        opacityText.setText(String.valueOf(""));
        //shapeText.setText("");
        shapeCombo.select(0);
        sizeSpinner.setSelection(0);
        updateColorInput(colorText, "");
        updateColorInput(colorBorderText, "");
        updateColorInput(colorHighlightText, "");
        updateColorInput(colorHighlightBorderText, "");
        updateColorInput(colorHoverText, "");
        updateColorInput(colorHoverBorderText, "");      
    }

    public void updateNode(INode node) {
        node.setId(idText.getText());
        node.setBorderWidth(borderWidthSpinner.getSelection());
        node.setBorderWidthSelected(borderWidthSelectedSpinner.getSelection());
        node.setOpacity(Double.parseDouble(opacityText.getText()));
        node.setGroup(groupText.getText());
        node.setHidden(Boolean.parseBoolean(hiddenText.getText()));
        node.setLabel(labelText.getText());
        node.setLabelHighlightBold(Boolean.parseBoolean(labelHighlightBoldText.getText()));
        node.setLevel(levelSpinner.getSelection());
        node.setMass(Double.parseDouble(massText.getText()));
        //node.setShape(shapeText.getText());
        node.setShape(shapeCombo.getText());
        node.setPhysics(Boolean.parseBoolean(physicsText.getText()));
        node.setSize(sizeSpinner.getSelection());
        node.setTitle(titleText.getText());
        node.setValue(Double.parseDouble(valueText.getText()));
        node.setX(Double.parseDouble(xText.getText()));
        node.setY(Double.parseDouble(yText.getText()));
        node.setColor(colorText.getText());
        node.setColorBorder(colorBorderText.getText());
        node.setColorHighlight(colorHighlightText.getText());     
        node.setColorHighlightBorder(colorHighlightBorderText.getText());
        node.setColorHover(colorHoverText.getText());
        node.setColorHoverBorder(colorHoverBorderText.getText());
    }
}
