package com.biotechvana.netools.ui.editors.internal;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

import com.biotechvana.netools.INetworkView;
import com.biotechvana.netools.models.Edge;
import com.biotechvana.netools.ui.editors.ILayoutEditor;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;


public class LayoutEditor implements ILayoutEditor {
	
	private DataBindingContext bindingContext;
	
	private Combo typeCombo;
	private Combo directionCombo;
	private Combo solverCombo;
	
	private boolean isPhysicsEnabled;
	private String selectedSolver;
	
	 INetworkView networkViewer;

	 @Inject
		public void setNetworkViewer(@Optional INetworkView networkViewer) {
			this.networkViewer = networkViewer;
		}
	    
	    
	    @PostConstruct
	    public void initEditor(Composite parent) {
	        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
	        this.bindingContext = new DataBindingContext();

	        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, SWT.H_SCROLL | SWT.V_SCROLL);
	        scrolledComposite.setExpandHorizontal(true);
	        scrolledComposite.setExpandVertical(true);

	        Composite editorComposite = toolkit.createComposite(scrolledComposite);
	        editorComposite.setLayout(new GridLayout(1, false));
	        editorComposite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
	        ((GridLayout) editorComposite.getLayout()).marginWidth = 10;
	        ((GridLayout) editorComposite.getLayout()).marginHeight = 10;
	        
	        
	        // EDGES SECTION
	        Section layoutEdgesSection = toolkit.createSection(editorComposite, Section.TITLE_BAR | Section.TWISTIE | Section.EXPANDED);
	        layoutEdgesSection.setText("Edges");
	        layoutEdgesSection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
	        Composite layoutEdgesComposite = toolkit.createComposite(layoutEdgesSection);
	        layoutEdgesComposite.setLayout(new GridLayout(3, false));
	        layoutEdgesSection.setClient(layoutEdgesComposite);
	        
	        // Smooth
	        toolkit.createLabel(layoutEdgesComposite, "smooth:");
	        Button smoothnessButton = toolkit.createButton(layoutEdgesComposite, null, SWT.CHECK);
	        smoothnessButton.addSelectionListener(new SelectionAdapter() {
	        	@Override
	        	public void widgetSelected(SelectionEvent e) {
	        		boolean isSelected = smoothnessButton.getSelection();
	        		networkViewer.enableSmoothness(isSelected);
	        	}
	        });
	        
	        // Type
	        toolkit.createLabel(layoutEdgesComposite, " ");
	        toolkit.createLabel(layoutEdgesComposite, "type:");
	        typeCombo = new Combo(layoutEdgesComposite, SWT.DROP_DOWN | SWT.READ_ONLY);
	        typeCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

	        String[] types = { "dynamic", "continuous", "discrete", "diagonalCross", "straightCross", "horizontal", "vertical", "curvedCW", "curvedCCW", "cubicBezier" }; 
	        typeCombo.setItems(types);
	        typeCombo.select(0);
	        
	        typeCombo.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                String selectedType = typeCombo.getText();
	                networkViewer.changeSmoothnessType(selectedType);
	            }
	        });
	        
	        // Force Direction
	        toolkit.createLabel(layoutEdgesComposite, " ");
	        toolkit.createLabel(layoutEdgesComposite, "forceDirection:");
	        directionCombo = new Combo(layoutEdgesComposite, SWT.DROP_DOWN | SWT.READ_ONLY);
	        directionCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

	        String[] fdirections = { "horizontal", "vertical", "none" }; 
	        directionCombo.setItems(fdirections);
	        directionCombo.select(2);
	        
	        directionCombo.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                String selectedDirection = directionCombo.getText();
	                networkViewer.changeSmoothnessForceDirection(selectedDirection);
	            }
	        });
	        
	        // Roundness
	        toolkit.createLabel(layoutEdgesComposite, " ");
	        toolkit.createLabel(layoutEdgesComposite, "roundness:");
	        Scale roundnessScaleBH = new Scale(layoutEdgesComposite, SWT.HORIZONTAL);
	        roundnessScaleBH.setMaximum(0);
	        roundnessScaleBH.setMinimum(100);
	        roundnessScaleBH.setSelection(50);
	        roundnessScaleBH.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label roundnessValueLabel = toolkit.createLabel(layoutEdgesComposite, "0.50");
	        roundnessValueLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        roundnessScaleBH.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                float value = roundnessScaleBH.getSelection() / 100.0f; // Convert to float (0.0 - 1.0)
	                roundnessValueLabel.setText(String.format("%.2f", value)); // Show 2 decimals
	                layoutEdgesComposite.layout(); // Update UI
	                networkViewer.changeSmoothnessRoundness(value);
	            }
	        });
	        

	        // PHYSICS SECTION
	        Section layoutPhysicsSection = toolkit.createSection(editorComposite, Section.TITLE_BAR | Section.TWISTIE | Section.EXPANDED);
	        layoutPhysicsSection.setText("Physics");
	        layoutPhysicsSection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
	        Composite layoutPhysicsComposite = toolkit.createComposite(layoutPhysicsSection);
	        layoutPhysicsComposite.setLayout(new GridLayout(1, false)); 
	        layoutPhysicsSection.setClient(layoutPhysicsComposite);
	        
	        // BarnesHut
	        Section barnesHutSubsection = toolkit.createSection(layoutPhysicsComposite, Section.TITLE_BAR | Section.TWISTIE | Section.EXPANDED);
	        barnesHutSubsection.setText("barnesHut");
	        barnesHutSubsection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
	        
	        Composite barnesHutComposite = toolkit.createComposite(barnesHutSubsection);
	        barnesHutComposite.setLayout(new GridLayout(3, false)); 
	        barnesHutSubsection.setClient(barnesHutComposite);
	        
	        // ForceAtlas2Based
	        Section forceAtlas2BasedSubsection = toolkit.createSection(layoutPhysicsComposite, Section.TITLE_BAR | Section.TWISTIE | Section.EXPANDED);
	        forceAtlas2BasedSubsection.setText("forceAtlas2Based");
	        forceAtlas2BasedSubsection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));

	        Composite forceAtlas2BasedComposite = toolkit.createComposite(forceAtlas2BasedSubsection);
	        forceAtlas2BasedComposite.setLayout(new GridLayout(3, false)); 
	        forceAtlas2BasedSubsection.setClient(forceAtlas2BasedComposite);
	        
	        // Repulsion
	        Section repulsionSubsection = toolkit.createSection(layoutPhysicsComposite, Section.TITLE_BAR | Section.TWISTIE | Section.EXPANDED);
	        repulsionSubsection.setText("repulsion");
	        repulsionSubsection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));

	        Composite repulsionComposite = toolkit.createComposite(repulsionSubsection);
	        repulsionComposite.setLayout(new GridLayout(3, false)); 
	        repulsionSubsection.setClient(repulsionComposite);
	        
	        // Hierarchical repulsion
	        Section hierarchicalRepulsionSubsection = toolkit.createSection(layoutPhysicsComposite, Section.TITLE_BAR | Section.TWISTIE | Section.EXPANDED);
	        hierarchicalRepulsionSubsection.setText("hierarchicalRepulsion");
	        hierarchicalRepulsionSubsection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));

	        Composite hierarchicalRepulsionComposite = toolkit.createComposite(hierarchicalRepulsionSubsection);
	        hierarchicalRepulsionComposite.setLayout(new GridLayout(3, false)); 
	        hierarchicalRepulsionSubsection.setClient(hierarchicalRepulsionComposite);
	        
	        // Generic
	        Section genericSubsection = toolkit.createSection(layoutPhysicsComposite, Section.TITLE_BAR | Section.TWISTIE | Section.EXPANDED);
	        genericSubsection.setText("generic");
	        genericSubsection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
	        Composite genericComposite = toolkit.createComposite(genericSubsection);
	        genericComposite.setLayout(new GridLayout(3, false)); // Adjusted to 3 columns for color buttons
	        genericSubsection.setClient(genericComposite);
	        
	        // Wind
	        Section windSubsection = toolkit.createSection(layoutPhysicsComposite, Section.TITLE_BAR | Section.TWISTIE | Section.EXPANDED);
	        windSubsection.setText("wind");
	        windSubsection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
	        Composite windComposite = toolkit.createComposite(windSubsection);
	        windComposite.setLayout(new GridLayout(3, false)); // Adjusted to 3 columns for color buttons
	        windSubsection.setClient(windComposite);
	        
	        
	        // Physics
	        toolkit.createLabel(layoutPhysicsComposite, "enabled:");
	        Button physicsButton = toolkit.createButton(layoutPhysicsComposite, null, SWT.CHECK);
	        physicsButton.setSelection(true);
	        isPhysicsEnabled = physicsButton.getSelection();
	        physicsButton.addSelectionListener(new SelectionAdapter() {
	        	@Override
	        	public void widgetSelected(SelectionEvent e) {
	        		isPhysicsEnabled = physicsButton.getSelection();
	        		networkViewer.enablePhysics(isPhysicsEnabled);
	        		
	        		selectedSolver = solverCombo.getText();
	     	        
	     	        if (isPhysicsEnabled) {
	     	        	showSubsection(genericSubsection);
	     	        	showSubsection(windSubsection);
	     	        	if (selectedSolver.equals("barnesHut")) {
	     	        		showSubsection(barnesHutSubsection);
	     	        	} else if (selectedSolver.equals("forceAtlas2Based")) {
	     	        		showSubsection(forceAtlas2BasedSubsection);
	     	        	} else if (selectedSolver.equals("repulsion")) {
	     	        		showSubsection(repulsionSubsection);
	     	        	} else if (selectedSolver.equals("hierarchicalRepulsion")) {
	     	        		showSubsection(hierarchicalRepulsionSubsection);
	     	        	}	
	     	        } else {
	        			hideSubsection(barnesHutSubsection);
	        			hideSubsection(forceAtlas2BasedSubsection);
	        			hideSubsection(repulsionSubsection);
	        			hideSubsection(hierarchicalRepulsionSubsection);
	        			hideSubsection(genericSubsection);
	        			hideSubsection(windSubsection);
	        		}
	        	}
	        });
	        
	        
	     // BARNESHUT SUBSECTION
	        
	        float defaultThetaBH = 0.5f;
	        float minThetaBH = 0.1f;
	        float maxThetaBH = 1f;
	        int defaultGCBH = -2000;
	        int minGCBH = -30000;
	        int maxGCBH = 0;
	        float defaultCentralGravityBH = 0.3f;
	        float minCentralGravityBH = 0f;
	        float maxCentralGravityBH = 10f;
	        int defaultSpringLengthBH = 95;
	        int minSpringLengthBH = 0;
	        int maxSpringLengthBH = 500;
	        float defaultSpringConstantBH = 0.04f;
	        float minSpringConstantBH = 0f;
	        float maxSpringConstantBH = 1.2f;
	        float defaultDampingBH = 0.09f;
	        float minDampingBH = 0f;
	        float maxDampingBH = 1f;
	        float defaultAvoidOverlapBH = 0f;
	        float minAvoidOverlapBH = 0f;
	        float maxAvoidOverlapBH = 1f;
	        
	    
	        
	        // Theta
	        toolkit.createLabel(barnesHutComposite, "theta:");
	        Scale thetaScaleBH = new Scale(barnesHutComposite, SWT.HORIZONTAL);
	        thetaScaleBH.setMinimum((int) (minThetaBH*100));
	        thetaScaleBH.setMaximum((int) (maxThetaBH*100));
	        thetaScaleBH.setSelection((int) (defaultThetaBH*100));
	        thetaScaleBH.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label thetaValueLabelBH = toolkit.createLabel(barnesHutComposite, String.format("%.2f", defaultThetaBH));
	        thetaValueLabelBH.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        thetaScaleBH.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                float value = thetaScaleBH.getSelection() / 100.0f; // Convert to float (0.0 - 1.0)
	                thetaValueLabelBH.setText(String.format("%.2f", value)); // Show 2 decimals
	                barnesHutComposite.layout(); // Update UI
	                networkViewer.changeThetaBH(value);
	            }
	        });
	        
	        // Gravitational Constant
	        toolkit.createLabel(barnesHutComposite, "gravitationalConstant:");
	        Scale gravitationalConstantScaleBH = new Scale(barnesHutComposite, SWT.HORIZONTAL);
	        gravitationalConstantScaleBH.setMinimum(0);
	        gravitationalConstantScaleBH.setMaximum(maxGCBH - minGCBH);
	        gravitationalConstantScaleBH.setSelection(defaultGCBH - minGCBH);
	        gravitationalConstantScaleBH.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label gravitationalConstantValueLabelBH = toolkit.createLabel(barnesHutComposite, Integer.toString(defaultGCBH));
	        gravitationalConstantValueLabelBH.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        gravitationalConstantScaleBH.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	            	int internalValue = gravitationalConstantScaleBH.getSelection();
	            	int actualValue = minGCBH + internalValue;
	            	gravitationalConstantValueLabelBH.setText(Integer.toString(actualValue)); 
	            	barnesHutComposite.layout(); // Update UI
	                networkViewer.changeGravitationalConstantBH(actualValue);
	            }
	        });
	        
	        // Central Gravity
	        toolkit.createLabel(barnesHutComposite, "centralGravity:");
	        Scale centralGravityScaleBH = new Scale(barnesHutComposite, SWT.HORIZONTAL);
	        centralGravityScaleBH.setMinimum((int) (minCentralGravityBH*10));
	        centralGravityScaleBH.setMaximum((int) (maxCentralGravityBH*10));
	        centralGravityScaleBH.setSelection((int) (defaultCentralGravityBH*10));
	        centralGravityScaleBH.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label centralGravityValueLabelBH = toolkit.createLabel(barnesHutComposite, String.format("%.2f", defaultCentralGravityBH));
	        centralGravityValueLabelBH.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        centralGravityScaleBH.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                float value = centralGravityScaleBH.getSelection() / 10.0f;
	                centralGravityValueLabelBH.setText(String.format("%.2f", value));
	                barnesHutComposite.layout(); 
	                networkViewer.changeCentralGravityBH(value);
	            }
	        });
	        
	        // Spring Length
	        toolkit.createLabel(barnesHutComposite, "springLength:");
	        Scale springLengthScaleBH = new Scale(barnesHutComposite, SWT.HORIZONTAL);
	        springLengthScaleBH.setMinimum(minSpringLengthBH);
	        springLengthScaleBH.setMaximum(maxSpringLengthBH);
	        springLengthScaleBH.setSelection(defaultSpringLengthBH);
	        springLengthScaleBH.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label springLengthValueLabelBH = toolkit.createLabel(barnesHutComposite, Integer.toString(defaultSpringLengthBH));
	        springLengthValueLabelBH.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        springLengthScaleBH.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	            	int value = springLengthScaleBH.getSelection();
	            	springLengthValueLabelBH.setText(Integer.toString(value)); 
	            	barnesHutComposite.layout(); // Update UI
	                networkViewer.changeSpringLengthBH(value);
	            }
	        });
	        
	        // Spring Constant
	        toolkit.createLabel(barnesHutComposite, "springConstant:");
	        Scale springConstantScaleBH = new Scale(barnesHutComposite, SWT.HORIZONTAL);
	        springConstantScaleBH.setMinimum((int) (minSpringConstantBH*100));
	        springConstantScaleBH.setMaximum((int) (maxSpringConstantBH*100));
	        springConstantScaleBH.setSelection((int) (defaultSpringConstantBH*100));
	        springConstantScaleBH.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label springConstantValueLabelBH = toolkit.createLabel(barnesHutComposite, String.format("%.2f", defaultSpringConstantBH));
	        springConstantValueLabelBH.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        springConstantScaleBH.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	            	float value = springConstantScaleBH.getSelection() / 100.0f;
	            	springConstantValueLabelBH.setText(String.format("%.2f", value));
	            	barnesHutComposite.layout(); // Update UI
	                networkViewer.changeSpringConstantBH(value);
	            }
	        });
	        
	        // Damping
	        toolkit.createLabel(barnesHutComposite, "damping:");
	        Scale dampingScaleBH = new Scale(barnesHutComposite, SWT.HORIZONTAL);
	        dampingScaleBH.setMinimum((int) (minDampingBH*100));
	        dampingScaleBH.setMaximum((int) (maxDampingBH*100));
	        dampingScaleBH.setSelection((int)  (defaultDampingBH*100));
	        dampingScaleBH.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label dampingValueLabelBH = toolkit.createLabel(barnesHutComposite, String.format("%.2f", defaultDampingBH));
	        dampingValueLabelBH.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        dampingScaleBH.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	            	float value = dampingScaleBH.getSelection() / 100.0f;
	            	dampingValueLabelBH.setText(String.format("%.2f", value));
	            	barnesHutComposite.layout(); // Update UI
	                networkViewer.changeDampingBH(value);
	            }
	        });
	        
	        // Avoid Overlap
	        toolkit.createLabel(barnesHutComposite, "avoidOverlap:");
	        Scale avoidOverlapScaleBH = new Scale(barnesHutComposite, SWT.HORIZONTAL);
	        avoidOverlapScaleBH.setMinimum((int) minAvoidOverlapBH*100);
	        avoidOverlapScaleBH.setMaximum((int) maxAvoidOverlapBH*100);
	        avoidOverlapScaleBH.setSelection((int) defaultAvoidOverlapBH*100);
	        avoidOverlapScaleBH.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label avoidOverlapValueLabelBH = toolkit.createLabel(barnesHutComposite, String.format("%.2f", defaultAvoidOverlapBH));
	        avoidOverlapValueLabelBH.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        avoidOverlapScaleBH.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	            	float value = avoidOverlapScaleBH.getSelection() / 100.0f;
	            	avoidOverlapValueLabelBH.setText(String.format("%.2f", value));
	            	barnesHutComposite.layout(); // Update UI
	                networkViewer.changeAvoidOverlapBH(value);
	            }
	        });
	         
	        hideSubsection(barnesHutSubsection);
	        
	        
	       // FORCEATLAS2BASED SUBSECTION 
	        
	        float defaultThetaFA = 0.5f;
	        float minThetaFA = 0.1f;
	        float maxThetaFA = 1f;
	        int defaultGCFA = -50;
	        int minGCFA = -500;
	        int maxGCFA = 0;
	        float defaultCentralGravityFA = 0.01f;
	        float minCentralGravityFA = 0f;
	        float maxCentralGravityFA = 1f;
	        int defaultSpringLengthFA = 100;
	        int minSpringLengthFA = 0;
	        int maxSpringLengthFA = 500;
	        float defaultSpringConstantFA = 0.08f;
	        float minSpringConstantFA = 0f;
	        float maxSpringConstantFA = 1.2f;
	        float defaultDampingFA = 0.4f;
	        float minDampingFA = 0f;
	        float maxDampingFA = 1f;
	        float defaultAvoidOverlapFA = 0f;
	        float minAvoidOverlapFA = 0f;
	        float maxAvoidOverlapFA = 1f;

	       
	        
	        // Theta
	        toolkit.createLabel(forceAtlas2BasedComposite, "theta:");
	        Scale thetaScaleFA = new Scale(forceAtlas2BasedComposite, SWT.HORIZONTAL);
	        thetaScaleFA.setMinimum((int) (minThetaFA*100));
	        thetaScaleFA.setMaximum((int) (maxThetaFA*100));
	        thetaScaleFA.setSelection((int) (defaultThetaFA*100));
	        thetaScaleFA.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label thetaValueLabelFA = toolkit.createLabel(forceAtlas2BasedComposite, String.format("%.2f", defaultThetaFA));
	        thetaValueLabelFA.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

	        thetaScaleFA.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                float value = thetaScaleFA.getSelection() / 100.0f; // Convert to float (0.0 - 1.0)
	                thetaValueLabelFA.setText(String.format("%.2f", value)); // Show 2 decimals
	                forceAtlas2BasedComposite.layout(); // Update UI
	                networkViewer.changeThetaFA(value);
	            }
	        });

	        // Gravitational Constant
	        toolkit.createLabel(forceAtlas2BasedComposite, "gravitationalConstant:");
	        Scale gravitationalConstantScaleFA = new Scale(forceAtlas2BasedComposite, SWT.HORIZONTAL);
	        gravitationalConstantScaleFA.setMinimum(0);
	        gravitationalConstantScaleFA.setMaximum(maxGCFA - minGCFA);
	        gravitationalConstantScaleFA.setSelection(defaultGCFA - minGCFA);
	        gravitationalConstantScaleFA.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label gravitationalConstantValueLabelFA = toolkit.createLabel(forceAtlas2BasedComposite, Integer.toString(defaultGCFA));
	        gravitationalConstantValueLabelFA.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

	        gravitationalConstantScaleFA.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                int internalValue = gravitationalConstantScaleFA.getSelection();
	                int actualValue = minGCFA + internalValue;
	                gravitationalConstantValueLabelFA.setText(Integer.toString(actualValue)); 
	                forceAtlas2BasedComposite.layout(); // Update UI
	                networkViewer.changeGravitationalConstantFA(actualValue);
	            }
	        });

	        // Central Gravity
	        toolkit.createLabel(forceAtlas2BasedComposite, "centralGravity:");
	        Scale centralGravityScaleFA = new Scale(forceAtlas2BasedComposite, SWT.HORIZONTAL);
	        centralGravityScaleFA.setMinimum((int) (minCentralGravityFA*10));
	        centralGravityScaleFA.setMaximum((int) (maxCentralGravityFA*10));
	        centralGravityScaleFA.setSelection((int) (defaultCentralGravityFA*10));
	        centralGravityScaleFA.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label centralGravityValueLabelFA = toolkit.createLabel(forceAtlas2BasedComposite, String.format("%.2f", defaultCentralGravityFA));
	        centralGravityValueLabelFA.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

	        centralGravityScaleFA.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                float value = centralGravityScaleFA.getSelection() / 10.0f;
	                centralGravityValueLabelFA.setText(String.format("%.2f", value));
	                forceAtlas2BasedComposite.layout(); 
	                networkViewer.changeCentralGravityFA(value);
	            }
	        });

	        // Spring Length
	        toolkit.createLabel(forceAtlas2BasedComposite, "springLength:");
	        Scale springLengthScaleFA = new Scale(forceAtlas2BasedComposite, SWT.HORIZONTAL);
	        springLengthScaleFA.setMinimum(minSpringLengthFA);
	        springLengthScaleFA.setMaximum(maxSpringLengthFA);
	        springLengthScaleFA.setSelection(defaultSpringLengthFA);
	        springLengthScaleFA.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label springLengthValueLabelFA = toolkit.createLabel(forceAtlas2BasedComposite, Integer.toString(defaultSpringLengthFA));
	        springLengthValueLabelFA.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

	        springLengthScaleFA.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                int value = springLengthScaleFA.getSelection();
	                springLengthValueLabelFA.setText(Integer.toString(value)); 
	                forceAtlas2BasedComposite.layout(); // Update UI
	                networkViewer.changeSpringLengthFA(value);
	            }
	        });

	        // Spring Constant
	        toolkit.createLabel(forceAtlas2BasedComposite, "springConstant:");
	        Scale springConstantScaleFA = new Scale(forceAtlas2BasedComposite, SWT.HORIZONTAL);
	        springConstantScaleFA.setMinimum((int) (minSpringConstantFA*100));
	        springConstantScaleFA.setMaximum((int) (maxSpringConstantFA*100));
	        springConstantScaleFA.setSelection((int) (defaultSpringConstantFA*100));
	        springConstantScaleFA.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label springConstantValueLabelFA = toolkit.createLabel(forceAtlas2BasedComposite, String.format("%.2f", defaultSpringConstantFA));
	        springConstantValueLabelFA.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

	        springConstantScaleFA.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                float value = springConstantScaleFA.getSelection() / 100.0f;
	                springConstantValueLabelFA.setText(String.format("%.2f", value));
	                forceAtlas2BasedComposite.layout(); // Update UI
	                networkViewer.changeSpringConstantFA(value);
	            }
	        });

	        // Damping
	        toolkit.createLabel(forceAtlas2BasedComposite, "damping:");
	        Scale dampingScaleFA = new Scale(forceAtlas2BasedComposite, SWT.HORIZONTAL);
	        dampingScaleFA.setMinimum((int) (minDampingFA*100));
	        dampingScaleFA.setMaximum((int) (maxDampingFA*100));
	        dampingScaleFA.setSelection((int)  (defaultDampingFA*100));
	        dampingScaleFA.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label dampingValueLabelFA = toolkit.createLabel(forceAtlas2BasedComposite, String.format("%.2f", defaultDampingFA));
	        dampingValueLabelFA.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

	        dampingScaleFA.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                float value = dampingScaleFA.getSelection() / 100.0f;
	                dampingValueLabelFA.setText(String.format("%.2f", value));
	                forceAtlas2BasedComposite.layout(); // Update UI
	                networkViewer.changeDampingFA(value);
	            }
	        });

	        // Avoid Overlap
	        toolkit.createLabel(forceAtlas2BasedComposite, "avoidOverlap:");
	        Scale avoidOverlapScaleFA = new Scale(forceAtlas2BasedComposite, SWT.HORIZONTAL);
	        avoidOverlapScaleFA.setMinimum((int) minAvoidOverlapFA*100);
	        avoidOverlapScaleFA.setMaximum((int) maxAvoidOverlapFA*100);
	        avoidOverlapScaleFA.setSelection((int) defaultAvoidOverlapFA*100);
	        avoidOverlapScaleFA.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label avoidOverlapValueLabelFA = toolkit.createLabel(forceAtlas2BasedComposite, String.format("%.2f", defaultAvoidOverlapFA));
	        avoidOverlapValueLabelFA.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

	        avoidOverlapScaleFA.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                float value = avoidOverlapScaleFA.getSelection() / 100.0f;
	                avoidOverlapValueLabelFA.setText(String.format("%.2f", value));
	                forceAtlas2BasedComposite.layout(); // Update UI
	                networkViewer.changeAvoidOverlapFA(value);
	            }
	        });
	        
	        hideSubsection(forceAtlas2BasedSubsection);
	        
	        
	       // REPULSION SUBSECTION
	        
	        float defaultCGRep = 0.2f;
	        float minCGRep = 0f;
	        float maxCGRep = 10f;
	        
	        int defaultSpringLengthRep = 200;
	        int minSpringLengthRep = 0;
	        int maxSpringLengthRep = 500;
	        
	        float defaultSpringConstantRep = 0.05f;
	        float minSpringConstantRep = 0f;
	        float maxSpringConstantRep = 1.2f;
	        
	        int defaultNodeDistanceRep = 100;
	        int minNodeDistanceRep = 0;
	        int maxNodeDistanceRep = 500;
	        
	        float defaultDampingRep = 0.09f;
	        float minDampingRep = 0f;
	        float maxDampingRep = 1f;
	        
	       
	        
	        // Central Gravity
	        toolkit.createLabel(repulsionComposite, "centralGravity:");
	        Scale centralGravityScaleRep = new Scale(repulsionComposite, SWT.HORIZONTAL);
	        centralGravityScaleRep.setMinimum((int) (minCGRep*10));
	        centralGravityScaleRep.setMaximum((int) (maxCGRep*10));
	        centralGravityScaleRep.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label centralGravityValueLabelRep = toolkit.createLabel(repulsionComposite, String.format("%.2f", defaultCGRep));
	        centralGravityValueLabelRep.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        centralGravityScaleRep.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                float value = centralGravityScaleRep.getSelection() / 10.0f;
	                centralGravityValueLabelRep.setText(String.format("%.2f", value));
	                repulsionComposite.layout(); 
	                networkViewer.changeCentralGravityRep(value);
	            }
	        });
	        
	        // Spring Length
	        toolkit.createLabel(repulsionComposite, "springLength:");
	        Scale springLengthScaleRep = new Scale(repulsionComposite, SWT.HORIZONTAL);
	        springLengthScaleRep.setMinimum(minSpringLengthRep);
	        springLengthScaleRep.setMaximum(maxSpringLengthRep);
	        springLengthScaleRep.setSelection(defaultSpringLengthRep);
	        springLengthScaleRep.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label springLengthValueLabelRep = toolkit.createLabel(repulsionComposite, Integer.toString(defaultSpringLengthRep));
	        springLengthValueLabelRep.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

	        springLengthScaleRep.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                int value = springLengthScaleRep.getSelection();
	                springLengthValueLabelRep.setText(Integer.toString(value)); 
	                repulsionComposite.layout(); // Update UI
	                networkViewer.changeSpringLengthRep(value);
	            }
	        });
	        
	        // Spring Constant
	        toolkit.createLabel(repulsionComposite, "springConstant:");
	        Scale springConstantScaleRep = new Scale(repulsionComposite, SWT.HORIZONTAL);
	        springConstantScaleRep.setMinimum((int) (minSpringConstantRep*100));
	        springConstantScaleRep.setMaximum((int) (maxSpringConstantRep*100));
	        springConstantScaleRep.setSelection((int) (defaultSpringConstantRep*100));
	        springConstantScaleRep.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label springConstantValueLabelRep = toolkit.createLabel(repulsionComposite, String.format("%.2f", defaultSpringConstantRep));
	        springConstantValueLabelRep.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

	        springConstantScaleRep.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                float value = springConstantScaleRep.getSelection() / 100.0f;
	                springConstantValueLabelRep.setText(String.format("%.2f", value));
	                repulsionComposite.layout(); // Update UI
	                networkViewer.changeSpringConstantRep(value);
	            }
	        });
	        
	        // Node distance
	        toolkit.createLabel(repulsionComposite, "nodeDistance:");
	        Scale nodeDistanceScaleRep = new Scale(repulsionComposite, SWT.HORIZONTAL);
	        nodeDistanceScaleRep.setMinimum(minNodeDistanceRep);
	        nodeDistanceScaleRep.setMaximum(maxNodeDistanceRep);
	        nodeDistanceScaleRep.setSelection(defaultNodeDistanceRep);
	        nodeDistanceScaleRep.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label nodeDistanceValueLabelRep = toolkit.createLabel(repulsionComposite, Integer.toString(defaultNodeDistanceRep));
	        nodeDistanceValueLabelRep.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        nodeDistanceScaleRep.addSelectionListener(new SelectionAdapter() {
	        	@Override
	        	public void widgetSelected(SelectionEvent e) {
	        		int value = nodeDistanceScaleRep.getSelection();
	        		nodeDistanceValueLabelRep.setText(Integer.toString(value));
	        		repulsionComposite.layout();
	        		networkViewer.changeNodeDistanceRep(value);
	        	}
	        });
	        
	        // Damping
	        toolkit.createLabel(repulsionComposite, "damping:");
	        Scale dampingScaleRep = new Scale(repulsionComposite, SWT.HORIZONTAL);
	        dampingScaleRep.setMinimum((int) (minDampingRep*100));
	        dampingScaleRep.setMaximum((int) (maxDampingRep*100));
	        dampingScaleRep.setSelection((int)  (defaultDampingRep*100));
	        dampingScaleRep.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label dampingValueLabelRep = toolkit.createLabel(repulsionComposite, String.format("%.2f", defaultDampingRep));
	        dampingValueLabelRep.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

	        dampingScaleRep.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                float value = dampingScaleRep.getSelection() / 100.0f;
	                dampingValueLabelRep.setText(String.format("%.2f", value));
	                repulsionComposite.layout(); // Update UI
	                networkViewer.changeDampingRep(value);
	            }
	        });
	        
	        hideSubsection(repulsionSubsection);
	        
	        
	        // HIERARCHICAL REPULSION SUBSECTION
	        float defaultCGHrep = 0f;
	        float minCGHrep = 0f;
	        float maxCGHrep = 10f;
	        
	        int defaultSpringLengthHrep = 100;
	        int minSpringLengthHrep = 0;
	        int maxSpringLengthHrep = 500;
	        
	        float defaultSpringConstantHrep = 0.01f;
	        float minSpringConstantHrep = 0f;
	        float maxSpringConstantHrep = 1.2f;
	        
	        int defaultNodeDistanceHrep = 120;
	        int minNodeDistanceHrep = 0;
	        int maxNodeDistanceHrep = 500;
	        
	        float defaultDampingHrep = 0.09f;
	        float minDampingHrep = 0f;
	        float maxDampingHrep = 1f;
	        
	        float defaultAvoidOverlapHrep = 0f;
	        float minAvoidOverlapHrep = 0f;
	        float maxAvoidOverlapHrep = 1f;
	        
	        
	        
	        // Central Gravity
	        toolkit.createLabel(hierarchicalRepulsionComposite, "centralGravity:");
	        Scale centralGravityScaleHrep = new Scale(hierarchicalRepulsionComposite, SWT.HORIZONTAL);
	        centralGravityScaleHrep.setMinimum((int) (minCGHrep*10));
	        centralGravityScaleHrep.setMaximum((int) (maxCGHrep*10));
	        centralGravityScaleHrep.setSelection((int) (defaultCGHrep*10));
	        centralGravityScaleHrep.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label centralGravityValueLabelHrep = toolkit.createLabel(hierarchicalRepulsionComposite, String.format("%.2f", defaultCGHrep));
	        centralGravityValueLabelHrep.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        centralGravityScaleHrep.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                float value = centralGravityScaleHrep.getSelection() / 10.0f;
	                centralGravityValueLabelHrep.setText(String.format("%.2f", value));
	                hierarchicalRepulsionComposite.layout(); 
	                networkViewer.changeCentralGravityHrep(value);
	            }
	        });
	        
	        // Spring Length
	        toolkit.createLabel(hierarchicalRepulsionComposite, "springLength:");
	        Scale springLengthScaleHrep = new Scale(hierarchicalRepulsionComposite, SWT.HORIZONTAL);
	        springLengthScaleHrep.setMinimum(minSpringLengthHrep);
	        springLengthScaleHrep.setMaximum(maxSpringLengthHrep);
	        springLengthScaleHrep.setSelection(defaultSpringLengthHrep);
	        springLengthScaleHrep.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label springLengthValueLabelHrep = toolkit.createLabel(hierarchicalRepulsionComposite, Integer.toString(defaultSpringLengthHrep));
	        springLengthValueLabelHrep.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

	        springLengthScaleHrep.addSelectionListener(new SelectionAdapter() {
	        	@Override
	        	public void widgetSelected(SelectionEvent e) {
	        		int value = springLengthScaleHrep.getSelection();
	        		springLengthValueLabelHrep.setText(Integer.toString(value)); 
	        		hierarchicalRepulsionComposite.layout(); // Update UI
	        		networkViewer.changeSpringLengthHrep(value);
	        	}
	        });
	        
	        // Spring Constant
	        toolkit.createLabel(hierarchicalRepulsionComposite, "springConstant:");
	        Scale springConstantScaleHrep = new Scale(hierarchicalRepulsionComposite, SWT.HORIZONTAL);
	        springConstantScaleHrep.setMinimum((int) (minSpringConstantHrep*100));
	        springConstantScaleHrep.setMaximum((int) (maxSpringConstantHrep*100));
	        springConstantScaleHrep.setSelection((int) (defaultSpringConstantHrep*100));
	        springConstantScaleHrep.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label springConstantValueLabelHrep = toolkit.createLabel(hierarchicalRepulsionComposite, String.format("%.2f", defaultSpringConstantHrep));
	        springConstantValueLabelHrep.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

	        springConstantScaleHrep.addSelectionListener(new SelectionAdapter() {
	        	@Override
	        	public void widgetSelected(SelectionEvent e) {
	        		float value = springConstantScaleHrep.getSelection() / 100.0f;
	        		springConstantValueLabelHrep.setText(String.format("%.2f", value));
	        		hierarchicalRepulsionComposite.layout(); // Update UI
	        		networkViewer.changeSpringConstantHrep(value);
	        	}
	        });
	        
	        // Node distance
	        toolkit.createLabel(hierarchicalRepulsionComposite, "nodeDistance:");
	        Scale nodeDistanceScaleHrep = new Scale(hierarchicalRepulsionComposite, SWT.HORIZONTAL);
	        nodeDistanceScaleHrep.setMinimum(minNodeDistanceHrep);
	        nodeDistanceScaleHrep.setMaximum(maxNodeDistanceHrep);
	        nodeDistanceScaleHrep.setSelection(defaultNodeDistanceHrep);
	        nodeDistanceScaleHrep.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label nodeDistanceValueLabelHrep = toolkit.createLabel(hierarchicalRepulsionComposite, Integer.toString(defaultNodeDistanceHrep));
	        nodeDistanceValueLabelHrep.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        nodeDistanceScaleHrep.addSelectionListener(new SelectionAdapter() {
	        	@Override
	        	public void widgetSelected(SelectionEvent e) {
	        		int value = nodeDistanceScaleHrep.getSelection();
	        		nodeDistanceValueLabelHrep.setText(Integer.toString(value));
	        		hierarchicalRepulsionComposite.layout();
	        		networkViewer.changeNodeDistanceHrep(value);
	        	}
	        });
	        
	        // Damping
	        toolkit.createLabel(hierarchicalRepulsionComposite, "damping:");
	        Scale dampingScaleHrep = new Scale(hierarchicalRepulsionComposite, SWT.HORIZONTAL);
	        dampingScaleHrep.setMinimum((int) (minDampingHrep*100));
	        dampingScaleHrep.setMaximum((int) (maxDampingHrep*100));
	        dampingScaleHrep.setSelection((int)  (defaultDampingHrep*100));
	        dampingScaleHrep.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label dampingValueLabelHrep = toolkit.createLabel(hierarchicalRepulsionComposite, String.format("%.2f", defaultDampingHrep));
	        dampingValueLabelHrep.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

	        dampingScaleHrep.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                float value = dampingScaleHrep.getSelection() / 100.0f;
	                dampingValueLabelHrep.setText(String.format("%.2f", value));
	                hierarchicalRepulsionComposite.layout(); // Update UI
	                networkViewer.changeDampingHrep(value);
	            }
	        });
	        
	        // Avoid Overlap
	        toolkit.createLabel(hierarchicalRepulsionComposite, "avoidOverlap:");
	        Scale avoidOverlapScaleHrep = new Scale(hierarchicalRepulsionComposite, SWT.HORIZONTAL);
	        avoidOverlapScaleHrep.setMinimum((int) (minAvoidOverlapHrep*100));
	        avoidOverlapScaleHrep.setMaximum((int) (maxAvoidOverlapHrep*100));
	        avoidOverlapScaleHrep.setSelection((int)  (defaultAvoidOverlapHrep*100));
	        avoidOverlapScaleHrep.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label avoidOverlapValueLabelHrep = toolkit.createLabel(hierarchicalRepulsionComposite, String.format("%.2f", defaultAvoidOverlapHrep));
	        avoidOverlapValueLabelHrep.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));

	        avoidOverlapScaleHrep.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                float value = avoidOverlapScaleHrep.getSelection() / 100.0f;
	                avoidOverlapValueLabelHrep.setText(String.format("%.2f", value));
	                hierarchicalRepulsionComposite.layout(); // Update UI
	                networkViewer.changeAvoidOverlapHrep(value);
	            }
	        });

	        hideSubsection(hierarchicalRepulsionSubsection);
	        
	        
	        
	        // OUTSIDE SUBSECTION
	        
	        
	        // Max Velocity
	        toolkit.createLabel(genericComposite, "maxVelocity:");
	        Scale maxVelocityScale = new Scale(genericComposite, SWT.HORIZONTAL);
	        maxVelocityScale.setMinimum(0);
	        maxVelocityScale.setMaximum(150);
	        maxVelocityScale.setSelection(50);
	        maxVelocityScale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label maxVelocityValueLabel = toolkit.createLabel(genericComposite, "50");
	        maxVelocityValueLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        maxVelocityScale.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	            	int value = maxVelocityScale.getSelection();
	    	        maxVelocityValueLabel.setText(Integer.toString(value));
	    	        genericComposite.layout(); // Update UI
	                networkViewer.changeMaxVelocity(value);
	            }
	        });
	        
	        // Min Velocity
	        toolkit.createLabel(genericComposite, "minVelocity:");
	        Scale minVelocityScale = new Scale(genericComposite, SWT.HORIZONTAL);
	        minVelocityScale.setMinimum(1);
	        minVelocityScale.setMaximum(100);
	        minVelocityScale.setSelection(75);
	        minVelocityScale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label minVelocityValueLabel = toolkit.createLabel(genericComposite, "0.75");
	        minVelocityValueLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        minVelocityScale.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	            	float value = minVelocityScale.getSelection() / 100.0f;
	    	        minVelocityValueLabel.setText(String.format("%.2f", value));
	    	        genericComposite.layout(); // Update UI
	                networkViewer.changeMinVelocity(value);
	            }
	        });
	        
	        // Solver
	        toolkit.createLabel(genericComposite, "solver:");
	        solverCombo = new Combo(genericComposite, SWT.DROP_DOWN | SWT.READ_ONLY);
	        solverCombo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));

	        String[] solverAlgorithms = { "barnesHut", "forceAtlas2Based", "repulsion", "hierarchicalRepulsion" }; 
	        solverCombo.setItems(solverAlgorithms);
	        solverCombo.select(0);
	        showSubsection(barnesHutSubsection);
	        	 
	        solverCombo.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	                selectedSolver = solverCombo.getText();
	                
	                hideSubsection(barnesHutSubsection);
	                hideSubsection(forceAtlas2BasedSubsection);
	                hideSubsection(repulsionSubsection);
	                hideSubsection(hierarchicalRepulsionSubsection);
	                
	                if (isPhysicsEnabled) {
		                if (selectedSolver.equals("barnesHut")) {
		                	showSubsection(barnesHutSubsection);
		                } else if (selectedSolver.equals("forceAtlas2Based")) {
		                	showSubsection(forceAtlas2BasedSubsection);
		                } else if (selectedSolver.equals("repulsion")) {
		                	showSubsection(repulsionSubsection);
		                } else if (selectedSolver.equals("hierarchicalRepulsion")) {
		                	showSubsection(hierarchicalRepulsionSubsection);
		                }
	                }
		                
	                layoutPhysicsComposite.layout(true, true);
	                layoutPhysicsComposite.getParent().layout(true, true);
	                layoutPhysicsComposite.getParent().getParent().layout(true, true);
	                
	                scrolledComposite.setMinSize(parent.computeSize(SWT.DEFAULT, SWT.DEFAULT));
	                scrolledComposite.layout(true, true);
	            }
	        });

	        
	        // Timestep
	        toolkit.createLabel(genericComposite, " ");
	        toolkit.createLabel(genericComposite, "timestep:");
	        Scale timestepScale = new Scale(genericComposite, SWT.HORIZONTAL);
	        timestepScale.setMinimum(1);
	        timestepScale.setMaximum(100);
	        timestepScale.setSelection(50);
	        timestepScale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label timestepValueLabel = toolkit.createLabel(genericComposite, "0.5");
	        timestepValueLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        timestepScale.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	            	float value = timestepScale.getSelection() / 100.0f;
	            	timestepValueLabel.setText(String.format("%.2f", value));
	            	genericComposite.layout(); // Update UI
	                networkViewer.changeTimestep(value);
	            }
	        });
	        
	        
	        // WIND SUBSECTION
	       
	        
	        // X
	        toolkit.createLabel(windComposite, "x:");
	        Scale xScale = new Scale(windComposite, SWT.HORIZONTAL);
	        xScale.setMinimum(0);
	        xScale.setMaximum(200);
	        xScale.setSelection(100);
	        xScale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label xValueLabel = toolkit.createLabel(windComposite, "0");
	        xValueLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        xScale.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	            	float value = (xScale.getSelection() - 100) / 10.0f;
	    	        xValueLabel.setText(String.format("%.2f", value));
	                windComposite.layout();
	                networkViewer.changeWindX(value);
	            }
	        });
	        
	        // Y
	        toolkit.createLabel(windComposite, "y:");
	        Scale yScale = new Scale(windComposite, SWT.HORIZONTAL);
	        yScale.setMinimum(0);
	        yScale.setMaximum(200);
	        yScale.setSelection(100);
	        yScale.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false));
	        Label yValueLabel = toolkit.createLabel(windComposite, "0");
	        yValueLabel.setLayoutData(new GridData(SWT.LEFT, SWT.CENTER, false, false));
	        
	        yScale.addSelectionListener(new SelectionAdapter() {
	            @Override
	            public void widgetSelected(SelectionEvent e) {
	            	float value = (yScale.getSelection() - 100) / 10.0f;
	    	        yValueLabel.setText(String.format("%.2f", value));
	                windComposite.layout();
	                networkViewer.changeWindY(value);
	            }
	        });
	        	        
	        
	        scrolledComposite.setContent(editorComposite);
	        scrolledComposite.setMinSize(editorComposite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
	    }
	    
	   
        private void hideSubsection(Section subsection) {
        	subsection.setVisible(false);
            ((GridData) subsection.getLayoutData()).exclude = true;
            subsection.getParent().layout(true, true);       
        }

        private void showSubsection(Section subsection) {
        	subsection.setVisible(true);
            ((GridData) subsection.getLayoutData()).exclude = false;
            subsection.getParent().layout(true, true);
        }
        
        
}
