package com.biotechvana.netools.ui.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Table;

import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.ProjectEntry;

import org.eclipse.swt.widgets.Label;

public class OpenProjectDialog extends TitleAreaDialog {

    private IProjectsManager projectsManager;
    private ProjectEntry selectedProjectEntry;
    private TableViewer tableViewer;

    public OpenProjectDialog(Shell parentShell, IProjectsManager projectsManager) {
        super(parentShell);
        this.projectsManager = projectsManager;
    }

    @Override
    public void create() {
        super.create();
        setTitle("Select Project");
        setMessage("Select a project to open");
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite) super.createDialogArea(parent);
        Composite container = new Composite(area, SWT.NONE);
        container.setLayoutData(new GridData(GridData.FILL_BOTH));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout(layout);

        tableViewer = new TableViewer(container, SWT.BORDER | SWT.FULL_SELECTION);
        Table table = tableViewer.getTable();
        table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        TableViewerColumn nameColumn = new TableViewerColumn(tableViewer, SWT.NONE);
        nameColumn.getColumn().setText("Project Name");
        nameColumn.getColumn().setWidth(200);
        nameColumn.getColumn().setResizable(true);
        nameColumn.getColumn().setMoveable(true);
        nameColumn.setLabelProvider(new ColumnLabelProvider() {
            @Override
            public String getText(Object element) {
                return ((ProjectEntry) element).getProjectName();
            }
        }); 

        TableViewerColumn descriptionColumn = new TableViewerColumn(tableViewer, SWT.NONE);
        descriptionColumn.getColumn().setText("Description");
        descriptionColumn.getColumn().setWidth(300);
        descriptionColumn.getColumn().setResizable(true);
        descriptionColumn.getColumn().setMoveable(true);
        descriptionColumn.setLabelProvider(new ColumnLabelProvider() {
            @Override
            public String getText(Object element) {
                return ((ProjectEntry) element).getProjectDescription();
            }
            });
        tableViewer.setContentProvider(new ArrayContentProvider());
        tableViewer.setInput(projectsManager.getProjectEntries());

        
        
        
        
        

        

        return area;
    }

    
	protected void createButtonsForButtonBar(Composite parent) {
		
		// craete delete button with red color
		Button deleteButton = createButton(parent, IDialogConstants.DESELECT_ALL_ID, "Delete", false);
		// set the color of the button to red
		deleteButton.setForeground(parent.getDisplay().getSystemColor(SWT.COLOR_RED));
		
		// create OK and Cancel buttons by default
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL, true);
		createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CANCEL_LABEL, false);
	}
    
	
	@Override
	protected void buttonPressed(int buttonId) {
		if (buttonId == IDialogConstants.DESELECT_ALL_ID) {
			// delete button pressed
			// get the selected project
			IStructuredSelection selection = tableViewer.getStructuredSelection();
			selectedProjectEntry = (ProjectEntry) selection.getFirstElement();
			if (selectedProjectEntry == null) {
				setErrorMessage("Please select a project");
				return;
			}
			// show a dialog to confirm the deletion
			boolean confirmed = MessageDialog.openConfirm(getShell(), "Confirm Deletion",
					"Are you sure you want to delete the project " + selectedProjectEntry.getProjectName() + "?");
			if (!confirmed) {
				return;
			}
			// delete the project
			projectsManager.deleteProjectFromEntry(selectedProjectEntry);
			// refresh the table
			tableViewer.setInput(projectsManager.getProjectEntries());
		} else {
			super.buttonPressed(buttonId);
		}
	}
	
    @Override
    protected Control createButtonBar(Composite parent) {
    	// TODO Auto-generated method stub
    	Control btnsBar=  super.createButtonBar(parent);
    	Button cancelButton = getButton(CANCEL);
        
        cancelButton.addListener(SWT.Selection, e -> {
            selectedProjectEntry = null;
            cancelPressed();
        });
    	return btnsBar;
    }
    
    public ProjectEntry getSelectedProjectEntry() {
        return selectedProjectEntry;
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    @Override
    protected void okPressed() {
    	 IStructuredSelection selection = tableViewer.getStructuredSelection();
         selectedProjectEntry = (ProjectEntry) selection.getFirstElement();
			if (selectedProjectEntry == null) {
				setErrorMessage("Please select a project");
				return;
			}
        super.okPressed();
    }
}