package com.biotechvana.netools.ui.dialogs;


import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.NetworkDesign;
import com.biotechvana.netools.projects.Project;

import org.eclipse.swt.widgets.Label;

public class NewDesignDialog extends TitleAreaDialog {

    private Text designNameText;
    private Text designDescriptionText;
    private String designName;
    private String designDescription;
    private Project project;
    private NetworkDesign networkDesign;
    private String errorMessage;

    public NewDesignDialog(Shell parentShell) {
        super(parentShell);
    }

    public NewDesignDialog(Shell parentShell,   Project project) {
        super(parentShell);
        this.project = project;
    }

  

	@Override
    public void create() {
        super.create();
        setTitle("New Project");
        setMessage("Enter the details for the new project");
        if (errorMessage != null) {
            setErrorMessage(errorMessage);
        }
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite) super.createDialogArea(parent);
        Composite container = new Composite(area, SWT.NONE);
        container.setLayoutData(new GridData(GridData.FILL_BOTH));
        GridLayout layout = new GridLayout(2, false);
        container.setLayout(layout);

        createProjectNameField(container);
        createProjectDescriptionField(container);

//        if (project != null) {
//            projectNameText.setText(project.getProjectName());
//            projectDescriptionText.setText(project.getProjectDescription());
//        }

        return area;
    }

    private void createProjectNameField(Composite container) {
        Label lblProjectName = new Label(container, SWT.NONE);
        lblProjectName.setText("Network Design Name:");

        GridData dataProjectName = new GridData();
        dataProjectName.grabExcessHorizontalSpace = true;
        dataProjectName.horizontalAlignment = GridData.FILL;

        designNameText = new Text(container, SWT.BORDER);
        designNameText.setLayoutData(dataProjectName);
    }

    private void createProjectDescriptionField(Composite container) {
        Label lblProjectDescription = new Label(container, SWT.NONE);
        lblProjectDescription.setText("Project Description:");

        GridData dataProjectDescription = new GridData();
        dataProjectDescription.grabExcessHorizontalSpace = true;
        dataProjectDescription.horizontalAlignment = GridData.FILL;

        designDescriptionText = new Text(container, SWT.BORDER);
        designDescriptionText.setLayoutData(dataProjectDescription);
    }

    @Override
    protected boolean isResizable() {
        return true;
    }

    @Override
    protected void okPressed() {
    	designName = designNameText.getText();
    	designDescription = designDescriptionText.getText();
        if (validate() ) {
        	if (networkDesign == null) {
        		networkDesign = new NetworkDesign(designName, designDescription);
            }
        	networkDesign.setDesignName(designName);
        	networkDesign.setDescription(designDescription);
            super.okPressed();
        }
        
    }

    private boolean validate() {
		// TODO Auto-generated method stub
		if (designName == null || designName.isEmpty()) {
			setErrorMessage("Design Name cannot be empty");
			return false;
		}
		// check if the design name is unique
		if ( project.getNetworkDesigns().stream().anyMatch(d -> d.getDesignName().equals(designName))) {
			setErrorMessage("Design Name already exists");
			return false;
		}
		return true;
	}

	public String getDesignName() {
        return designName;
    }

    public String getDesignDescription() {
        return designDescription;
    }

    public NetworkDesign getNetworkDesign() {
        return networkDesign;
    }
}