package com.biotechvana.netools.projects.jobs;


import java.io.File;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;

import com.biotechvana.netools.projects.Dataset;
import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.Project;
import com.biotechvana.netools.projects.RawDTFile;
import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.tracking.ExecStatus;

import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
public class UploadRawDtFileJob extends Job  {

	File csvFile;
	Dataset newDataset;
	String csvSeparator;
	String sampleColumn;
	IProjectsManager projectsManager;
	
	
	
	public UploadRawDtFileJob(IProjectsManager projectsManager) {
        super("Upload Dataset");
        this.projectsManager = projectsManager;
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Running job...", IProgressMonitor.UNKNOWN);
        // do not save dataset herem file is not uploaded yet
        Project activeProject = newDataset.getProject();
		String datasetName = newDataset.getDatasetName();
		String projectName = activeProject.getProjectName();
		String projectID = activeProject.getProjectID();
		// append 00_ to datasetName 
		String fileName = "00_" + datasetName + ".csv";
        try {
        	RawDTFile rawDataFile =  new RawDTFile();
        	rawDataFile.setCsvFile(csvFile.getAbsolutePath());
        	rawDataFile.setCsvSeparator(csvSeparator);
        	rawDataFile.setSampleColumn(sampleColumn);
        	
        	
    		newDataset.addDTFile(rawDataFile);
    		
    		
    		
        	// Thread.sleep(10000); 
        	rawDataFile.setExecStatus(ExecStatus.Scheduled);
        	// Thread.sleep(10000);
        	String remotePath = projectsManager.uploadDataset(csvFile , newDataset, monitor);
        	rawDataFile.setExecStatus(ExecStatus.Running);
        	if (monitor.isCanceled()) {
        		// TODO :: handle
        		// handle cancellation
        		// delete uploaded file
        		// delete dataset
                return Status.CANCEL_STATUS;
            }
        	// Thread.sleep(1000); 
        	// once the file is uploaded submit the job to process the file
        	SubMonitor subMonitor  = SubMonitor.convert(monitor, IProgressMonitor.UNKNOWN);
        	subMonitor.setTaskName("Submitting to workflow");
    		
    		WorkflowJob job = rawDataFile.getWorkflowJob();
    		// Thread.sleep(5000);
    		// rawDataFile.setExecStatus(ExecStatus.Finished);
    		IValidationResult result = projectsManager.submitDTFileJob(rawDataFile,job, subMonitor);
    		if(!result.isOK()) {
    			
    			monitor.done();
    			rawDataFile.setExecStatus(ExecStatus.Failed);
    			// save project so far 
        		projectsManager.saveProject(newDataset.getProject(),false,  monitor);
    			return Status.error("Can not submit job to workflow");
    		}
    		


    		
        	
        } catch (Exception e) {
            return Status.error("Can not upload dataset");
        } finally {
            monitor.done();
        }
        
        // save project so far
		projectsManager.saveProject(newDataset.getProject(),false, monitor);
        return Status.OK_STATUS;
    }

	public void setCsvFile(File csvFile) {
		this.csvFile = csvFile;
		
	}

	public void setDataset(Dataset newDataset) {
		this.newDataset = newDataset;
		
	}

	public void setCsvSeparator(String csvSeparator) {
		this.csvSeparator = csvSeparator;
		
	}

	public void setSampleColumn(String sampleColumn) {
		this.sampleColumn = sampleColumn;
		
	}
}
