package com.biotechvana.netools.projects.jobs;


import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;

import com.biotechvana.netools.projects.DTFile;
import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.NetworkBuild;
import com.biotechvana.netools.projects.ProjectsManagerImpl;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;

import org.eclipse.core.runtime.Status;
/**
 * Job to run post update for a tracked task (DTFile or NetworkBuild, or  NetworkTasks)
 */
public class PostUpdateJob extends Job  {

	Object trackedTask;
	SubmissionHistoryEntry trackHistory;
	IProjectsManager projectsManager;
	public PostUpdateJob(IProjectsManager projectsManager, DTFile dtFile, SubmissionHistoryEntry trackHistory) {
        super("Update : " + dtFile.getFileName());
        this.trackedTask = dtFile;
        this.trackHistory = trackHistory;
        this.projectsManager = projectsManager;
        
    }

    public PostUpdateJob(ProjectsManagerImpl projectsManager2, NetworkBuild networkBuild,
			SubmissionHistoryEntry trackHistory2) {
    	 super("Update : " + networkBuild.getNetworkName());
			this.trackedTask = networkBuild;
			this.trackHistory = trackHistory2;
			this.projectsManager = projectsManager2;
	}

	@Override
    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask("Running job...", IProgressMonitor.UNKNOWN);

        try {
			if (trackedTask instanceof DTFile) {
				monitor.subTask("Post Update " + ((DTFile) trackedTask).getFileName() );
	        	((DTFile) this.trackedTask).postUpdate(trackHistory,monitor);
			}
			if (trackedTask instanceof NetworkBuild) {
				monitor.subTask("Post Update " + ((NetworkBuild) trackedTask).getNetworkName() );
            	((NetworkBuild) this.trackedTask).postUpdate(trackHistory, monitor);
			}
        	
            
        } catch (Exception e) {
            return Status.CANCEL_STATUS;
        } finally {
            monitor.done();
        }

        return Status.OK_STATUS;
    }
}
