package com.biotechvana.netools.projects.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Shell;

import com.biotechvana.netools.IWhiteListView;
import com.biotechvana.netools.projects.Dataset;
import com.biotechvana.netools.projects.DatasetType;
import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.NetworkDesign;
import com.biotechvana.netools.projects.Project;
import com.biotechvana.netools.projects.Variable;
import com.biotechvana.netools.projects.jobs.UploadRawDtFileJob;
import com.biotechvana.netools.ui.dialogs.ImportListDialog;

import org.eclipse.ui.PlatformUI;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.progress.IProgressService;
import jakarta.inject.Named;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class ListAddHandler {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(ListAddHandler.class);
	
	@CanExecute
	public boolean canExecute(@Optional @Named(IProjectsManager.ACTIVE_PROJECT) Project activeProject) {
		// Check if we have an active project
		logger.debug("Active project: " + activeProject);
		return activeProject != null;
		
	}
	
	
    @Execute
    public void execute(
    		IProjectsManager projectsManager,
    		IWhiteListView whiteListView,
    		@Named(IProjectsManager.ACTIVE_PROJECT) Project activeProject,
    		@Named(IServiceConstants.ACTIVE_SHELL) Shell activeShell,
    		@Named(IProjectsManager.ACTIVE_DESIGN) NetworkDesign networkDesign,
    		MApplication application,
    		IProgressService progressService
    		) throws InvocationTargetException, InterruptedException {
    	
    	
    	ImportListDialog dialog = new ImportListDialog(activeShell , activeProject);
        if (dialog.open() == ImportListDialog.OK) {
            // Retrieve the dataset details from the dialog
            String csvSeparator =   dialog.getCsvSeparator();
            char separator = csvSeparator.charAt(0);
            //String sampleColumn =   dialog.getSelectedSampleNameClm();
            File csvFile = dialog.getCsvFile();
            
            // Create the Dataset object
            
            // Optionally, add the new dataset to a manager or context for further processing
            // For example:
            // datasetManager.addDataset(newDataset);

            // Log or print the dataset details
            // System.out.println("Dataset created:");
            // System.out.println("Name: " + newDataset.getDatasetName());
            // System.out.println("Type: " + newDataset.getDatasetType());
            
            System.out.println("CSV File: " + (csvFile != null ? csvFile.getAbsolutePath() : "None"));
            
          progressService.run(true, true, new IRunnableWithProgress() {

						@Override
						public void run(IProgressMonitor monitor)
								throws InvocationTargetException, InterruptedException {
		
					            Reader reader = null;
								try {
									reader = new FileReader(csvFile);
								} catch (FileNotFoundException e) {
									// TODO Auto-generated catch block
									e.printStackTrace();
								}
					            CSVParser csvParser = null;
								try {
									csvParser = new CSVParser(reader,
									        CSVFormat.DEFAULT.withDelimiter(separator).withFirstRecordAsHeader());
								} catch (IOException e) {
									// TODO Auto-generated catch block
									e.printStackTrace();
								}
					            List<String[]> data = new ArrayList<>();
					            List<String> headers = csvParser.getHeaderNames();
					            logger.info("Headers: " + headers);
					            for (CSVRecord csvRecord : csvParser) {
					                String[] row = new String[headers.size()];
					                for (int i = 0; i < headers.size(); i++) {
					                    row[i] = csvRecord.get(i);
					                }
					                data.add(row);
					            }
					            
					            List <String> fromList = new ArrayList<>();
					            List <String> toList = new ArrayList<>();
					            Variable from = null;
					            Variable to = null;
								for (String[] row : data) {
								    if (row.length > 0 && row[0] != null && !row[0].isEmpty()) {
								        fromList.add(row[0]);
								        from = activeProject.getVariableByName(row[0]);
								    }
								    if (row.length > 1 && row[1] != null && !row[1].isEmpty()) {
								        toList.add(row[1]);
								        to = activeProject.getVariableByName(row[1]);
								    }
								    networkDesign.addWhitelist(from, to);
								}
						
								//System.out.println(fromList);
								//System.out.println(toList);
							
							if (monitor.isCanceled()) {
								// TODO :: handle cancellation
								// return;
							}
							projectsManager.saveProject(activeProject,monitor);
							whiteListView.refreshView();
				            
				            /*UploadRawDtFileJob uploadJob = new UploadRawDtFileJob(projectsManager);
				            uploadJob.setCsvFile(csvFile);
				            uploadJob.setCsvSeparator(csvSeparator);
				            //uploadJob.setSampleColumn(sampleColumn);
				            uploadJob.setUser(true);
				            uploadJob.schedule(1000);*/
						}
						
					});
                   
        }
    }
 
    
}
