package com.biotechvana.netools.projects.handlers;

import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.swt.widgets.Shell;

import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.Project;
import com.biotechvana.netools.ui.dialogs.NewProjectDialog;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;

public class CreateProjectHandler {
	
	
	@CanExecute
	public boolean canExecute(IProjectsManager projectsManager) {
		return projectsManager.canCreateProject();
	}
	
	@Execute
	public void execute(IProjectsManager projectsManager,Shell shell, IProgressService progressService) {
		NewProjectDialog dialog = new NewProjectDialog(shell, projectsManager); // Create dialog instance
		if ( dialog.open() == dialog.OK ) { // Open the dialog
			
			Project project = dialog.getProject();
			
			try {
				//progressService.busyCursorWhile(monitor -> {
				progressService.run(true, false, monitor -> {
					monitor.beginTask("Creating project...", IProgressMonitor.UNKNOWN);
					try {
						projectsManager.createProject(project);
						projectsManager.saveProject(project, monitor);
						projectsManager.setActiveProject(project);
					}
					catch (Exception e) {
                        // show an error message
						// delete the project
						projectsManager.deleteProject(project);
						
						throw new RuntimeException(e);
					}
					
					monitor.done();
				});
			} catch (InvocationTargetException | InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				// show an error message
				
			}
			
			
			
		}
	}

}
