package com.biotechvana.netools.projects.handlers;

import java.io.File;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.services.IServiceConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

import com.biotechvana.netools.projects.Dataset;
import com.biotechvana.netools.projects.DatasetType;
import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.Project;
import com.biotechvana.netools.projects.jobs.UploadRawDtFileJob;
import com.biotechvana.netools.ui.dialogs.NewDatasetDialog;

import org.eclipse.ui.PlatformUI;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.progress.IProgressService;
import jakarta.inject.Named;

public class AddNewDatasetHandler {
	static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(AddNewDatasetHandler.class);

	@CanExecute
	public boolean canExecute(@Optional @Named(IProjectsManager.ACTIVE_PROJECT) Project activeProject) {
		// Check if we have an active project
		logger.debug("Active project: " + activeProject);
		return activeProject != null;
		
	}
	
	
    @Execute
    public void execute(
    		IProjectsManager projectsManager,
    		@Named(IProjectsManager.ACTIVE_PROJECT) Project activeProject,
    		@Named(IServiceConstants.ACTIVE_SHELL) Shell activeShell,
    		MApplication application,
    		IProgressService progressService
    		) throws InvocationTargetException, InterruptedException {
    	
    	
    	// if(true) {
		// 	datasetTests(projectsManager, activeProject);
		// 	return;
		
    	// }
    	
//    	IProgressService progressService = application.getContext().get(IProgressService.class);
//    	 progressService.run(true, true, new IRunnableWithProgress() {
//
//				@Override
//				public void run(IProgressMonitor monitor)
//						throws InvocationTargetException, InterruptedException {
//					System.out.println("Upload in progress");
//					
//				}
//				
//			});
    	// IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        // Show the NewDatasetDialog
    	 // Show the NewDatasetDialog
    	 // create a new shell
    	// Shell shell = new Shell(activeShell.getDisplay(), activeShell.getStyle());
        NewDatasetDialog dialog = new NewDatasetDialog(activeShell , activeProject);
        if (dialog.open() == NewDatasetDialog.OK) {
            // Retrieve the dataset details from the dialog
            String datasetName = dialog.getDatasetName();
            DatasetType datasetType = dialog.getDatasetType();
            String csvSeparator =   dialog.getCsvSeparator();
            String sampleColumn =   dialog.getSelectedSampleNameClm();
            File csvFile = dialog.getCsvFile();

            // Create the Dataset object
            
            // Optionally, add the new dataset to a manager or context for further processing
            // For example:
            // datasetManager.addDataset(newDataset);

            // Log or print the dataset details
//            System.out.println("Dataset created:");
//            System.out.println("Name: " + newDataset.getDatasetName());
//            System.out.println("Type: " + newDataset.getDatasetType());
            
            System.out.println("CSV File: " + (csvFile != null ? csvFile.getAbsolutePath() : "None"));
            
		try {
          //progressService.run(true, true, new IRunnableWithProgress() {
		  progressService.run(true, false, monitor -> {
					monitor.beginTask("Creating project...", IProgressMonitor.UNKNOWN);

							Dataset newDataset = new Dataset(datasetName, datasetType);
							logger.info("Creating Dataset:");
							logger.info("Name: " + newDataset.getDatasetName());
							logger.info("Type: " + newDataset.getDatasetType());
				            activeProject.addDataset(newDataset);
							if (monitor.isCanceled()) {
								// TODO :: handle cancellation
								// return;
							}
							projectsManager.saveProject(activeProject,monitor);
				            
				            UploadRawDtFileJob uploadJob = new UploadRawDtFileJob(projectsManager);
				            uploadJob.setCsvFile(csvFile);
				            uploadJob.setDataset(newDataset);
				            uploadJob.setCsvSeparator(csvSeparator);
				            uploadJob.setSampleColumn(sampleColumn);
				            uploadJob.setUser(true);
				            uploadJob.schedule(1000);

							monitor.done();
						
					});
			} catch (InvocationTargetException | InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				// show an error message
				
			}
            
            
            
//            progressService.run(true, true, new IRunnableWithProgress() {
//
//						@Override
//						public void run(IProgressMonitor monitor)
//								throws InvocationTargetException, InterruptedException {
//							// TODO Auto-generated method stub
//							// upload the csv file to the remote storage
//							projectsManager.uploadDataset( newDataset,csvFile, monitor);
//						}
//						
//					});
//			progressService.busyCursorWhile( 
//            
//					new IRunnableWithProgress() {
//
//						@Override
//						public void run(IProgressMonitor monitor)
//								throws InvocationTargetException, InterruptedException {
//							// TODO Auto-generated method stub
//							// upload the csv file to the remote storage
//							projectsManager.uploadDataset(activeProject, newDataset,newDataset.getCsvFile(), monitor);
//						}
//						
//					}
//					
//			);
            // assuming all validations are done, we can now save the dataset to the database
            
            
        }
    }
    
	private void datasetTests(IProjectsManager projectsManager, Project activeProject) {
		// TODO Auto-generated method stub
		// Create a new dataset
		Dataset newDataset = new Dataset("exp_vars", 
				DatasetType.EXPERIMENT );
		
		File csvFile =	new File("/home/ahafez/Desktop/GPRO/netools/1.Exp_var.csv");

		// Add the dataset to the active project
		activeProject.addDataset(newDataset);

		// Log or print the dataset details
		System.out.println("Dataset created:");
		System.out.println("Name: " + newDataset.getDatasetName());
		System.out.println("Type: " + newDataset.getDatasetType());
		System.out.println(
				"CSV File: " + (csvFile != null ? csvFile.getAbsolutePath() : "None"));

		// Optionally, upload the dataset to a remote storage
		projectsManager.uploadDataset( newDataset, csvFile, null);
		
		
		newDataset = new Dataset("bacteria", 
				DatasetType.MICROBIOTA );
		
		csvFile =	new File("/home/ahafez/Desktop/GPRO/netools/bacterias.csv");
		
		// Add the dataset to the active project
		activeProject.addDataset(newDataset);
		// Log or print the dataset details
				System.out.println("Dataset created:");
				System.out.println("Name: " + newDataset.getDatasetName());
				System.out.println("Type: " + newDataset.getDatasetType());
				System.out.println(
						"CSV File: " + (csvFile != null ? csvFile.getAbsolutePath() : "None"));

				// Optionally, upload the dataset to a remote storage
		projectsManager.uploadDataset( newDataset, csvFile, null);
		
		projectsManager.saveProject(activeProject);
		
	}
    
}
