package com.biotechvana.netools.projects;

import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.manager.IWorkflowManager;
import com.biotechvana.workflow.submissionhistory.SubmissionHistoryEntry;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.biotechvana.netools.jobs.DTUploadJob;

@JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "dataFilename")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE)
public class RawDTFile extends DTFile {
	private static final Logger logger = LoggerFactory.getLogger(RawDTFile.class);
	private static final long serialVersionUID = 4259667004096437252L;

	// RawDTFile should have 00_{fileName}.csv ready uploaded in the server
	// After processing it we should have two more files
	// 01_{fileName}_variables.csv and 01_{fileName}_samples.csv available in the server

	// Info used to process the file.,
	String localCsvFile;
	String sampleNameColumn;
	String csvSeparator;

	String samplesFilename;
	String variablesFilename;
	String rawDataFilename;

	

	@JsonCreator
	public RawDTFile() {
		
	}

	@Override
	public String getDescription() {
		//		if (fileName != null)
		//			return "Raw data file - " + fileName;
		//		else
		return "Raw data file";
	}
	@Override
	protected void setFileName(String baseName) {
		rawDataFilename = "00_" + baseName + ".csv";
		variablesFilename = "01_" + baseName + "_variables.csv";
		samplesFilename = "01_" + baseName + "_samples.csv";
		dataFilename = "01_" + baseName + ".csv";
		
	}

	




	//	public boolean sumbitToWorkflow(IWorkflowManager workflowManager) {
	//		DTUploadJob job = new DTUploadJob();
	//		job.setWorkflowManager(workflowManager);
	//		int n_prevoius_jobs = preProcessorsIds.size() +1;
	//		String job_id =  fileName + "_upload_" + n_prevoius_jobs;
	//		job.setJobName(job_id);
	//		String output_folder = dataset.getProject().getTasksDirectory() ;
	//		job.setBaseDirectory(output_folder);
	//		job.setDatasetName(dataset.getDatasetName());
	//
	//		IValidationResult result = workflowManager.runWorkflowJob(job);
	//		if (result.isOK()) {
	//			preProcessorsIds.add(job_id);
	//			return true;
	//
	//		}
	//		return false;
	//
	//	}

	/**
	 * get the workflow job to submit to the workflow manager
	 * @param sampleNameColumn 
	 * @param csvSeparator 
	 * @param sampleNameColumn2 
	 * @return
	 */
	public WorkflowJob getWorkflowJob() {
		
		
		String remoteCsvFile = dataset.getProject().getProjectManager().resolveFile(dataset, rawDataFilename);
		if (remoteCsvFile == null) {
			logger.error("Can not find the file " + rawDataFilename + " in the server");
			throw new IllegalArgumentException("Can not find the file " + rawDataFilename + " in the server");
		}
		DTUploadJob job = new DTUploadJob();
		// job.setWorkflowManager(workflowManager);
		int n_prevoius_jobs = preProcessorsIds.size() +1;
		String job_id = this.getDataset().getDatasetID();
		job_id =  this.getDataset().getProject().getProjectID() + "_01_"+   job_id + "_upload_" + n_prevoius_jobs;
		job.setJobName(job_id);
		String output_folder = dataset.getProject().getTasksDirectory() ;

		job.setBaseDirectory(output_folder);

		job.setProjectId(dataset.getProject().getProjectID());

		job.setDatasetID(dataset.getDatasetID());

		job.setDatasetName(dataset.getDatasetName());
		job.setDatasetType(dataset.getDatasetType().getKey());

		job.setInputFile(remoteCsvFile);	

		job.setDatasetDirectory(dataset.getBaseDirectory());

		job.setCSVSeparator(csvSeparator);
		job.setSampleNameColumn(sampleNameColumn);

		preProcessorsIds.add(job_id);
		return job;

	}


	@Override
	public IValidationResult getValidationResult() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void postUpdate(SubmissionHistoryEntry trackHistory, IProgressMonitor monitor) {
		// handle once the file is uploaded and processed we need to check that everything is ok : here TODO 
		// check that the files are available in the server
		
		if (trackHistory !=  null ) {
			if (trackHistory.getStatus() ==  ExecStatus.Failed) {
				setExecStatus(ExecStatus.Failed);
				return;
			}
		}
		IProjectsManager projectManager = dataset.getProject().getProjectManager();
		boolean isValid = true;
		isValid = isValid && projectManager.validateFile(dataset, dataFilename);
		isValid = isValid && projectManager.validateFile(dataset, variablesFilename);
		isValid = isValid && projectManager.validateFile(dataset,  samplesFilename);
		if (isValid) {
			try {
				// all good so far 
				// reads variables info from variablesFile
				
				readVariablesInfo(monitor);
				readSamplesInfo(monitor);
				setExecStatus(ExecStatus.Finished);
				// notify dataset to see what to do next
				dataset.getProject().getProjectManager().saveProject(dataset.getProject(), monitor);
			}
			catch (Exception e) {
				setExecStatus(ExecStatus.Failed);
				logger.error("Can not post update", e);
			}
			
			
		}

	}
	
	
	/**
	 * General update after loading project
	 * @param monitor
	 */
//	public void postUpdate(IProgressMonitor monitor) {
//		if (getExecStatus() == ExecStatus.Finished) {
//			boolean isValid = true;
//			IProjectsManager projectManager = dataset.getProject().getProjectManager();
//			isValid = isValid && projectManager.validateFile(dataset, dataFilename);
//			isValid = isValid && projectManager.validateFile(dataset, variablesFilename);
//			isValid = isValid && projectManager.validateFile(dataset,  samplesFilename);
//			if (isValid) {
//				try {
//					// all good so far 
//					// reads variables info from variablesFile
//					
//					readVariablesInfo(monitor);
//					readSamplesInfo(monitor);
//					
//					// notify dataset to see what to do next
//				}
//				catch (Exception e) {
//					logger.error("Can not post update", e);
//				}
//			}
//		} 
//		// else we are not finished yet
//	}
	

	/**
	 * reads samples info from samplesFile 
	 * samplesFile is csv file with two columns : "SampleID","HasMissingData"
	 * @param monitor
	 */
	private void readSamplesInfo(IProgressMonitor monitor) {
		IProjectsManager projectManager = dataset.getProject().getProjectManager();
		String remoteSamplesFile = projectManager.resolveFile(dataset, samplesFilename);
		
		try (Reader reader = projectManager.getRemoteStorage().openForReading(remoteSamplesFile);
				CSVParser csvParser = new CSVParser(reader,
						CSVFormat.DEFAULT.withDelimiter(',').withFirstRecordAsHeader())) {
			
			csvParser.forEach(record -> {
				String id = record.get("SampleID");
				Sample sample = new Sample();
				sample.setName(id);
				sample.setId(id);
				sample.setHasMissingData(Boolean.parseBoolean(record.get("HasMissingData")));
				dataset.addSample(sample,this);
			});
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}

	/**
	 * variablesFile is csv file with two columns : VariableID, VariableName, DataType, Distribution, VariableType, HasMissingData
	 * @param monitor
	 * @return
	 */
	private boolean readVariablesInfo(IProgressMonitor monitor) {
		IProjectsManager projectManager = dataset.getProject().getProjectManager();
		String remoteVariablesFile = projectManager.resolveFile(dataset, variablesFilename);
		
		// dataset.varaibes logic
		
		try (Reader reader = projectManager.getRemoteStorage().openForReading(remoteVariablesFile);
				 CSVParser csvParser = new CSVParser(reader, CSVFormat.DEFAULT.withDelimiter(',').withFirstRecordAsHeader())) {
				csvParser.forEach(record -> {
					Variable variable = new Variable();
					String id = record.get("VariableID");
					variable.setId(id);
					String variableName = record.get("VariableName");
					variable.setName(	variableName);
					variable.setDataType(DatasetType.valueOf(record.get("DataType").toUpperCase()));
					variable.setDistribution(Distribution.valueOf(record.get("Distribution").toUpperCase()));
					variable.setVariableType(VariableType.valueOf(record.get("VariableType").toUpperCase()));
					variable.setHasMissingData(Boolean.parseBoolean(record.get("HasMissingData")));
					dataset.addVariable(variable);
				});
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				return false;
			}
		return true;
	}

	public void setCsvFile(String localCsvFile) {
		this.localCsvFile = localCsvFile;		
	}

	public void setCsvSeparator(String csvSeparator2) {
		this.csvSeparator = csvSeparator2;
		
	}

	public void setSampleColumn(String sampleColumn) {
		this.sampleNameColumn = sampleColumn;
	}

	@Override
	protected String getFilePath() {
		String remoteDataFile = dataset.getProject().getProjectManager().resolveFile(dataset, dataFilename);
		return remoteDataFile;
	}



}
