package com.biotechvana.netools.projects;

import java.io.IOException;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;

public class ProjectDeserializer extends JsonDeserializer<Project> {

	@Override
	public Project deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JacksonException {
		 // Default behavior using ObjectMapper
        ObjectMapper mapper = (ObjectMapper) p.getCodec();
        Project project = mapper.readValue(p, Project.class);
        return project;
	}

}
