package com.biotechvana.netools.projects;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

import com.biotechvana.netools.models.NetworkModel;
import com.biotechvana.workflow.tracking.ExecStatus;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;

@JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "networkID" , scope = Network.class)
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE)
public class Network {

	String networkID;
	
	
	String networkName;
	String networkPath;
	
	
	
	
	Network parentNetwork;
	
	
	List<Network> childNetworks = new ArrayList<Network>();
	
	@JsonBackReference
	private Project project;
	
	boolean isDAGNetwork = false;
	
	transient NetworkModel networkModel;
	private ExecStatus status = ExecStatus.Unknown;
	public static Network createNetwork(
			Project project, 
			String networkName, 
			String networkID ,
			boolean isDagNetwork ,
			IProgressMonitor monitor) {
		Network network = new Network();
		network.networkName = networkName;
		// clean the network name to remove any spaces or special characters
		network.networkID = networkID;
		// network.networkDirectory = networkDirectory;
		network.networkPath = project.getNetworkDirectory(networkID)  ;
		network.isDAGNetwork = isDagNetwork;
		// TODO ::  before we continue we need to check if the network already added and leaded to the project before
		// if so show a dialog to confirm a reset of the network or not
		
		
		String edgesFile = network.networkPath + "/" + networkName + ".edges.csv";
		String nodesFile = network.networkPath +  "/" + networkName + ".nodes.csv";
		
		// create network model
		// NetworkModel networkModel = NetworkModel.createNetwork(network.networkName , nodesFile,edgesFile ,project , monitor );
//		if (project == null) {
//			return network;
//		}
//		
//		
//			 Network childNetwork = createNetwork(null, networkName, networkDirectory , monitor);
//			 network.addChildNetwork(childNetwork);
//			 
//			 childNetwork.setProject(project);
//			 
//			 childNetwork = createNetwork(null, networkName, networkDirectory , monitor);
//			 network.addChildNetwork(childNetwork);
//			 
//			 childNetwork.setProject(project);
			 
		
		project.addNetwork(network);
		
		
		// create network model
		network.createNetworkModel(monitor);
		
		
		// save the network
		network.networkModel.saveNetwork(monitor);
		
		
		
		
		network.status = ExecStatus.Finished;
		
		return network;
		
	}
	
	
	// get networkID
	public String getNetworkID() {
		return networkID;
	}
	
	private void addChildNetwork(Network childNetwork) {
		childNetwork.parentNetwork = this;
		this.childNetworks.add(childNetwork);
	
		
	}

	public static Network createNetwork(Project project, String networkName, String networkDirectory, boolean isDagNetwork ) {
		return createNetwork(project, networkName, networkDirectory ,isDagNetwork, new NullProgressMonitor());
	}
	
	public void setProject(Project project) {
		this.project = project;	
	}
	
	public void createNetworkModel(IProgressMonitor monitor) {
		String edgesFile = networkPath + "/" + networkID + ".edges.csv";
		String nodesFile = networkPath +  "/" + networkID + ".nodes.csv";
		if(isDAGNetwork)
		networkModel = NetworkModel.createNetwork(this , nodesFile,edgesFile , true, monitor );
		else 
			networkModel = NetworkModel.createNetwork(this , nodesFile,edgesFile , false,monitor );
		networkModel.saveNetwork(monitor);
	}
	public void loadNetworkModel(IProgressMonitor monitor) {
		networkModel = NetworkModel.loadNetwork(this);
		setStatus(ExecStatus.Finished);
		
	}

	private void setStatus(ExecStatus newStatus) {
		status = newStatus;
		if (project != null) {
			project.getProjectManager().networkUpdated(this);
		}
		
		
	}


	public String getNetworkName() {
		return networkName;
	}

	public NetworkModel getModel() {
		
		return networkModel;
	}

	public Project getProject() {
		return project;
	}

	public String getNetworkDirectory() {
		
		return networkPath;
	}


	public ExecStatus getStatus() {
		
		return status;
	}


	
	
}
