package com.biotechvana.netools.projects;

import java.io.File;
import java.util.List;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;

import com.biotechvana.netools.jobs.NetworkJob;
import com.biotechvana.workflow.IValidationResult;
import com.biotechvana.workflow.WorkflowJob;

public interface IProjectsManager {

	
	public static final String ACTIVE_PROJECT = "active_project";
	public static final String SELECTED_DATASET = "selected_dataset";
	public static final String SELECTED_DTFILE = "selected_dtfile";
	public static final String ACTIVE_DESIGN = "active_design";
	public static final String SELECTED_DESIGN = "selected_design";
	
	
	
	
	boolean canCreateProject();



	void saveProjects() throws Exception;

    void loadProjects() throws Exception;



	void createProject(Project activeProject);



	boolean uploadDataset(Dataset newDataset, File csvFile, IProgressMonitor monitor);
	boolean uploadDataset(Dataset newDataset, File csvFile, String csvSeparator   ,
    String sampleNameColumn,  IProgressMonitor monitor);



	Project getActiveProject();
	List<ProjectEntry> getProjectEntries();
	
//	public IEventBroker getEventBroker ();



	void datasetAddedToProject(Dataset dataset);
	void datasetRemovedFromProject(Dataset selectedDataset);
	void networkBuildAddedToProject(NetworkBuild networkBuild);

	void projectNameChanged(Project project);



	void projectDescriptionChanged(Project project);



	String getBaseFolder();



	void saveProject(Project activeProject);



	void userChanging();



	void userChanged();



	/**
	 * Event to notify that a new file has been added to the dataset
	 * @param file
	 */
	void dtFileAddedToDataset(DTFile file);
	void dtFileUpdated(DTFile dtFile);


	

	String uploadDataset(File csvFile, Dataset newDataset, IProgressMonitor monitor);



	IValidationResult submitDTFileJob(DTFile dataFile, WorkflowJob job, SubMonitor subMonitor);


	boolean validateFile(Dataset dataset, String string);



	String resolveFile(Dataset dataset, String dataFile);



	RemoteStorage getRemoteStorage();



	void saveProject(Project activeProject, IProgressMonitor monitor);
	public void saveProject(Project activeProject,boolean saveDatasets,   IProgressMonitor monitor);


	void deleteDataset(Dataset selectedDataset,IProgressMonitor monitor);



	void setSelectedDataset(Dataset selectedDataset);



	String createNetworkDirectory(NetworkBuild networkBuild, IProgressMonitor monitor);
	String createNetworkDirectory(Project project, String  baseName, IProgressMonitor monitor);



	IValidationResult submitNetworkJob(NetworkBuild networkBuild, WorkflowJob job, IProgressMonitor monitor);



	void networkBuildUpdated(NetworkBuild networkBuild);



	void resfreshNetworkBuild(NetworkBuild build);



	void deleteNetworkBuild(NetworkBuild build);
	void deleteNetworkBuild(NetworkBuild build,IProgressMonitor monitor);


	void networkBuildDeleted(NetworkBuild build);



	void networkAddedToProject(Network network);



	void setActiveProjectFromEntry(ProjectEntry selectedProject);
	void setActiveProject(Project project);



	void deleteProject(Project project);
	void deleteProjectFromEntry(ProjectEntry selectedProjectEntry);


	void createProject(Project activeProject, IProgressMonitor monitor);



	void networkDeleted(Network selectedNetwork);



	void deleteNetwork(Network selectedNetwork, IProgressMonitor monitor);



	void networkUpdated(Network network);



	void networkDesignAddedToProject(NetworkDesign design);



	void setActiveDesign(NetworkDesign newDesign);



	void setSelectedDesgin(NetworkDesign networkDesign);



	NetworkDesign getActiveDesign();



	




	

	



	

}
