package com.biotechvana.netools.projects;

// distribution enum with the following Nominal, Multinomial, NegativeBinomial, ZINegativeBinomial, Normal, Gamma, Poisson, 
// Binomial, NegativeBinomial, Exponential, Uniform, Beta, Cauchy, ChiSquare, F, LogNormal,
public enum Distribution {
	BINOMIAL("Binomial", "Binomial"), 
	GAMMA("Gamma", "Gamma"),
	LOGNORMAL("Log_Normal", "Log Normal"), 
	MULTINOMIAL("Multinomial", "Multinomial"),
	NB("NB", "Negative Binomial"), 
	NOMINAL("Nominal", "Nominal"), 
	NORMAL("Normal", "Normal"), 
	POISSON("Poisson", "Poisson"), 
	ZINB("ZINB", "Zero Inflated Negative Binomial");


	private final String key;			// Unique key
	private final String value;			// Value for widget text

	private Distribution(String key, String value) {
		this.key = key;
		this.value = value;
	}
	
	
	public String getKey() {
		return key;
	}
	
	public String getValue() {
		return value;
	}
}