package com.biotechvana.netools.projects;

public enum DatasetType {
	GENERAL("General", "General"),
	COVARIATE("Covariate", "Covariate"),
	EXPERIMENT("Experiment", "Experiment Control"),
	METABOLOMIC("Metabolomic", "Metabolomics"),
	MICROARRAY("Microarray", "Microarray"),
	MICROBIOTA("Microbiota", "Microbiota"),
	OUTCOME("Outcome", "Outcome"),
	PROTEOMIC("Proteomic", "Proteomic"),
	RNASEQ("RNAseq", "RNAseq");

	// SingleCell("SingleCell", "Single Cell"), 
	// Bulk("Bulk", "Bulk");

	private final String key;			// Unique key
	private final String value;			// Value for widget text
	private DatasetType(String key, String value) {
		this.key = key;
		this.value = value;
	}
	
	public String getKey() {
		return key;
	}
	
	public String getValue() {
		return value;
	}
}
