package com.biotechvana.netools.projects;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

// main function of the network design is to get a black list and white list of the network
// to infer a network structure from the data
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE)
public class Arc {
	private String source;
    
    private String target;

    private String reason;
    
    @JsonBackReference
    NetworkDesign design;
    
    
    
    @JsonCreator
    public Arc(@JsonProperty("source") String source, @JsonProperty("target") String target) {
        this.source = source;
        this.target = target;
    }

    public Variable getSource() {
    	
        return design.getProject().getVariable(source);
    }

    public Variable getTarget() {
        return design.getProject().getVariable(target);
    }
    
    public String getReason() {
        return reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Arc arc = (Arc) o;
        return Objects.equals(source, arc.source) && Objects.equals(target, arc.target);
    }

    @Override
    public int hashCode() {
        return Objects.hash(source, target);
    }

	public void setNetworkDesign(NetworkDesign networkDesign) {
		this.design = networkDesign;
	}
	
	
}