package com.biotechvana.netools.models.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultEdge;

public class Main {
    public static void main(String[] args) throws Exception {
        // Sample JSON input
        String json = """
        {
            "edges": [
                { "source": "A", "target": "B" },
                { "source": "B", "target": "C" }
            ]
        }
        """;

        // Configure ObjectMapper with the mix-in
        ObjectMapper mapper = new ObjectMapper();
        mapper.addMixIn(DefaultDirectedWeightedGraph.class, DefaultDirectedWeightedGraphMixin.class);

        // Deserialize the JSON into a graph
        DefaultDirectedWeightedGraph<String, DefaultEdge> graph =
                mapper.readValue(json, DefaultDirectedWeightedGraph.class);

        // Verify the deserialized graph
        System.out.println("Vertices: " + graph.vertexSet());
        System.out.println("Edges: " + graph.edgeSet());
    }
}
