package com.biotechvana.netools.models.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.graph.DefaultEdge;

import java.io.IOException;

public class DW2GraphDeserializer extends JsonDeserializer<DefaultDirectedWeightedGraph<String, DefaultEdge>> {
    @Override
    public DefaultDirectedWeightedGraph<String, DefaultEdge> deserialize(JsonParser parser,
                                                                         DeserializationContext context) throws IOException, JsonProcessingException {
        DefaultDirectedWeightedGraph<String, DefaultEdge> graph =
                new DefaultDirectedWeightedGraph<>(DefaultEdge.class);

        JsonNode rootNode = parser.getCodec().readTree(parser);
        JsonNode edgesNode = rootNode.get("edges");

        if (edgesNode != null && edgesNode.isArray()) {
            for (JsonNode edgeNode : edgesNode) {
                String source = edgeNode.get("source").asText();
                String target = edgeNode.get("target").asText();

                graph.addVertex(source);
                graph.addVertex(target);
                graph.addEdge(source, target);
            }
        }

        return graph;
    }
}