package com.biotechvana.netools.models.json;

import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;

import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;

// import org.jgrapht.graph.da;

import com.biotechvana.netools.models.DirectedWeightedNetwork;
import com.biotechvana.netools.models.Edge;
import com.biotechvana.netools.models.Node;
import com.biotechvana.netools.projects.Variable;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;

public class DDWGraph  {

	
	static  public Node getNodeById(DefaultDirectedWeightedGraph<Node, Edge> network, String nodeId) {
        return network.vertexSet().stream().filter(node -> node.getId().equals(nodeId)).findFirst().orElse(null);
    }
	
	public static void main(String[] args) {
		String nodesFile = "/home/ahafez/Desktop/GPRO/netools/network/test.nodes.csv";
		String edgesFile = "/home/ahafez/Desktop/GPRO/netools/network/test.edges.csv";
		
		DefaultDirectedWeightedGraph<Node, Edge> network = new DefaultDirectedWeightedGraph<Node, Edge>(Edge.class);	

		try (Reader reader =  new FileReader(nodesFile);
                
			CSVParser csvParser = new CSVParser(reader, CSVFormat.DEFAULT.withDelimiter(',').withFirstRecordAsHeader())) {
			// read the network file , file has at least two columns "ID","Cluster","InDegree","OutDegree","DegreeCentrality","ClosenessCentrality","BetweennessCentrality"

			csvParser.getRecords().forEach(record -> {
				String id = record.get("ID");
				
				// String label = record.get("Label");
				// logger.debug("Node : " + id + " with label (" + label + ")");
				Node newNode = new Node(id);
				network.addVertex(newNode);
				// if the record has a cluster column, then add it to the Node
				if (record.isMapped("Cluster") ) {
					String cluster = record.get("Cluster");					
					newNode.setAttribute("Cluster", cluster);
				}
			
					//newNode.setAttribute("Variable", variable);
					
					newNode.setLabel(id);
					newNode.setAttribute("Type", "Variable");
					newNode.setAttribute("Distribution", "Normal");
				
				
			});
		} catch (IOException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}

		try (Reader reader =  new FileReader(edgesFile);
				CSVParser csvParser = new CSVParser(reader, CSVFormat.DEFAULT.withDelimiter(',').withFirstRecordAsHeader())) {
			// read the network file , file has at least two columns "From","To" and a score 
			csvParser.getRecords().forEach(record -> {
				String id = record.get("ID");
				String from = record.get("From");
				String to = record.get("To");
				String score = record.get("Score");
				
				
				// Add edge to network with the score as weight
				try {
					double weightScore = Double.parseDouble(score);
					Node fromNode=  getNodeById(network,from); 
					Node toNode=  getNodeById(network,to);
					Edge edge = new Edge();
					edge.setWeight(weightScore);
					edge.setId(id);
					network.addEdge(fromNode, toNode, edge);
				} catch (NumberFormatException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			});
			
			
			// testing saveing and loading the network
			// save the network
			String networkPath  = "/home/ahafez/Desktop/GPRO/netools/network/test.network.json";
			// open the network file for writing
			OutputStream networkStream = new FileOutputStream(networkPath);
			
//			SimpleModule module = new SimpleModule();
//			
//			module.addSerializer( DDWGraph .class, new DDWGraphSerializer());
//			module.addDeserializer(DDWGraph.class, new DDWGraphDeserializer());

			
			ObjectMapper mapper = JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).build();
//			mapper.registerModule(module);
			mapper.writeValue(networkStream, network);
			mapper.addMixIn(DefaultDirectedWeightedGraph.class, DefaultDirectedWeightedGraphMixin.class);
			
			// load the network
			DDWGraph network2 = mapper.readValue(new FileReader(networkPath), DDWGraph.class);
			
			
		}
		catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
	}

}
