package com.biotechvana.netools.models;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

import org.jgrapht.Graph;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;

import com.biotechvana.netools.projects.Project;


/**
 * Our main network model for a directed weighted network.
 * To represent a DAG (Directed Acyclic Graph) we use a directed weighted graph.
 */
public class UnDirectedWeightedNetwork extends NetworkModel {

	
	DefaultDirectedWeightedGraph<Node,Edge> dwGraph;
	public UnDirectedWeightedNetwork() {
		super(GraphType.UNDIRECTED);
		dwGraph = new DefaultDirectedWeightedGraph<Node, Edge>(Edge.class);
		
	}
	
	public void addEdge(String fromNodeId, String toNodeId, double weight) {
	    Node fromNode = getNodeById(fromNodeId);
	    Node toNode = getNodeById(toNodeId);
	    if (fromNode != null && toNode != null) {
	        Edge edge = addEdge(fromNode, toNode);
	        setEdgeWeight(edge, weight);
	        
	    }
	}

	
	public static UnDirectedWeightedNetwork fromCSV(String nodesFile, String edgesFile) throws IOException {
        UnDirectedWeightedNetwork network = new UnDirectedWeightedNetwork();

        // Read nodes.csv
        try (BufferedReader br = new BufferedReader(new FileReader(nodesFile))) {
            String line;
            br.readLine(); // Skip header
            while ((line = br.readLine()) != null) {
                String[] parts = line.split(",");
                String id = parts[0];
                String label = parts[1];
                String cluster = parts[2];
                
                Node node = network.addNode(id);
                node.setLabel(label);
                node.setGroup(cluster);
                
            }
        }

        // Read edges.csv
        try (BufferedReader br = new BufferedReader(new FileReader(edgesFile))) {
            String line;
            br.readLine(); // Skip header
            while ((line = br.readLine()) != null) {
                String[] parts = line.split(",");
                String fromId = parts[0];
                String toId = parts[1];
                double weight = Double.parseDouble(parts[2]);
               
                if (fromId != null && toId != null) {
                    network.addEdge(fromId, toId, weight);
                }
            }
        }

        return network;
    }

	@Override
	protected Graph<Node, Edge> getGraph() {
		return dwGraph;
	}



//	@Override
//	protected Graph<Node, Edge> getGraph() {
//        return dwGraph;
//    
//    
//	}

}
