package com.biotechvana.netools.models;

import org.jgrapht.Graph;
import org.jgrapht.graph.SimpleGraph;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;


@JsonIdentityInfo(generator = ObjectIdGenerators.PropertyGenerator.class, property = "networkName")
@JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.ANY, getterVisibility = JsonAutoDetect.Visibility.NONE)

public class SimpleNetwork extends NetworkModel {

	
	SimpleGraph<Node, Edge> simpleGraph;
	
	public SimpleNetwork() {
		super(GraphType.SIMPLE);
		simpleGraph = new SimpleGraph<>(Edge.class);
		
	}
	
	
	// Test the implementation
    public static void main(String[] args) {
        NetworkModel networkModel = new SimpleNetwork();
        String visJsData = networkModel.exportToVisJsFormat();
        System.out.println(visJsData);
        
        String visJsDataSimple = networkModel.exportToVisJsFormatSimple();
        System.out.println(visJsDataSimple);
    }


	@Override
	protected Graph< Node, Edge> getGraph() {
		// TODO Auto-generated method stub
		return simpleGraph;
	}



}
