package com.biotechvana.netools.internal;

import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

import com.biotechvana.netools.projects.Dataset;
import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.ui.INormalizationView;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;

public class NormalizationView implements INormalizationView {

	FormToolkit toolkit;
	Form detailsForm;

	Dataset selected_dataset;
	IProjectsManager projectsManager;

	@Inject
	IProgressService progressService;


	@Inject
	UISynchronize sync;

	@Inject
	@Optional
	public void setSelectedDataset(@Named(IProjectsManager.SELECTED_DATASET) Dataset dataset) {
		selected_dataset = dataset;
		updateUI();
	}
	private void updateUI() {
		if (detailsForm == null || detailsForm.isDisposed()) {
			return;
		}
		if (selected_dataset != null) {
			detailsForm.setText("Nomralization Option - " + selected_dataset.getDatasetName());
			// Clear previous content
			for (Control child : detailsForm.getBody().getChildren()) {
				child.dispose();
			}
			// Create new content based on dataset type
			switch (selected_dataset.getDatasetType()) {
			case GENERAL:
				createGeneralUI(detailsForm.getBody());
				break;
			case COVARIATE:
				createCovariateUI(detailsForm.getBody());
				break;
				// Add cases for other dataset types as needed
			default:
				createDefaultUI(detailsForm.getBody());
				break;
			}
			detailsForm.getBody().layout(true, true);
		} else {
			detailsForm.setText("Nomralization Option - No dataset selected");
			// Clear previous content
			for (Control child : detailsForm.getBody().getChildren()) {
				child.dispose();
			}
			toolkit.createLabel(detailsForm.getBody(), "No dataset selected");
		}
	}

	// Methods to create UI for different dataset types
	private void createGeneralUI(Composite parent) {
		createDefaultUI(parent);
	}

	private void createCovariateUI(Composite parent) {
		createDefaultUI(parent);
	}

	private void createDefaultUI(Composite parent) {
		toolkit.createLabel(parent, "No Nomralization are applicable to this dataset type");
	}

	@PostConstruct
	public void createPartControl(Composite parent, MApplication app, IProjectsManager projectsManager) {
		app.getContext().set(INormalizationView.class, this);
		this.projectsManager = projectsManager;
		toolkit = new FormToolkit(parent.getDisplay());

		ScrolledComposite scrolledComposite = new ScrolledComposite(parent, SWT.V_SCROLL | SWT.H_SCROLL);
		scrolledComposite.setLayout(new FillLayout());
		scrolledComposite.setExpandHorizontal(true);
		scrolledComposite.setExpandVertical(true);

		detailsForm = toolkit.createForm(scrolledComposite);
		scrolledComposite.setContent(detailsForm);

		detailsForm.setText("Nomralization Option - No dataset selected");
		detailsForm.getBody().setLayout(new FillLayout());

	}
}
