package com.biotechvana.netools.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.json.JSONArray;
import org.json.JSONObject;

import com.biotechvana.netools.INetworkView;
import com.biotechvana.netools.INodesView;
import com.biotechvana.netools.ISelectionManager;
import com.biotechvana.netools.ISelectionEvent;
import com.biotechvana.netools.models.Edge;
import com.biotechvana.netools.models.IEdge;
import com.biotechvana.netools.models.INode;
import com.biotechvana.netools.models.NetworkModel;
import com.biotechvana.netools.models.Node;
import com.fasterxml.jackson.core.JsonProcessingException;

import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

public class NetworkView implements INetworkView  {
	private static final Logger logger = LoggerFactory.getLogger(NetworkView.class);

	Browser browser;
	NetworkModel network;


	@Inject
	IStatusLineManager manager;
	
	

	@Inject
	UISynchronize uiSync;
	
	@Inject
	MApplication app;

	boolean isDirty = false;


	// for debugging
	private boolean allowInspect = true;



	// some layout properties
	boolean showNavigation = false;
	boolean showLabels = true;
	boolean showEdges = true;
	boolean usePhysics = true;
	boolean fixX=false;
	boolean fixY=false;
	boolean smoothCurves = false;
	boolean hideEdgesOnDrag = true;

	
	ISelectionManager selectionManager;
	
	INodesView nodesViewer;
	
	
	@Inject
	public void setNodesViewer(@Optional INodesView nodesViewer) {
		this.nodesViewer = nodesViewer;
	}
	
	@PostConstruct
	public void createPartControl(Composite parent, EPartService partService , MApplication application) {
		logger.info("Creating NetworkView");

		application.getContext().set(INetworkView.class, this);
		selectionManager = new SelectionManager();
		application.getContext().set(ISelectionManager.class, selectionManager);
		
		
		
		Composite container = new Composite(parent, SWT.NONE);
		container.setLayout(new GridLayout(1, false));

		browser = new Browser(container, SWT.NONE);
		browser.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		//
		// Disable the default context menu in the browser
		if (!allowInspect) {
			browser.addListener(SWT.MenuDetect, event -> event.doit = false);
			//createContextMenu();
		}
		//
		//        // Create a custom context menu for the SWT control



		// Add a progress listener to track page loading
		browser.addProgressListener(new ProgressListener() {



			@Override
			public void completed(ProgressEvent event) {
				System.out.println("Page loaded: " + browser.getUrl());
				if (network != null) {
					initGraph(network);
				} else {
					System.out.println("Network is null");
				}


			}

			@Override
			public void changed(ProgressEvent event) {
				// Handle load progress here if needed
				System.out.println("Page changed: " + browser.getUrl());
				//HtmlLoader.load( browser, "NetworkViewer.html" );

			}
		});


		// Load the HTML file
		//browser.setUrl("/home/data/eclipse/git-J11/netools/com.biotechvana.netools/bundles/com.biotechvana.netools.ui/src/com/biotechvana/netools/internal/resources/NetworkViewer.html");
		
		/*try {
		    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		    DocumentBuilder builder = factory.newDocumentBuilder();
		    Document document = builder.parse(new File("C:\\Users\\ivanc\\Projects\\NetTools\\netools\\com.biotechvana.netools\\bundles\\com.biotechvana.netools.ui\\src\\com\\biotechvana\\netools\\internal\\resources\\NetworkViewer.html"));
		    System.out.println("L'arxiu s'ha parsejat correctament!");
		} catch (Exception e) {
		    e.printStackTrace();
		}*/

		
		HtmlLoader.load( browser, "NetworkViewer.html" );
		//HtmlLoader.load(browser, "Test.html");
		addBrowserFunction();

		//		browser.addMouseListener(new MouseAdapter() {
		//		@Override
		//			public void mouseDown(MouseEvent e) {
		//				System.out.println("Mouse Down");
		//			}
		//		@Override
		//			public void mouseDoubleClick(MouseEvent e) {
		//				// TODO Auto-generated method stub
		//				super.mouseDoubleClick(e);
		//				
		//			}
		//			
		//		});



		Composite toolbox = new Composite(container, SWT.NONE);
		toolbox.setLayout(new FormLayout());
		GridData gd= new GridData(SWT.FILL, SWT.FILL, true, false);

		toolbox.setLayoutData(gd);
		createToolbox(toolbox);
	}


	private void createContextMenu() {
		Menu contextMenu = new Menu(browser.getShell(), SWT.POP_UP);
		MenuItem menuItem1 = new MenuItem(contextMenu, SWT.PUSH);
		menuItem1.setText("Custom Action 1");
		menuItem1.addListener(SWT.Selection, e -> {
			System.out.println("Custom Action 1 selected");
			// Add your custom action here
		});

		MenuItem menuItem2 = new MenuItem(contextMenu, SWT.PUSH);
		menuItem2.setText("Custom Action 2");
		menuItem2.addListener(SWT.Selection, e -> {
			System.out.println("Custom Action 2 selected");
			// Add your custom action here
		});

		// Attach the custom context menu to the browser
		browser.setMenu(contextMenu);

		// Optionally, you can show the context menu on right-click
		browser.addListener(SWT.MouseDown, event -> {
			if (event.button == 3) { // Right-click
				contextMenu.setVisible(true);
			}
		});

	}


	private void createToolbox(Composite toolbox) {
		int fixedHight = (int) (TRIM_DEFAULT_HEIGHT*0.9);
		// layoutGroup.setText("Layout");

		// Formlayoutdata 
		FormData fromData = new FormData();
		fromData.top = new FormAttachment(0, 0);
		fromData.height = fixedHight;


		// Checkbox for disabling physics
		Button physics = new Button(toolbox, SWT.TOGGLE);
		physics.setLayoutData(fromData);
		physics.setToolTipText("Enable/Disable Physics");
		// physics.setText("Physics");
		// set icon
		physics.setImage(JFaceResources.getImageRegistry().get(Dialog.DLG_IMG_MESSAGE_INFO));
		physics.setSelection(true);
		physics.setSelection(usePhysics);
		physics.addSelectionListener(new SelectionAdapter() {

			@Override
			public void widgetSelected(SelectionEvent e) {
				// Call JavaScript function to enable/disable physics
				usePhysics = physics.getSelection();
				tooglePhysics(physics.getSelection());
			}


		});

		// fix x btn
		Button fixXBtn = new Button(toolbox, SWT.TOGGLE);
		fromData = new FormData();
		fromData.top = new FormAttachment(0, 0);
		fromData.left = new FormAttachment(physics, 5);
		fromData.height = fixedHight;
		fixXBtn.setLayoutData(fromData);
		fixXBtn.setText("FixX");
		fixXBtn.setToolTipText("Fix X axis");
		fixXBtn.setSelection(fixX);
		fixXBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				// Call JavaScript function to enable/disable physics
				fixX = fixXBtn.getSelection();
				//updateFixXY();
				updateFixX();

			}
		});
		// fix y btn	
		Button fixYBtn = new Button(toolbox, SWT.TOGGLE);
		fromData = new FormData();
		fromData.top = new FormAttachment(0, 0);
		fromData.left = new FormAttachment(fixXBtn, 5);
		fromData.height = fixedHight;
		fixYBtn.setLayoutData(fromData);
		fixYBtn.setText("FixY");
		fixYBtn.setToolTipText("Fix Y axis");
		fixYBtn.setSelection(fixY);
		fixYBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				// Call JavaScript function to enable/disable physics
				fixX = fixYBtn.getSelection();
				//updateFixXY();
				updateFixY();
			}
		});

		// checkbox for showing labels

		// checkbox for showing edges


		// show navigation btn
		Button showNavigationBtn = new Button(toolbox, SWT.TOGGLE);
		fromData = new FormData();
		// align to right
		fromData.top = new FormAttachment(0, 0);
		fromData.right = new FormAttachment(100, 0);
		fromData.height = fixedHight;
		showNavigationBtn.setLayoutData(fromData);
		showNavigationBtn.setText("Show Navigation");
		showNavigationBtn.setToolTipText("Show Navigation");
		showNavigationBtn.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				// Call JavaScript function to show/hide navigation
				showNavigation = showNavigationBtn.getSelection();
				showNavigation(showNavigationBtn.getSelection());
			}
		});

	}
	
	// NODE FUNCTIONALITIES
	
	@Override
	public void changeNodeBorderWidth(Set<Node> nodes, int value) {
		StringBuilder nodeIds = processNodes(nodes);
		for(Node node : nodes ) {
			node.setBorderWidth(value);
		}
	    String script = "changeNodeBorderWidth(" + nodeIds.toString() + ", " + value + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeNodeBorderWidthSelected(Set<Node> nodes, int value) {
		StringBuilder nodeIds = processNodes(nodes);
		for(Node node : nodes ) {
			node.setBorderWidthSelected(value);
		}
	    String script = "changeNodeBorderWidthSelected(" + nodeIds.toString() + ", " + value + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeNodeColor(Set<Node> nodes, String color) {
		StringBuilder nodeIds = processNodes(nodes);
		
		//String colorString = transformColor(color);
		String darker = deriveColor(color, 0.75);
		String lighter = deriveColor(color, 1.25);
		
		for(Node node : nodes ) {
			node.setColor(color);
			// CHANGE ASSOCIATED COLOR ATTRIBUTES
			node.setColorBorder(darker);
			node.setColorHighlight(lighter);
			node.setColorHighlightBorder(darker);
			node.setColorHover(lighter);
			node.setColorHoverBorder(darker);
		}
	    String script = "changeNodeColor(" + nodeIds.toString() + ", " + "'" + color + "'" + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeNodeColorBorder(Set<Node> nodes, String color) {
		StringBuilder nodeIds = processNodes(nodes);
		//String colorString = transformColor(color);
		for(Node node : nodes ) {
			node.setColorBorder(color);
		}
	    String script = "changeNodeColorBorder(" + nodeIds.toString() + ", " + "'" + color + "'" + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeNodeColorHighlight(Set<Node> nodes, String color) {
		StringBuilder nodeIds = processNodes(nodes);
		//String colorString = transformColor(color);
		for(Node node : nodes ) {
			node.setColorHighlight(color);
		}
	    String script = "changeNodeColorHighlight(" + nodeIds.toString() + ", " + "'" + color + "'" + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeNodeColorHighlightBorder(Set<Node> nodes, String color) {
		StringBuilder nodeIds = processNodes(nodes);
		//String colorString = transformColor(color);
		for(Node node : nodes ) {
			node.setColorHighlightBorder(color);
		}
	    String script = "changeNodeColorHighlightBorder(" + nodeIds.toString() + ", " + "'" + color + "'" + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeNodeColorHover(Set<Node> nodes, String color) {
		StringBuilder nodeIds = processNodes(nodes);
		//String colorString = transformColor(color);
		for(Node node : nodes ) {
			node.setColorHover(color);
		}
	    String script = "changeNodeColorHover(" + nodeIds.toString() + ", " + "'" + color + "'" + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeNodeColorHoverBorder(Set<Node> nodes, String color) {
		StringBuilder nodeIds = processNodes(nodes);
		//String colorString = transformColor(color);
		for(Node node : nodes ) {
			node.setColorHoverBorder(color);
		}
	    String script = "changeNodeColorHoverBorder(" + nodeIds.toString() + ", " + "'" + color + "'" + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeNodeOpacity(Set<Node> nodes, float value) {
		StringBuilder nodeIds = processNodes(nodes);
		for(Node node : nodes ) {
			node.setOpacity(value);
		}
		String script = "changeNodeOpacity(" + nodeIds.toString() + ", " + value + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeNodeShape(Set<Node> nodes, String newShape) {
		StringBuilder nodeIds = processNodes(nodes);
		for(Node node : nodes ) {
			node.setShape(newShape);
		}
		String script = "changeNodeShape(" + nodeIds.toString() + ", " + "'" + newShape + "'" + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeNodeSize(Set<Node> nodes, int value) {
		StringBuilder nodeIds = processNodes(nodes);
		for(Node node : nodes ) {
			node.setSize(value);
		}
		String script = "changeNodeSize(" + nodeIds.toString() + ", " + value + ");";
	    browser.execute(script);
	}
	
	public String transformColor(RGB color) {
		 String colorString = String.format("'rgb(%d, %d, %d)'", color.red, color.green, color.blue);
		 return colorString;
	}
	
	public String deriveColor(String color, double factor) {
		 if (color == null) return "#000000";
		    String h = color.startsWith("#") ? color.substring(1) : color;
		    int r = Integer.parseInt(h.substring(0, 2), 16);
		    int g = Integer.parseInt(h.substring(2, 4), 16);
		    int b = Integer.parseInt(h.substring(4, 6), 16);

		    r = (int)Math.round(Math.max(0, Math.min(255, r * factor)));
		    g = (int)Math.round(Math.max(0, Math.min(255, g * factor)));
		    b = (int)Math.round(Math.max(0, Math.min(255, b * factor)));

		    return String.format("#%02x%02x%02x", r, g, b);
	}
	
	public StringBuilder processNodes(Set<Node> nodes) {
		StringBuilder nodeIds = new StringBuilder("[");
	    for (Node node : nodes) {
	        String nodeId = getNodeId(node);
	        if (nodeId != null) {
	            nodeIds.append("'").append(nodeId).append("',");
	        }
	    }

	    if (!nodes.isEmpty() && nodeIds.length() > 1) {
	        nodeIds.setLength(nodeIds.length() - 1);
	    }
	    nodeIds.append("]");
	    
	    return nodeIds;
	}
	
	public String getNodeId(Node node) {
	    if (node == null) {
	        return null;
	    }

	    try {
	    	
	        Field viewerAttributesField = node.getClass().getDeclaredField("viewerAttributes");
	        viewerAttributesField.setAccessible(true); 
	        
	        @SuppressWarnings("unchecked")
	        Map<String, Object> viewerAttributes = (Map<String, Object>) viewerAttributesField.get(node);
	        
	        if (viewerAttributes != null) {
	            Object idValue = viewerAttributes.get("id");
	            if (idValue instanceof String) {
	                return (String) idValue;
	            }
	        }
	    } catch (NoSuchFieldException | IllegalAccessException e) {
	        e.printStackTrace();
	    }
	    
	    return null; 
	}
	
	
	// EDGE FUNCTIONALITIES
	
	@Override
	public void changeEdgeColor(Set<Edge> edges, String color) {
		StringBuilder edgeIds = processEdges(edges);
		
		String darker = deriveColor(color, 0.75);
		String lighter = deriveColor(color, 1.25);
		
		for(Edge edge : edges ) {
			edge.setColor(color);
			edge.setColorHighlight(lighter);
			edge.setColorHover(lighter);
		}
	    String script = "changeEdgeColor(" + edgeIds.toString() + ", " + "'" + color + "'" + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeEdgeColorHighlight(Set<Edge> edges, String color) {
		StringBuilder edgeIds = processEdges(edges);
		for(Edge edge : edges ) {
			edge.setColorHighlight(color);
		}
	    String script = "changeEdgeColorHighlight(" + edgeIds.toString() + ", " + "'" + color + "'" + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeEdgeColorHover(Set<Edge> edges, String color) {
		StringBuilder edgeIds = processEdges(edges);
		for(Edge edge : edges ) {
			edge.setColorHover(color);
		}
	    String script = "changeEdgeColorHover(" + edgeIds.toString() + ", " + "'" + color + "'" + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeEdgeColorOpacity(Set<Edge> edges,  float value) {
		StringBuilder edgeIds = processEdges(edges);
		for(Edge edge : edges ) {
			edge.setOpacity(value);
		}
		String script = "changeEdgeColorOpacity(" + edgeIds.toString() + ", " + value + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeEdgeWidth(Set<Edge> edges,  double value) {
		StringBuilder edgeIds = processEdges(edges);
		for(Edge edge : edges ) {
			edge.setWidth(value);
		}
		String script = "changeEdgeWidth(" + edgeIds.toString() + ", " + value + ");";
	    browser.execute(script);
	} 
	
	@Override
	public void showDashes(boolean show) {
		String script = "showDashes(" + show + ");";
		browser.execute(script);
	}
	
	@Override
	public void showEdgeLabels(boolean show) {
		String script = "showEdgeLabels(" + show + ");";
		browser.execute(script);
	}
	
	@Override
	public void hideEdges(boolean hide) {
		String script = "hideEdges(" + hide + ");";
		browser.execute(script);	
	}
	
	public StringBuilder processEdges(Set<Edge> edges) {
		StringBuilder edgeIds = new StringBuilder("[");
	    for (Edge edge : edges) {
	        String edgeId =  edge.getId();
	        if (edgeId != null) {
	            edgeIds.append("'").append(edgeId).append("',");
	        }
	    }

	    if (!edges.isEmpty() && edgeIds.length() > 1) {
	        edgeIds.setLength(edgeIds.length() - 1);
	    }
	    edgeIds.append("]");
	    
	    return edgeIds;
	}
	
	/*public String getEdgeId(Edge edge) {
	    if (edge == null) {
	        return null;
	    }

	    try {
	        Field edgeIdField = edge.getClass().getDeclaredField("edgeID");
	        edgeIdField.setAccessible(true); 
	        
	        Object idValue = edgeIdField.get(edge);
	        if (idValue instanceof String) {
	            return (String) idValue;
	        }
	    } catch (NoSuchFieldException | IllegalAccessException e) {
	        e.printStackTrace();
	    }
	    
	    return null;
	}*/
	
	public String getEdgeId(Edge edge) {
	    if (edge == null) {
	        return null;
	    }

	    try {
	        Field viewerAttributesField = edge.getClass().getDeclaredField("viewerAttributes");
	        viewerAttributesField.setAccessible(true); 
	        
	        @SuppressWarnings("unchecked")
	        Map<String, Object> viewerAttributes = (Map<String, Object>) viewerAttributesField.get(edge);
	        
	        if (viewerAttributes != null) {
	            Object idValue = viewerAttributes.get("id");
	            if (idValue instanceof String) {
	                return (String) idValue;
	            }
	        }
	    } catch (NoSuchFieldException | IllegalAccessException e) {
	        e.printStackTrace();
	    }
	    
	    return null; 
	}
	
	
	// LAYOUT OPTIONS
	
	// EDGES
	
	@Override
	public void enableSmoothness(boolean enable) {
		String script = "enableSmoothness(" + enable + ");";
	    browser.execute(script);
	}
	
	@Override
	public void changeSmoothnessType(String type) {
		String script = "changeSmoothnessType(" + "'" + type + "'" + ");";
		browser.execute(script);
	}
	
	@Override
	public void changeSmoothnessForceDirection(String direction) {
		String script = "changeSmoothnessForceDirection(" + "'" + direction + "'" + ");";
		browser.execute(script);
	}
	
	@Override
	public void changeSmoothnessRoundness(float value) {
		String script = "changeSmoothnessRoundness(" + value + ");";
		browser.execute(script);
	}
	
	// PHYSICS
	
	@Override
	public void enablePhysics(boolean enable) {
		String script = "enablePhysics(" + enable + ");";
	    browser.execute(script);
	}
	
	
	// BarnesHut
	@Override
	public void changeThetaBH(float theta) {
		String script = "changeThetaBH(" + theta + ");";
		browser.execute(script);
	}

	@Override
	public void changeGravitationalConstantBH(int value) {
		String script = "changeGravitationalConstantBH(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeCentralGravityBH(float value) {
		String script = "changeCentralGravityBH(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeSpringLengthBH(int value) {
		String script = "changeSpringLengthBH(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeSpringConstantBH(float value) {
		String script = "changeSpringConstantBH(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeDampingBH(float value) {
		String script = "changeDampingBH(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeAvoidOverlapBH(float value) {
		String script = "changeAvoidOverlapBH(" + value + ");";
		browser.execute(script);
	}
	
	
	// ForceAtlas2Based
	@Override
	public void changeThetaFA(float theta) {
		String script = "changeThetaFA(" + theta + ");";
		browser.execute(script);
	}

	@Override
	public void changeGravitationalConstantFA(int value) {
		String script = "changeGravitationalConstantFA(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeCentralGravityFA(float value) {
		String script = "changeCentralGravityFA(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeSpringLengthFA(int value) {
		String script = "changeSpringLengthFA(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeSpringConstantFA(float value) {
		String script = "changeSpringConstantFA(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeDampingFA(float value) {
		String script = "changeDampingBH(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeAvoidOverlapFA(float value) {
		String script = "changeAvoidOverlapFA(" + value + ");";
		browser.execute(script);
	}
	
	
	// Repulsion
	@Override
	public void changeCentralGravityRep(float value) {
		String script = "changeCentralGravityRep(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeSpringLengthRep(int value) {
		String script = "changeSpringLengthRep(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeSpringConstantRep(float value) {
		String script = "changeSpringConstantRep(" + value + ");";
		browser.execute(script);
	}
	
	@Override
	public void changeNodeDistanceRep(int value) {
		String script = "changeNodeDistanceRep(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeDampingRep(float value) {
		String script = "changeDampingRep(" + value + ");";
		browser.execute(script);
	}
	
	
	// Hierarchical repulsion
	@Override
	public void changeCentralGravityHrep(float value) {
		String script = "changeCentralGravityHrep(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeSpringLengthHrep(int value) {
		String script = "changeSpringLengthHrep(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeSpringConstantHrep(float value) {
		String script = "changeSpringConstantHrep(" + value + ");";
		browser.execute(script);
	}
	
	@Override
	public void changeNodeDistanceHrep(int value) {
		String script = "changeNodeDistanceHrep(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeDampingHrep(float value) {
		String script = "changeDampingHrep(" + value + ");";
		browser.execute(script);
	}
	
	@Override
	public void changeAvoidOverlapHrep(float value) {
		String script = "changeAvoidOverlapHrep(" + value + ");";
		browser.execute(script);
	}
	
	
	@Override
	public void changeMaxVelocity(int value) {
		String script = "changeMaxVelocity(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeMinVelocity(float value) {
		String script = "changeMinVelocity(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeSolver(String algorithm) {
		String script = "changeSolver(" + algorithm + ");";
		browser.execute(script);
	}

	@Override
	public void changeTimestep(float value) {
		String script = "changeTimestep(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeWindX(float value) {
		String script = "changeWindX(" + value + ");";
		browser.execute(script);
	}

	@Override
	public void changeWindY(float value) {
		String script = "changeWindY(" + value + ");";
		browser.execute(script);
	}




	protected void updateFixXY() {
		//		JSONObject options = new JSONObject();
		//		JSONObject nodes = new JSONObject();
		//		JSONObject fixed = new JSONObject();
		//		fixed.put("x", fixX);
		//		fixed.put("y", fixY);
		//		nodes.put("fixed", fixed);
		//		options.put("nodes", nodes);
		//		browser.execute("updateOptions(" + options.toString() + ");");
		browser.execute("updateFixXY(" + fixX + "," + fixY + ");");

	}

	protected void updateFixX() {
		browser.execute("updateFixX(" + fixX + ");");
	}

	protected void updateFixY() {
		browser.execute("updateFixY(" + fixY + ");");
	}

	protected void showNavigation(boolean selection) {
		browser.execute("toggleNavigation(" + selection + ");");

	}
	


	@Inject
	private void initGraph(@Optional NetworkModel network) {
		if (network == null) {
			System.out.println("Network is null");
			return;
		}
		this.network = network;
		//		// Initialize the network data
		//        NetworkModel network = new NetworkModel();


		// Serialize network to JSON and pass it to JavaScript
		try {
			String networkJson = getNetworkJson();
			app.getContext().set("networkJson", networkJson);
			//String networkJson = "{\"nodes\":[{\"id\":\"X1\",\"label\":\"X1\",\"group\":\"2\"},{\"id\":\"X10\",\"label\":\"X10\",\"group\":\"3\"},{\"id\":\"X11\",\"label\":\"X11\",\"group\":\"4\"},{\"id\":\"X12\",\"label\":\"X12\",\"group\":\"1\"},{\"id\":\"X13\",\"label\":\"X13\",\"group\":\"4\"},{\"id\":\"X14\",\"label\":\"X14\",\"group\":\"4\"},{\"id\":\"X15\",\"label\":\"X15\",\"group\":\"3\"},{\"id\":\"X16\",\"label\":\"X16\",\"group\":\"0\"},{\"id\":\"X17\",\"label\":\"X17\",\"group\":\"1\"},{\"id\":\"X18\",\"label\":\"X18\",\"group\":\"4\"},{\"id\":\"X19\",\"label\":\"X19\",\"group\":\"2\"},{\"id\":\"X2\",\"label\":\"X2\",\"group\":\"2\"},{\"id\":\"X20\",\"label\":\"X20\",\"group\":\"3\"},{\"id\":\"X3\",\"label\":\"X3\",\"group\":\"1\"},{\"id\":\"X4\",\"label\":\"X4\",\"group\":\"1\"},{\"id\":\"X5\",\"label\":\"X5\",\"group\":\"3\"},{\"id\":\"X6\",\"label\":\"X6\",\"group\":\"4\"},{\"id\":\"X7\",\"label\":\"X7\",\"group\":\"2\"},{\"id\":\"X8\",\"label\":\"X8\",\"group\":\"2\"},{\"id\":\"X9\",\"label\":\"X9\",\"group\":\"3\"}],\"edges\":[{\"width\":0.958379233180412,\"arrows\":\"to\",\"from\":\"X3\",\"id\":\"X3_X12\",\"to\":\"X12\",\"value\":0.958379233180412},{\"width\":0.75,\"arrows\":\"to\",\"from\":\"X1\",\"id\":\"X1_X2\",\"to\":\"X2\",\"value\":0.75},{\"width\":0.735997919051715,\"arrows\":\"to\",\"from\":\"X3\",\"id\":\"X3_X4\",\"to\":\"X4\",\"value\":0.735997919051715},{\"width\":0.734979388547679,\"arrows\":\"to\",\"from\":\"X10\",\"id\":\"X10_X20\",\"to\":\"X20\",\"value\":0.734979388547679},{\"width\":0.682911490358651,\"arrows\":\"to\",\"from\":\"X19\",\"id\":\"X19_X7\",\"to\":\"X7\",\"value\":0.682911490358651},{\"width\":0.608900236926407,\"arrows\":\"to\",\"from\":\"X5\",\"id\":\"X5_X9\",\"to\":\"X9\",\"value\":0.608900236926407},{\"width\":0.600875804078483,\"arrows\":\"to\",\"from\":\"X15\",\"id\":\"X15_X10\",\"to\":\"X10\",\"value\":0.600875804078483},{\"width\":0.552346092391992,\"arrows\":\"to\",\"from\":\"X4\",\"id\":\"X4_X17\",\"to\":\"X17\",\"value\":0.552346092391992},{\"width\":0.532126783887836,\"arrows\":\"to\",\"from\":\"X15\",\"id\":\"X15_X9\",\"to\":\"X9\",\"value\":0.532126783887836},{\"width\":0.532111588640062,\"arrows\":\"to\",\"from\":\"X5\",\"id\":\"X5_X6\",\"to\":\"X6\",\"value\":0.532111588640062},{\"width\":0.481760814800739,\"arrows\":\"to\",\"from\":\"X6\",\"id\":\"X6_X11\",\"to\":\"X11\",\"value\":0.481760814800739},{\"width\":0.479209508356994,\"arrows\":\"to\",\"from\":\"X9\",\"id\":\"X9_X10\",\"to\":\"X10\",\"value\":0.479209508356994},{\"width\":0.469377226508559,\"arrows\":\"to\",\"from\":\"X1\",\"id\":\"X1_X8\",\"to\":\"X8\",\"value\":0.469377226508559},{\"width\":0.466136013368496,\"arrows\":\"to\",\"from\":\"X18\",\"id\":\"X18_X13\",\"to\":\"X13\",\"value\":0.466136013368496},{\"width\":0.46464073919754,\"arrows\":\"to\",\"from\":\"X15\",\"id\":\"X15_X5\",\"to\":\"X5\",\"value\":0.46464073919754},{\"width\":0.458638350442299,\"arrows\":\"to\",\"from\":\"X12\",\"id\":\"X12_X20\",\"to\":\"X20\",\"value\":0.458638350442299},{\"width\":0.455602100759684,\"arrows\":\"to\",\"from\":\"X8\",\"id\":\"X8_X7\",\"to\":\"X7\",\"value\":0.455602100759684},{\"width\":0.449485619741499,\"arrows\":\"to\",\"from\":\"X11\",\"id\":\"X11_X14\",\"to\":\"X14\",\"value\":0.449485619741499},{\"width\":0.449246712524444,\"arrows\":\"to\",\"from\":\"X18\",\"id\":\"X18_X14\",\"to\":\"X14\",\"value\":0.449246712524444},{\"width\":0.448593460635793,\"arrows\":\"to\",\"from\":\"X9\",\"id\":\"X9_X18\",\"to\":\"X18\",\"value\":0.448593460635793},{\"width\":0.253055749624453,\"arrows\":\"to\",\"from\":\"X11\",\"id\":\"X11_X8\",\"to\":\"X8\",\"value\":0.253055749624453}],\"options\":{\"nodes\":{\"fixed\":{\"x\":false,\"y\":false}},\"physics\":{\"enabled\":true},\"edges\":{\"smooth\":false},\"interaction\":{\"hideEdgesOnDrag\":true}}}\r\n";
			System.out.println("\n" + networkJson);
			uiSync.asyncExec(() -> {
				browser.execute("initializeNetwork(" + networkJson + ");");
			});

		} catch (Exception e) {
			e.printStackTrace();
		}

	}




	private String getNetworkJson() {
		if (network == null) 
			return "";

		JSONObject data = this.network.getJsonData();


		// add init values for layout and physics 
		//		const options = {
		//				  "nodes": {
		//				    "fixed": {
		//				      "x": true		
		//	      "y": true				

		//				    },
		//				    "size": null
		//				  },
		//				  "edges": {
		//				    "smooth": {
		//				      "forceDirection": "none"
		//				    }
		//				  },
		//				  "interaction": {
		//				    "hideEdgesOnDrag": true
		//				  },
		//				  "physics": {
		//				    "enabled": false,
		//				    "minVelocity": 0.75
		//				  }
		//				}
		JSONObject options = new JSONObject();
		JSONObject nodes = new JSONObject();
		JSONObject fixed = new JSONObject();
		fixed.put("x", fixX);
		fixed.put("y", fixY);
		nodes.put("fixed", fixed);
		options.put("nodes", nodes);
		JSONObject edges = new JSONObject();

		if (smoothCurves) {
			JSONObject smooth = new JSONObject();
			smooth.put("type", "dynamic");
			edges.put("smooth", smooth);
		}
		else {
			edges.put("smooth", false);
		}



		options.put("edges", edges);
		JSONObject interaction = new JSONObject();
		interaction.put("hideEdgesOnDrag", hideEdgesOnDrag);
		options.put("interaction", interaction);

		JSONObject physics = new JSONObject();
		physics.put("enabled", usePhysics);
		//physics.put("minVelocity", 0.75);
		options.put("physics", physics);
		data.put("options", options);

		return data.toString();
	}


	private void tooglePhysics(boolean selection) {
		browser.execute("togglePhysics(" + selection + ");");

	}



	IProgressMonitor currentMonitor = null;
	private void addBrowserFunction() {
		// Register BrowserFunction for each event
		new BrowserFunction(browser, "onClick") {
			@Override
			public Object function(Object[] arguments) {
				logger.debug("Click event received in Java with arguments: " + arguments[0]);
				// System.out.println("Click event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onDoubleClick") {
			@Override
			public Object function(Object[] arguments) {
				// System.out.println("Double click event received in Java with arguments: " + arguments[0]);
				logger.debug("Double click event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onContext") {
			@Override
			public Object function(Object[] arguments) {
				// System.out.println("Right-click (context) event received in Java with arguments: " + arguments[0]);
				logger.debug("Right-click (context) event received in Java with arguments: " + arguments[0]);
				return null;
			}
		}; 

		new BrowserFunction(browser, "onHold") {
			@Override
			public Object function(Object[] arguments) {
				// System.out.println("Hold event received in Java with arguments: " + arguments[0]);
				logger.debug("Hold event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onRelease") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Release event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onSelectNode") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Node selected with arguments: " + arguments[0]);
				logger.debug("Node selected with arguments: " + arguments[0]);
				
				//selectionManager.clearSelectionNodes();
				
				// cast to string[]
				Object[] nodes = (Object[]) arguments[0];
				Set<Node> nodesSelected = new HashSet<>();
				for (Object nodeId : nodes) {
					Node node = network.getNodeById((String)nodeId);
					nodesSelected.add(node);
				}
				
				// update a selection manager
				uiSync.asyncExec(new Runnable() {
					
					@Override
					public void run() {
						// TODO Auto-generated method stub
						try {
							Thread.sleep(600);
							selectionManager.setSelectedNodes(nodesSelected);
							System.out.println("Finished selectionManager.setSelectedNodes");
						} catch (InterruptedException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
						
					}
				});
				System.out.println("Finished onSelectNode function");

				return null;
			}
		};

		new BrowserFunction(browser, "onSelectEdge") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Edge selected with arguments: " + arguments[0]);
				logger.debug("Edge selected with arguments: " + arguments[0]);
				
				// selectionManager.clearSelectionEdges();
				
				// cast to string[]
				Object[] edges = (Object[]) arguments[0];
				Set<Edge> edgesSelected = new HashSet<>();
				for (Object edgeId : edges) {
					Edge edge = network.getEdgeById((String)edgeId);
					edgesSelected.add(edge);
				}
				
				// update a selection manager
				uiSync.asyncExec(new Runnable() {
					
					@Override
					public void run() {
						// TODO Auto-generated method stub
						try {
							Thread.sleep(600);
							selectionManager.setSelectedEdges(edgesSelected);
							System.out.println("Finished selectionManager.setSelectedEdges");
						} catch (InterruptedException e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
						
					}
				});
				System.out.println("Finished onSelectEdge function");

				return null;
			}
		};

		new BrowserFunction(browser, "onDeselectNode") {
			@Override
			public Object function(Object[] arguments) {
				// System.out.println("Node deselected with arguments: " + arguments[0]);
				logger.debug("Node deselected with arguments: " + arguments[0]);
				Object[] nodes = (Object[]) arguments[0];
				Set<Node> nodesSelected = new HashSet<>();
				for (Object nodeId : nodes) {
					Node node = network.getNodeById((String)nodeId);
					nodesSelected.add(node);
					// selectionManager.addSelection(node);
				}
				selectionManager.setSelectedNodes(nodesSelected);
				return null;
			}
		};

		new BrowserFunction(browser, "onDeselectEdge") {
			@Override
			public Object function(Object[] arguments) {
				// System.out.println("Edge deselected with arguments: " + arguments[0]);
				logger.debug("Edge deselected with arguments: " + arguments[0]);
				Object[] edges = (Object[]) arguments[0];
				Set<Edge> edgesSelected = new HashSet<>();
				for (Object edgeId : edges) {
					Edge edge = network.getEdgeById((String)edgeId);
					edgesSelected.add(edge);
					// selectionManager.addSelection(node);
				}
				selectionManager.setSelectedEdges(edgesSelected);
				return null;
			}
		};

		new BrowserFunction(browser, "onDragStart") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Drag start event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onDragging") {
			@Override
			public Object function(Object[] arguments) {
				// System.out.println("Dragging event received in Java with arguments: " + arguments[0]);
				logger.debug("Dragging event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onDragEnd") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Drag end event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onHoverNode") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Hover node event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onBlurNode") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Blur node event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onHoverEdge") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Hover edge event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onBlurEdge") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Blur edge event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onZoom") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Zoom event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onShowPopup") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Show popup event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onHidePopup") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Hide popup event received in Java");
				return null;
			}
		};

		new BrowserFunction(browser, "onStabilizationStart") {
			@Override
			public Object function(Object[] arguments) {
				//System.out.println("Stabilization start event received in Java");
				logger.debug("Stabilization start event received in Java");
				currentMonitor = manager.getProgressMonitor();
				currentMonitor.beginTask("Updating", IProgressMonitor.UNKNOWN);
				return null;
			}
		};

		new BrowserFunction(browser, "onStabilizationIterationsDone") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println(
						"Stabilization iterations done event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onStabilized") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Stabilized event received in Java with arguments: " + arguments[0]);
				if (arguments.length > 0 && arguments[0] instanceof String) {
					String jsonString = (String) arguments[0];
					JSONObject jsonObject = new JSONObject(jsonString);
					JSONArray nodePositions = jsonObject.getJSONArray("nodePositions");

					// Start the update in a background thread

					new Thread(new Runnable() {
						@Override
						public void run() {
							// Update node positions in the network
							synchronized (network) {
								for (int i = 0; i < nodePositions.length(); i++) {
									JSONObject nodePosition = nodePositions.getJSONObject(i);
									String nodeId = nodePosition.getString("id");
									double x = nodePosition.getDouble("x");
									double y = nodePosition.getDouble("y");

									Node node = network.getNodeById(nodeId);
									if (node != null) {
										node.setX(x);
										node.setY(y);
										isDirty = true;
									}
								}

								// Notify that the update is done
								network.saveNetwork(currentMonitor);
								if (currentMonitor != null) {
									currentMonitor.done();
								}
							}
						}
					}).start();
				}

				return null;
			}
		};

		new BrowserFunction(browser, "onResize") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Resize event received in Java with arguments: " + arguments[0]);
				return null;
			}
		};

		new BrowserFunction(browser, "onInitRedraw") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Init redraw event received in Java");
				return null;
			}
		};

		new BrowserFunction(browser, "onBeforeDrawing") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("Before drawing event received in Java");
				return null;
			}
		};

		new BrowserFunction(browser, "onAfterDrawing") {
			@Override
			public Object function(Object[] arguments) {
				System.out.println("After drawing event received in Java");
				return null;
			}
		};
		
		new BrowserFunction(browser, "savePngToJava") {
			@Override public Object function(Object[] args) {
				if (args.length == 0 || !(args[0] instanceof String)) {
		            return null;
		        }
				
				String dataUrl = (String) args[0];
				String base64 = dataUrl.substring(dataUrl.indexOf(',') + 1);
				byte[] bytes = Base64.getDecoder().decode(base64);
				
				FileDialog dialog = 
						new FileDialog(browser.getShell(), SWT.SAVE);
				dialog.setText("Save network as a png image");
				dialog.setFileName("high_quality_network.png");
				dialog.setFilterExtensions(new String[] { "*.png", "*.*" });
				dialog.setFilterNames(new String[] { "PNG Image (*.png)", "All Files (*.*)" });
				
				try {
					dialog.setOverwrite(true);
				} catch (NoSuchMethodError ignore) {
					
				}
				
				String selectedPath = dialog.open();
				if (selectedPath == null) return null;
				
				if (!selectedPath.toLowerCase(java.util.Locale.ROOT).endsWith(".png")) {
		            selectedPath += ".png";
		        }
				
				Path out =Paths.get(selectedPath);
				
				try {
					Path parent = out.getParent();
					if (parent != null) Files.createDirectories(parent);
					
					Files.write(out, bytes);
					System.out.println("PNG file saved in: " + out);
					
					return out.toAbsolutePath().toString();
					
				} catch (IOException e) {
					e.printStackTrace();
					return null;
				}

			}
		};
		
		new BrowserFunction(browser, "saveHtmlToJava") {
			@Override public Object function(Object[] args) {
				if (args.length == 0 || !(args[0] instanceof String)) {
					return null;
				}
				
				String html = (String) args[0];
				
				FileDialog dialog = new FileDialog(browser.getShell(), SWT.SAVE);
				dialog.setText("Save network as an HTML file");
				dialog.setFileName("network_export.html");
				dialog.setFilterExtensions(new String[] { "*.html;*.htm", "*.*" });
		        dialog.setFilterNames(new String[] { "HTML (*.html; *.htm)", "All Files (*.*)" });
		        try { dialog.setOverwrite(true); } catch (NoSuchMethodError ignore) {}
		        
		        String path = dialog.open();
		        if (path == null) return false;
		        if (!path.toLowerCase(java.util.Locale.ROOT).matches(".*\\.(html|htm)$")) {
		            path += ".html";
		        }
		        
		        Path out = Paths.get(path);
		        try {
		        	Path parent = out.getParent();
					if (parent != null) Files.createDirectories(parent);
					Files.write(out, html.getBytes());
					System.out.println("HTML saved in: " + out.toAbsolutePath());
		        	
		        } catch (IOException e) {
					e.printStackTrace();
				}
		        return null;
			}
		};
	}

	public void setFocus() {
		browser.setFocus();
	}


	/**
	 * Default height for workbench trim.
	 */
	public static final int TRIM_DEFAULT_HEIGHT;
	static {
		Shell s = new Shell(Display.getCurrent(), SWT.NONE);
		s.setLayout(new GridLayout());
		ToolBar t = new ToolBar(s, SWT.NONE);
		t.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		ToolItem ti = new ToolItem(t, SWT.PUSH);
		ti.setImage(JFaceResources.getImageRegistry().get(Dialog.DLG_IMG_MESSAGE_INFO));
		s.layout();
		int toolItemHeight = t.computeSize(SWT.DEFAULT, SWT.DEFAULT).y;
		GC gc = new GC(s);
		Point fontSize = gc.textExtent("Wg"); //$NON-NLS-1$
		gc.dispose();
		TRIM_DEFAULT_HEIGHT = Math.max(toolItemHeight, fontSize.y);
		s.dispose();

	}
	@Override
	public void saveNetwork() {
		if (network == null) {
			logger.error("NetworkView : No Network  to save");
			return;
		}
		currentMonitor = manager.getProgressMonitor();
		currentMonitor.beginTask("Saving", IProgressMonitor.UNKNOWN);
		new Thread(new Runnable() {
			@Override
			public void run() {
				// Update node positions in the network
				synchronized (network) {
					// Notify that the update is done
					network.saveNetwork(currentMonitor);
					isDirty = false;
					if (currentMonitor != null) {
						currentMonitor.done();
					}
				}
			}
		}).start();

	}


	@Override
	public void setNodeSelection(String nodeId) {
		String script = "selectNode('" + nodeId + "');";
		browser.execute(script);
		
		Set<Node> nodes = new HashSet<Node>();
		nodes.add(network.getNodeById(nodeId));
		selectionManager.setSelectedNodes(nodes);
	}
	
	@Override
	public void setNodeSelection(Set<String> nodeIds) {
		StringBuilder nodesProcessed = processNodesTable (nodeIds);
		String script = "selectNodes(" + nodesProcessed + ");";
		browser.execute(script);
		
		Set<Node> nodes = new HashSet<Node>();
		for(String nodeId : nodeIds ) {
			nodes.add(network.getNodeById(nodeId));
		}
		selectionManager.setSelectedNodes(nodes);
	}
	
	public StringBuilder processNodesTable(Set<String> nodes) {
		StringBuilder nodeIds = new StringBuilder("[");
	    for (String node : nodes) {
	        if (node != null) {
	            nodeIds.append("'").append(node).append("',");
	        }
	    }

	    if (!nodes.isEmpty() && nodeIds.length() > 1) {
	        nodeIds.setLength(nodeIds.length() - 1);
	    }
	    nodeIds.append("]");
	    
	    return nodeIds;
	}
	
	
	@Override
	public void setEdgeSelection(String edgeId) {
		String script = "selectEdge('" + edgeId + "');";
		browser.execute(script);
		
		Set<Edge> edges = new HashSet<Edge>();
		edges.add(network.getEdgeById(edgeId));
		selectionManager.setSelectedEdges(edges);
	}
	
	@Override
	public void setEdgeSelection(Set<String> edgeIds) {
		StringBuilder edgesProcessed = processEdgesTable (edgeIds);
		String script = "selectEdges(" + edgesProcessed + ");";
		browser.execute(script);
		
		Set<Edge> edges = new HashSet<Edge>();
		for(String edgeId : edgeIds ) {
			edges.add(network.getEdgeById(edgeId));
		}
		selectionManager.setSelectedEdges(edges);
	}
	
	public StringBuilder processEdgesTable(Set<String> edges) {
		StringBuilder edgeIds = new StringBuilder("[");
	    for (String edge : edges) {
	        if (edge != null) {
	            edgeIds.append("'").append(edge).append("',");
	        }
	    }

	    if (!edges.isEmpty() && edgeIds.length() > 1) {
	        edgeIds.setLength(edgeIds.length() - 1);
	    }
	    edgeIds.append("]");
	    
	    return edgeIds;
	}

	
	// EXPORTERS
	@Override
	public void exportPNG() {
		System.out.println("Export as PNG Function executed");
		browser.execute("exportNetworkToHighQualityPNG();");
	}
	
	public void exportHTML() {
		System.out.println("Export as HTML Function executed");
		browser.execute("exportNetworkToHTML();");
	}
	
	
	// OBTAIN NODE ATTRIBUTES FROM NETWORK
	
	protected String getNodeAtt(String nodeId, String attName) {
	    String safeNodeId = nodeId.replace("\"", "\\\"");

	    String jsCode = String.format(
	        "return network.body.nodes[\"%s\"].%s;",
	        safeNodeId,
	        attName
	    );

	    Object retVal = browser.evaluate(jsCode);
	    System.out.println("getNodeAtt(" + nodeId + ", " + attName + ") → " + retVal);
	    return retVal != null ? retVal.toString() : null;
	}
	
	
	public String getVisNodeColor(INode node) {
		
		return getNodeAtt(node.getId(),"options.color.background");
	}
	
	public String getVisNodeColorBorder(INode node) {
		
		return getNodeAtt(node.getId(),"options.color.border");
	}

	public String getVisNodeColorHighlight(INode node) {
		
		return getNodeAtt(node.getId(),"options.color.highlight.background");
	}
	
	public String getVisNodeColorHighlightBorder(INode node) {
			
		return getNodeAtt(node.getId(),"options.color.highlight.border");
	}

	public String getVisNodeColorHover(INode node) {
		
		return getNodeAtt(node.getId(),"options.color.hover.background");
	}

	public String getVisNodeColorHoverBorder(INode node) {
		
		return getNodeAtt(node.getId(),"options.color.hover.border");
	}
	
	
	// OBTAIN EDGE ATTRIBUTES FROM NETWORK
	
	protected String getEdgeAtt(String edgeId, String attName) {
	    String safeEdgeId = edgeId.replace("\"", "\\\"");

	    String jsCode = String.format(
	        "return network.body.edges[\"%s\"].%s;",
	        safeEdgeId,
	        attName
	    );

	    Object retVal = browser.evaluate(jsCode);
	    System.out.println("getEdgeAtt(" + edgeId + ", " + attName + ") → " + retVal);
	    return retVal != null ? retVal.toString() : null;
	}

	
	public String getVisEdgeColor(IEdge edge) {
		
		return getEdgeAtt(edge.getId(),"options.color.color");
	}

	public String getVisEdgeColorHighlight(IEdge edge) {
		
		return getEdgeAtt(edge.getId(),"options.color.highlight");
	}

	public String getVisEdgeColorHover(IEdge edge) {
		
		return getEdgeAtt(edge.getId(),"options.color.hover");
	}

	
}