package com.biotechvana.netools.internal;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UIEventTopic;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.biotechvana.commons.SharedImages;
import com.biotechvana.netools.IVariablesView;
import com.biotechvana.netools.projects.Dataset;
import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.NetworkDesign;
import com.biotechvana.netools.projects.Project;
import com.biotechvana.netools.projects.ProjectEvents;
import com.biotechvana.netools.projects.Variable;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;

public class DesignerView implements IVariablesView {
	public static final Logger logger = LoggerFactory.getLogger(DesignerView.class);
	FormToolkit toolkit;
	Form detailsForm;
	Composite mainBody;

	
	Dataset selected_dataset;
	Project activeProject;
	NetworkDesign activeDesign;
	NetworkDesign selectedDesign;
	IProjectsManager projectsManager;

	@Inject
	IProgressService progressService;


	@Inject
	UISynchronize sync;


	List<Variable> variables = new ArrayList<Variable>();
	Composite mainComposite;
	Composite mainCompositeBody;
	
	@Inject
	MApplication app;

	@Inject
	@Optional 
	public void setActiveProject(@Named(IProjectsManager.ACTIVE_PROJECT) Project project) {
		activeProject = project;
	
		
		selected_dataset = null;
		activeDesign = null;
		sync.asyncExec(
				() -> updateUI()
			);
	}
	@Inject
	@Optional
	public void setActiveDesign(@Named(IProjectsManager.ACTIVE_DESIGN) NetworkDesign design) {
		activeDesign = design;
		sync.asyncExec(() -> updateUI());
	}

//	@Inject
//	@Optional
//	public void setSelectedDataset(@Named(IProjectsManager.SELECTED_DATASET) NetworkDesign activeDesign) {
//		this.activeDesign = activeDesign;
//		sync.asyncExec(
//				() -> updateUI()
//			);
//		
//	}
//	
//	@Inject
//	@Optional
//	public void setSelectedDataset(@Named(IProjectsManager.ACTIVE_DESIGN) Dataset dataset) {
//		activeProject = dataset.getProject();
//		selected_dataset = dataset;
//		sync.asyncExec(
//				() -> updateUI()
//			);
//		
//	}
	
	@Inject
	void subscribeNewDesign(@Optional @UIEventTopic(ProjectEvents.NETWORK_DESIGN_ADDED) NetworkDesign design) {
		 updateUI();
	}
	@Inject
	void subscribeDesignUpdated(@Optional @UIEventTopic(ProjectEvents.NETWORK_DESIGN_UPDATED) NetworkDesign design) {
		 updateUI();
	}
	@Inject
	void subscribeDesignDeleted(@Optional @UIEventTopic(ProjectEvents.NETWORK_DESIGN_DELETED) NetworkDesign design) {
		 updateUI();
	}


	/**
	 * Update GUI in must be called in the display thread
	 */
	private void updateUI() {
		if (detailsForm == null || detailsForm.isDisposed()) {
			return;
		}
		logger.debug("Updating UI for the View");
		if (activeProject == null) {
			detailsForm.setText("Network Designer");
			return;
		}
		detailsForm.setText("Network Designer - " + activeProject.getProjectName());
		if (activeDesign!=null) {
            mainSection.setText("Manage White and Black Lists for newtwork design - " + activeDesign.getDesignName());
		}
        else {
        	mainSection.setText("Manage White and Black Lists for newtwork design");
        }
		designTableViewer.setInput(activeProject.getNetworkDesigns());


	}

	TableViewer designTableViewer;
	private void renderMainSection() {
		if (mainCompositeBody != null && !mainCompositeBody.isDisposed()) {
			mainCompositeBody.dispose();
		}


		mainCompositeBody = toolkit.createComposite(mainComposite);
		mainCompositeBody.setLayout(new GridLayout(1, true));
		mainCompositeBody.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));
		
		
		designTableViewer = new TableViewer(mainCompositeBody,  SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.BORDER);
		designTableViewer.getTable().setLayoutData(new GridData(SWT.BEGINNING, SWT.FILL, false, true));
		designTableViewer.getTable().setHeaderVisible(true);
		designTableViewer.getTable().setLinesVisible(true);
		
		// Create columns
		// Name column
		TableViewerColumn nameColumn = new TableViewerColumn(designTableViewer, SWT.NONE);
		nameColumn.getColumn().setText("Name");
		nameColumn.getColumn().setWidth(200);
		nameColumn.setLabelProvider(new ColumnLabelProvider() {
			@Override
			public String getText(Object element) {
				NetworkDesign design = (NetworkDesign) element;
				return design.getDesignName();
			}
		});
		
		// Description column
		TableViewerColumn descriptionColumn = new TableViewerColumn(designTableViewer, SWT.NONE);
		descriptionColumn.getColumn().setText("Description");
		descriptionColumn.getColumn().setWidth(350);
		descriptionColumn.setLabelProvider(new ColumnLabelProvider() {
			@Override
			public String getText(Object element) {
				NetworkDesign design = (NetworkDesign) element;
				return design.getDescription();
			}
		});
		
		// Active column
		TableViewerColumn activeColumn = new TableViewerColumn(designTableViewer, SWT.NONE);
		activeColumn.getColumn().setText("Active");
		activeColumn.getColumn().setWidth(100);
		activeColumn.setLabelProvider(new ColumnLabelProvider() {
			@Override
			public String getText(Object element) {
				NetworkDesign design = (NetworkDesign) element;
				return design == activeDesign ? "Yes" : "No";
			}
			@Override
			public Image getImage(Object element) {
				NetworkDesign design = (NetworkDesign) element;
				return design == activeDesign ? SharedImages.ACCEPT : null;
			}
		});
		
		 designTableViewer.setContentProvider(new ArrayContentProvider());
		if (activeProject != null) {
				designTableViewer.setInput(activeProject.getNetworkDesigns());
		}
		
		// Add selection listener
		designTableViewer.addSelectionChangedListener(event -> {
			if (event.getSelection().isEmpty()) {
				selectedDesign = null;
			} else {
				selectedDesign = (NetworkDesign) designTableViewer.getStructuredSelection().getFirstElement();
				// app.getContext().set(IProjectsManager.SELECTED_DESIGN, selectedDesign);
				activeProject.getProjectManager().setSelectedDesgin(selectedDesign);
			}
			sync.asyncExec(() -> updateUI());
		});
	}

	



//	Section descSection ;
	Section mainSection;
	@PostConstruct
	public void createPartControl(Composite parent, MApplication app, IProjectsManager projectsManager) { 
		app.getContext().set(IVariablesView.class, this);
		this.projectsManager = projectsManager;
		toolkit = new FormToolkit(parent.getDisplay());

		

		detailsForm = toolkit.createForm(parent);
		detailsForm.setText("Title");
		detailsForm.getBody().setLayout( new FillLayout());
		toolkit.decorateFormHeading(detailsForm);
		
	

		mainBody =  toolkit.createComposite(detailsForm.getBody());
		mainBody.setLayout(new GridLayout(1, false));
		// ##################################################################################
		// createMainBody(mainBody);
		
		
		
		detailsForm.setText("Network Designer");
		
		
		// Create filter section
//		descSection = toolkit.createSection(mainBody, Section.TITLE_BAR);
//		descSection.setText("Manage White and Black Lists for newtwork design");
//		descSection.setLayoutData(new GridData(SWT.FILL, SWT.TOP, true, false));
//
//		Composite descComposite = toolkit.createComposite(descSection);
//		descComposite.setLayout(new GridLayout(3, false));
//
//		createDescSection(descComposite);
//
//		descSection.setClient(descComposite);

		// Create variables section
		mainSection = toolkit.createSection(mainBody, Section.TITLE_BAR);
		mainSection.setText("Manage White and Black Lists for newtwork design");
		mainSection.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true));

		mainComposite = toolkit.createComposite(mainSection);
		mainComposite.setLayout(new GridLayout(1, false));
		renderMainSection();
		mainSection.setClient(mainComposite);
		// ##################################################################################


	}

	private void createDescSection(Composite descComposite) {
		
		

		
		
	}


}
