package com.biotechvana.netools.internal;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.progress.IProgressService;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.biotechvana.netools.projects.Dataset;
import com.biotechvana.netools.projects.IProjectsManager;
import com.biotechvana.netools.projects.Project;
import com.biotechvana.netools.projects.Variable;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import jakarta.inject.Named;

public class BaseView  {
	public static final Logger logger = LoggerFactory.getLogger(BaseView.class);
	FormToolkit toolkit;
	Form detailsForm;
	Composite mainBody;
	ScrolledComposite jobScrolledComposite;

	Dataset selected_dataset;
	Project activeProject;
	IProjectsManager projectsManager;

	@Inject
	IProgressService progressService;


	@Inject
	UISynchronize sync;


	public void createFormControl(Composite parent) { 
		
		toolkit = new FormToolkit(parent.getDisplay());

		detailsForm = toolkit.createForm(parent);
		detailsForm.setText("Title");
		detailsForm.getBody().setLayout( new FillLayout());
		toolkit.decorateFormHeading(detailsForm);
		
		jobScrolledComposite = new ScrolledComposite( detailsForm.getBody(),  SWT.H_SCROLL | SWT.V_SCROLL);
		jobScrolledComposite.setExpandVertical(true);
		jobScrolledComposite.setExpandHorizontal(true);
		jobScrolledComposite.setAlwaysShowScrollBars(true);

		mainBody =  toolkit.createComposite(jobScrolledComposite);
		mainBody.setLayout(new GridLayout(1, false));
		// ##################################################################################
		// createMainBody(mainBody);
		// ##################################################################################

		jobScrolledComposite.setMinSize(mainBody.computeSize(SWT.DEFAULT, SWT.DEFAULT));
	    jobScrolledComposite.setContent(mainBody);
	    jobScrolledComposite.setExpandVertical(true);
	    jobScrolledComposite.setExpandHorizontal(true);
	    jobScrolledComposite.setAlwaysShowScrollBars(true);
	
	}

	


}
