package com.biotechvana.netools;

import java.util.Set;

import com.biotechvana.netools.models.Edge;
import com.biotechvana.netools.models.Node;

public interface ISelectionManager {
	 void addSelectionListener(ISelectionListener listener);
	 void removeSelectionListener(ISelectionListener listener);
	
	 /**
	  * add a set of nodes to the current selection
	  * @param nodesSelected new selected node set to add
	  */
	void addSelectionNodes(Set<Node> nodesSelected);
	
	/**
	 * set the selected nodes, clear previous selection
	 * @param nodesSelected
	 */
	void setSelectedNodes(Set<Node> nodesSelected);
	
	void addSelectionNodes(Node node);
	
	/**
	 * add a set of edges to the current selection
	 * @param edgesSelected new selected edge set to add
	 */
	void addSelectionEdges(Set<Edge> edgesSelected);
	
	/**
	 * set the selected edges, clear previous selection
	 * @param edgesSelected
	 */
	void setSelectedEdges(Set<Edge> edgesSelected);
	
	void addSelectionEdges(Edge edge);
	void clearSelectionNodes();
	void clearSelectionEdges();
}
