package com.biotechvana.netools;

import java.util.List;
import java.util.Set;

import org.eclipse.swt.graphics.RGB;

import com.biotechvana.netools.models.Edge;
import com.biotechvana.netools.models.IEdge;
import com.biotechvana.netools.models.INode;
import com.biotechvana.netools.models.Node;

public interface INetworkView {

	void saveNetwork();
	
	// NODE FUNCTIONALITIES
	void changeNodeColor(Set<Node> selectedNodes, String color);
	void changeNodeColorBorder(Set<Node> selectedNodes, String color);
	void changeNodeColorHighlight(Set<Node> selectedNodes, String color);
	void changeNodeColorHighlightBorder(Set<Node> selectedNodes, String color);
	void changeNodeColorHover(Set<Node> selectedNodes, String color);
	void changeNodeColorHoverBorder(Set<Node> selectedNodes, String color);
	void changeNodeBorderWidth(Set<Node> selectedNodes, int width);
	void changeNodeBorderWidthSelected(Set<Node> selectedNodes, int width);
	void changeNodeOpacity(Set<Node> selectedNodes, float opacity);
	void changeNodeShape(Set<Node> selectedNodes, String shape);
	void changeNodeSize(Set<Node> selectedNodes, int size);
	
	// EDGE FUNCTIONALITIES
	void changeEdgeColor(Set<Edge> selectedEdges, String color);
	void changeEdgeColorHighlight(Set<Edge> selectedEdges, String color);
	void changeEdgeColorHover(Set<Edge> selectedEdges, String color);
	void changeEdgeColorOpacity(Set<Edge> selectedEdges, float opacity);
	void changeEdgeWidth(Set<Edge> selectedEdges, double width);
	//void changeEdgeLabelFont(Set<Edge> selectedEdges, String fontProperties);
	void showDashes(boolean show);
	void showEdgeLabels(boolean show);
	void hideEdges(boolean hide);
	
	// NETWORK LAYOUT
	void enableSmoothness(boolean enable);
	void changeSmoothnessType(String type);
	void changeSmoothnessForceDirection(String direction);
	void changeSmoothnessRoundness(float value);
	void enablePhysics(boolean enable);
	
	// Barnes Hut
	void changeThetaBH(float value);
	void changeGravitationalConstantBH(int value);
	void changeCentralGravityBH(float value);
	void changeSpringLengthBH(int value);
	void changeSpringConstantBH(float value);
	void changeDampingBH(float value);
	void changeAvoidOverlapBH(float value);
	
	// ForceAtlas2Based
	void changeThetaFA(float value);
	void changeGravitationalConstantFA(int value);
	void changeCentralGravityFA(float value);
	void changeSpringLengthFA(int value);
	void changeSpringConstantFA(float value);
	void changeDampingFA(float value);
	void changeAvoidOverlapFA(float value);
	
	// Repulsion
	void changeCentralGravityRep(float value);
	void changeSpringLengthRep(int value);
	void changeSpringConstantRep(float value);
	void changeNodeDistanceRep(int value);
	void changeDampingRep(float value);
	
	// Hierarchical repulsion
	void changeCentralGravityHrep(float value);
	void changeSpringLengthHrep(int value);
	void changeSpringConstantHrep(float value);
	void changeNodeDistanceHrep(int value);
	void changeDampingHrep(float value);
	void changeAvoidOverlapHrep(float value);
	
	void changeMaxVelocity(int value);
	void changeMinVelocity(float value);
	void changeSolver(String algorithm);
	void changeTimestep(float value);
	void changeWindX(float value);
	void changeWindY(float value);

	void setNodeSelection(String nodeId);
	void setNodeSelection(Set<String> selectedNodes);

	void setEdgeSelection(String edgeId);
	void setEdgeSelection(Set<String> selectedEdges);

	void exportPNG();
	
	void exportHTML();

	String getVisNodeColor(INode node);

	String getVisNodeColorBorder(INode node);

	String getVisNodeColorHighlight(INode node);

	String getVisNodeColorHighlightBorder(INode node);

	String getVisNodeColorHover(INode node);

	String getVisNodeColorHoverBorder(INode node);
	
	
	String getVisEdgeColor(IEdge edge);

	String getVisEdgeColorHighlight(IEdge edge);

	String getVisEdgeColorHover(IEdge edge);

	
}
