/*
 * @author		Alfonso Muñoz-Pomer Fuentes, 
 * 				<a href="mailto:alfonso.munozpomer@biotechvana.com">
 * 				alfonso.munozpomer@biotechvana.com</a>,  
 * 				<a href="http://www.biotechvana.com">Biotechvana</a>
 *
 * @date		2011-02-22
 * 
 * @copyright	Copyright Biotech Vana, S.L. 2006-2011 *
 */

package com.biotechvana.javabiotoolkit.text;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;

/**
 * @author	<a href="mailto:alfonso.munozpomer@biotechvana.com">Alfonso Muñoz-Pomer Fuentes</a>,
 * 			<a href="http://www.biotechvana.com">Biotechvana</a>.
 *
 * @version	0.1
 *
 */
public class NewLineFileEnder
{
	/**
	 * 
	 * @param filePath
	 * @param fileCharset
	 * @return
	 * @throws IOException 
	 */
	public static void ensureLastLineNewLine
	(File filePath, Charset fileCharset, LineSeparatorFormat fileLineSeparatorFormat)
	throws FileNotFoundException, IOException
	{
		// Get read channel and go to end
		FileChannel outFC = new RandomAccessFile(filePath, "rw").getChannel();

		try
		{
			// Get new line character bytes and buffer for last char
			int newLineBytes = fileCharset.encode(fileLineSeparatorFormat.lineSeparator()).limit();
			ByteBuffer bBuffer = ByteBuffer.allocate(newLineBytes);
			outFC.read(bBuffer, outFC.size() - newLineBytes);	// Illegal argument exception if size is 0
			bBuffer.flip();
			CharBuffer lastCharBuffer = fileCharset.decode(bBuffer);
			
			int i = 0;
			while(lastCharBuffer.hasRemaining())
			{
				char c = lastCharBuffer.get();
				if (c == fileLineSeparatorFormat.lineSeparator().charAt(i))
				{
					// So far this looks like a fine line delimiter, lad!
					i++;
					continue;
				}
				else
				{
					// It's not a file delimiter. Move position to the end of file and append.
					FileLock outLock = outFC.tryLock();
					if (outLock != null)
					{
						outFC.position(outFC.size());
						outFC.write(ByteBuffer.wrap(fileLineSeparatorFormat.lineSeparator().getBytes(fileCharset)));
						outLock.release();
					}
				}
			}
		}
		catch (IllegalArgumentException exception)
		{
			// Ignore if size is 0 
		}
		finally
		{
			outFC.close();
		}
	}
}
