/*
 * @author		Alfonso Muñoz-Pomer Fuentes, 
 * 				<a href="mailto:alfonso.munozpomer@biotechvana.com">
 * 				alfonso.munozpomer@biotechvana.com</a>,  
 * 				<a href="http://www.biotechvana.com">Biotechvana</a>
 *
 * @date		2010-09-01
 * 
 * @license		See <a href="http://www.biotechvana.com></a>
 *
 * @copyright	Copyright Biotech Vana, S.L. 2006-2010
 */

package com.biotechvana.javabiotoolkit.exceptions;

/**
 * Exception thrown if an instance of <code>GenBankReader</code> is requested to handle a sequence longer than the 
 * contemplated maximum of 2¹⁰ (java.lang.Integer.MAX_VALUE).
 * 
 * @version	1.1, 2010-12-01
 * 
 * @author	<a href="mailto:alfonso.munozpomer@biotechvana.com">Alfonso Muñoz-Pomer Fuentes</a>,
 * 			<a href="http://www.biotechvana.com">Biotechvana</a>.
 *
 */
public class GenBankOriginSequenceTooLongException 
extends Exception
{
	/**
	 * Auto-generated by Eclipse.
	 */
	private static final long serialVersionUID = -8737188886498830453L;

	/**
	 * Default constructor with no arguments.
	 * 
	 * @since	1.1
	 * 
	 * @see		<a href="http://download.oracle.com/javase/6/docs/api/java/lang/Exception.html">Exception</a>
	 */
	public GenBankOriginSequenceTooLongException()
	{
		super();
	}
	
	/**
	 * Default constructor with <code>String</code> argument.
	 * 
	 * @param	message	the detail message.
	 * 
	 * @since	1.1
	 * 
	 * @see		<a href="http://download.oracle.com/javase/6/docs/api/java/lang/Exception.html">Exception</a>
	 */
	public GenBankOriginSequenceTooLongException(String message)
	{
		super(message);
	}
}
