/*
 * @author		Alfonso Muñoz-Pomer Fuentes, 
 * 				<a href="mailto:alfonso.munozpomer@biotechvana.com">
 * 				alfonso.munozpomer@biotechvana.com</a>,  
 * 				<a href="http://www.biotechvana.com">Biotechvana</a>
 *
 * @date		2011-02-21
 * 
 * @license		See <a href="http://www.biotechvana.com></a>
 *
 * @copyright	Copyright Biotech Vana, S.L. 2006-2010
 */

package com.biotechvana.javabiotoolkit.exceptions;

/**
 * Exception thrown if the number of columns to wrap the text in a FASTA file is invalid. 
 * 
 * @version	1.1, 2011-02-21
 * 
 * @author	<a href="mailto:alfonso.munozpomer@biotechvana.com">Alfonso Muñoz-Pomer Fuentes</a>,
 * 			<a href="http://www.biotechvana.com">Biotechvana</a>.
 *
 */
public class FastaWriterIllegalWrapException 
extends Exception
{
	/**
	 * Auto-generated by Eclipse.
	 */
	private static final long serialVersionUID = 3702591636717250232L;

	/**
	 * Default constructor with no arguments.
	 * 
	 * @since	1.1
	 * 
	 * @see		<a href="http://download.oracle.com/javase/6/docs/api/java/lang/Exception.html">Exception</a>
	 */
	public FastaWriterIllegalWrapException()
	{
		super();
	}
	
	/**
	 * Default constructor with <code>String</code> argument.
	 * 
	 * @param	message	the detail message.
	 * 
	 * @since	1.1
	 * 
	 * @see		<a href="http://download.oracle.com/javase/6/docs/api/java/lang/Exception.html">Exception</a>
	 */
	public FastaWriterIllegalWrapException(String message)
	{
		super(message);
	}
}
