/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.netools.workflow.manager;

import com.biotechvana.users.UserManager;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.WorkflowStartupJob;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.JobVariable;

public class PipelineSTAToolsStarter
extends WorkflowStartupJob {
    public static final String JOB_NAME = "Experiment configuration";
    public static String JOB_ID = "STAT_Workflow_Options";
    public static final String INPUT_FASTQ_FILE = "INPUT_FILES";
    public static final String OUTPUT_FILES = "OUTPUT_FILES";
    public static final String INPUT_GROUP_LABLES = "INPUT_GROUPS";
    public static final String INPUT_LIBRARY_NAMES = "INPUT_LIBRARY";
    public static final String INPUT_REF_FASTA = "INPUT_REF_FASTA";
    public static final String INPUT_REF_INDEX = "INPUT_REF_INDEX";
    public static final String INPUT_REF_INDEX_CHOICE = "INPUT_REF_INDEX_CHOICE";
    public static final String INPUT_REF_INDEX_PREFIX = "INPUT_REF_INDEX_PREFIX";
    public static final String INPUT_REF_ANNOTATION = "INPUT_REF_ANNOTATION";
    public static final String OUTPUT_REF_INDEX = "OUTPUT_REF_INDEX";
    public static final String OUTPUT_REF_INDEX_FASTA = "OUTPUT_REF_INDEX_FASTA";
    public static final String INPUT_GROUPS_TO_COMPARE = "INPUT_GROUPS_TO_COMPARE";
    static final String sharedAuthor = "Biotechvana";
    static final String sharedRef = "http://biotechvana.com/";
    public static String TAG_All = "all";

    public PipelineSTAToolsStarter() {
        this(true);
    }

    public PipelineSTAToolsStarter(boolean forPairEnd) {
        super(JOB_ID, JOB_NAME);
        this.jobDesc.setDesc("Review and setup Configuration for a Pipelines Analysis.");
        VariableDescriptor varFastaQ = VariableDescriptor.createDescriptorFor((String)INPUT_FASTQ_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFastaQ.isRequired = true;
        varFastaQ.setVariableName("FASTQ");
        varFastaQ.addAcceptedFileFormat("FASTQ", forPairEnd, false);
        this.jobDesc.addVariable(varFastaQ);
        VariableDescriptor varInputLables = VariableDescriptor.createDescriptorFor((String)INPUT_GROUP_LABLES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varInputLables.isRequired = true;
        varInputLables.setVariableName("Groups");
        varInputLables.setHelpMsg("Specify sample Group/Condition for each input File");
        this.jobDesc.addVariable(varInputLables);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)INPUT_REF_FASTA, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        varOption.setVariableName("Reference Index Fasta file");
        varOption.setHelpMsg("");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)INPUT_REF_INDEX_PREFIX, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        varOption.setVariableName("Prefix for Reference Index");
        varOption.setHelpMsg("");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)INPUT_REF_INDEX, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Folder, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        varOption.setVariableName("Reference Index");
        varOption.setHelpMsg("");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)INPUT_GROUPS_TO_COMPARE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName(INPUT_GROUPS_TO_COMPARE);
        varOption.setHelpMsg("");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)INPUT_REF_ANNOTATION, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Annotation File in GTF Format");
        varOption.setHelpMsg("");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)INPUT_LIBRARY_NAMES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Internal);
        varOption.setVariableName("Libray names - output files");
        varOption.setHelpMsg("");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)INPUT_REF_INDEX_CHOICE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varOption.setVariableName("New Reference Index");
        varOption.setHelpMsg("");
        varOption.setGUIVisible(false);
        this.jobDesc.addVariable(varOption);
        VariableDescriptor outputRefIndex = VariableDescriptor.createDescriptorFor((String)OUTPUT_REF_INDEX, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputRefIndex.setVariableName("Ref Index");
        this.jobDesc.addVariable(outputRefIndex);
        outputRefIndex = VariableDescriptor.createDescriptorFor((String)OUTPUT_REF_INDEX_FASTA, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputRefIndex.setVariableName("Ref Index Fasta");
        this.jobDesc.addVariable(outputRefIndex);
        VariableDescriptor outputListOfAllInputFile = VariableDescriptor.createDescriptorFor((String)OUTPUT_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        outputListOfAllInputFile.setVariableName("Input Files");
        outputListOfAllInputFile.addAcceptedFileFormat("FASTQ", false, true);
        this.jobDesc.addVariable(outputListOfAllInputFile);
        VariableDescriptor outputfolderVar = WorkflowJob.createInputOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        this.initJobFromDesc(this.jobDesc);
        this.addVariableMap(OUTPUT_FILES, this.getVariable(INPUT_FASTQ_FILE));
    }

    public boolean isValid() {
        boolean valid = super.isValid();
        return valid &= this.validateEqualNumberOfFiles(INPUT_FASTQ_FILE, INPUT_GROUP_LABLES);
    }

    public void setForPE(boolean b) {
        FileListVariable varFiles = (FileListVariable)this.getVariable(INPUT_FASTQ_FILE);
        varFiles.setIsPairedFiles(b);
    }

    protected void workflowStartupJobOnGenerateCommand(StringBuilder builder) {
        builder.append(this.getVariable(OUTPUT_REF_INDEX).getBashVarName() + "=\"" + this.getVariable(INPUT_REF_INDEX).$() + "\" \n");
        builder.append(BashHelper.If((String)BashConditions.emptyStr((JobVariable)this.getVariable(INPUT_REF_FASTA))).Then(BashHelper.assign((JobVariable)this.getVariable(OUTPUT_REF_INDEX_FASTA), (String)(this.getVariable(OUTPUT_REF_INDEX).$() + ".fa"))).Else(BashHelper.assign((JobVariable)this.getVariable(OUTPUT_REF_INDEX_FASTA), (JobVariable)this.getVariable(INPUT_REF_FASTA))));
        builder.append("pipelineFolder=\"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "/00_data\" \n");
        builder.append("[ -d \"${pipelineFolder}\" ] || mkdir \"${pipelineFolder}\" \n");
        builder.append("echo \"README :\" > \"${pipelineFolder}/README\"   \n");
        UserManager.RemotePathManager hostPathManager = this.workflowManager.getUserManager().getHostPathManager();
        String userPipelineFile = hostPathManager.sanitizeFilePathWithTelda(hostPathManager.getRemoteUserSubmittedPipelinesFolder("${task_Id}.gpiw"));
        String userProjectCongif = hostPathManager.sanitizeFilePathWithTelda(hostPathManager.getRemoteUserSubmittedProjectFolder(this.getVariable("PROJECT_NAME").$() + ".config"));
        builder.append("[ -f \"" + userPipelineFile + "\" ] && cp   \"" + userPipelineFile + "\"    \"${pipelineFolder}\" \n");
        builder.append("[ -f \"" + userProjectCongif + "\" ] && cp   \"" + userProjectCongif + "\"    \"${pipelineFolder}\" \n");
        builder.append(BashHelper.Batcher_noLog((FileListVariable)((FileListVariable)this.getVariable(INPUT_FASTQ_FILE)), (String)"", (String)"[ -f ${_inputFile} ] && ln -s ${_inputFile} ${pipelineFolder}/ \n", (String)"", (boolean)true));
    }
}

