/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.ui.v2.ftpexplorer.actions;

import com.biotechvana.commons.ftpservice.IFTPManager;
import com.biotechvana.commons.ftpservice.IRemoteFile;
import com.biotechvana.ui.v2.ftpexplorer.FTPViewerComponent;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class FTPRenameAction {
    public static final String TITLE = "Rename";

    @CanExecute
    public boolean canExecute(IFTPManager ftpManager, FTPViewerComponent ftpViewer) {
        if (ftpManager.isConnected()) {
            IRemoteFile[] selection = ftpViewer.getSelectedFiles();
            return selection != null;
        }
        return false;
    }

    @Execute
    public void run(FTPViewerComponent ftpViewer) {
        IRemoteFile[] selection = ftpViewer.getSelectedFiles();
        if (selection == null) {
            return;
        }
        IRemoteFile ftpFile = selection[0];
        if (ftpFile.isParent() || ftpFile.isCWD()) {
            return;
        }
        String uri = ftpFile.getURI();
        String name = ftpFile.getName();
        InputDialog dialog = new InputDialog(ftpViewer.getShell(), TITLE, "Enter new name", name, null);
        int res = dialog.open();
        if (res == 1) {
            return;
        }
        String value = dialog.getValue();
        if (value.isEmpty()) {
            return;
        }
        value = value.replaceAll("\\s+", "_");
        value = value.replaceAll("\\(|\\)|\\[|\\|\\\\|/", "");
        if (!ftpViewer.getFtpManager().rename(uri, value)) {
            MessageDialog.openError((Shell)ftpViewer.getShell(), (String)"FTP", (String)"Failed renaming");
        }
        try {
            ftpViewer.updateFTPList();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

