/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing.fastxtools;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;

public class FastxtoolkitFastxNucleotideDistJob
extends WorkflowJob {
    private static final String TITLE = "FASTXTOOLKIT: FASTX Nucleotide Distribution";
    private static final String HELP = "FASTX Nucleotide Distribution: FASTA/Q Nucleotide Distribution Plotter";
    private static final String LINK = "Online docs: <a href=\"http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastq_nucleotide_distribution_usage\">http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastq_nucleotide_distribution_usage</a>";
    public static final String JOB_ID = "FASTX_Nucleotide_Distribution";
    public static final String JOB_NAME = "FASTXTOOLKIT: FASTX Nucleotide Distribution";
    private static final String INPUT_FASTA_FILE = "INPUT_FASTA_FILE";

    public FastxtoolkitFastxNucleotideDistJob() {
        this.jobName = "FASTXTOOLKIT: FASTX Nucleotide Distribution";
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc(HELP);
        this.jobDesc.setRef(LINK);
        VariableDescriptor varFasta = VariableDescriptor.createDescriptorFor((String)INPUT_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFasta.isRequired = true;
        varFasta.setVariableName("FASTA/FASTQ");
        this.jobDesc.addVariable(varFasta);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Title - will be plotted on the graph");
        varOption.setCommandParamater("-t");
        varOption.setHelpMsg("Title - will be plotted on the graph");
        this.jobDesc.addVariable(varOption);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        this.initJobFromDesc(this.jobDesc);
    }

    public void generateCommand(StringBuilder command) {
        String progName = Constants.PIPELINE_FASXTOOLKIT_FASTX_NUCLEOTIDE_DISTRIBUTION_EXE;
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        String forBody = "inptFileBaseName=$(basename $_File | cut -d. -f1);\ninptFileExt=`rev <<< \"$_File\" | cut -d. -f1 | rev`;\n" + progName + " -i $_File  -o $inptFileBaseName.png " + this.getOptionParamaters();
        command.append(BashHelper.forEachValue((String)"_File", (String)this.getVariable(INPUT_FASTA_FILE).$("@"), (String)forBody));
    }
}

