/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing.fastxtools;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;

public class FastxtoolkitFastxBarcodeSplitterJob
extends WorkflowJob {
    private static final String TITLE = "FASTXTOOLKIT: FASTX Barcode Splitter";
    private static final String HELP = "FASTX Barcode Splitter: reads FASTA/FASTQ file and splits it into several smaller files based on barcode matching";
    private static final String LINK = "Online docs: <a href=\"http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastx_barcode_splitter_usage\">http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fastx_barcode_splitter_usage</a>";
    public static final String JOB_ID = "FASTX_Barcode_Splitter";
    public static final String JOB_NAME = "FASTXTOOLKIT: FASTX Barcode Splitter";
    private static final String INPUT_FASTA_FILE = "FASTA_FILE";
    private static final String INPUT_BARCODE_FILE = "BARCODE_FILE";

    public FastxtoolkitFastxBarcodeSplitterJob() {
        this.jobName = "FASTXTOOLKIT: FASTX Barcode Splitter";
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc(HELP);
        this.jobDesc.setRef(LINK);
        VariableDescriptor varFasta = VariableDescriptor.createDescriptorFor((String)INPUT_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFasta.isRequired = true;
        varFasta.setVariableName("FASTA/FASTQ");
        this.jobDesc.addVariable(varFasta);
        VariableDescriptor varBarCodeFile = VariableDescriptor.createDescriptorFor((String)INPUT_BARCODE_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varBarCodeFile.isRequired = true;
        varBarCodeFile.setVariableName("BarCode File");
        this.jobDesc.addVariable(varBarCodeFile);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.String, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Output File suffix");
        varOption.setCommandParamater("--suffix");
        varOption.setHelpMsg("File suffix. Can be used to specify file extensions");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Try to match barcodes at the BEGINNING of sequences");
        varOption.setCommandParamater("--bol");
        varOption.setHelpMsg("Try to match barcodes at the BEGINNING of sequences. (What biologists would call the 5' end, and programmers would call index 0.)");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Try to match barcodes at the END of sequences");
        varOption.setCommandParamater("--eol");
        varOption.setHelpMsg("Try to match barcodes at the END of sequences. (What biologists would call the 3' end, and programmers would call the end of the string.) NOTE: one of --bol, --eol must be specified, but not both.");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Max. number of mismatches allowed");
        varOption.setCommandParamater("--mismatches");
        varOption.setHelpMsg("Max. number of mismatches allowed. default is 1");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Checked, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Exact matches");
        varOption.setCommandParamater("--exact");
        varOption.setHelpMsg("Same as '--mismatches 0'. If both --exact and --mismatches are specified, '--exact' takes precedence");
        this.jobDesc.addVariable(varOption);
        varOption = VariableDescriptor.createDescriptorFor((String)"auto", (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Allow partial overlap of barcodes");
        varOption.setCommandParamater("--partial");
        varOption.setHelpMsg("Allow partial overlap of barcodes. (Default is not partial matching)");
        this.jobDesc.addVariable(varOption);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        this.initJobFromDesc(this.jobDesc);
    }

    public void generateCommand(StringBuilder command) {
        String progName = String.valueOf(Constants.PIPELINE_FASXTOOLKIT_FASTX_BARCODE_SPLITTER_EXE) + " -Q33 ";
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        String forBody = "cat $_File | " + progName + " --bcfile " + this.getVariable(INPUT_BARCODE_FILE).$() + " -prefix" + this.getVariable("JOB_OUTPUT_FOLDER").$() + " " + this.getOptionParamaters();
        command.append(BashHelper.forEachValue((String)"_File", (String)this.getVariable(INPUT_FASTA_FILE).$("@"), (String)forBody));
    }
}

