/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing.fastxtools;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.SelectionListVariableDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;

public class FastxtoolkitFastaNucleotidesChangerJob
extends WorkflowJob {
    private static final String TITLE = "FASTXTOOLKIT: FASTA Nucleotides Changer";
    private static final String HELP = "FASTA Nucleotides Changer: Change DNA-to-RNA or RNA-to-DNA in FASTA files";
    private static final String LINK = "Online docs: <a href=\"http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fasta_nucleotide_changer_usage\">http://hannonlab.cshl.edu/fastx_toolkit/commandline.html#fasta_nucleotide_changer_usage</a>";
    public static final String JOB_ID = "FASTX_Nucleotides_Changer";
    public static final String JOB_NAME = "FASTXTOOLKIT: FASTA Nucleotides Changer";
    private static final String INPUT_FASTA_FILE = "INPUT_FASTA_FILE";

    public FastxtoolkitFastaNucleotidesChangerJob() {
        this.jobName = "FASTXTOOLKIT: FASTA Nucleotides Changer";
        this.jobDesc = new JobDescriptor(JOB_ID);
        this.jobDesc.setDesc(HELP);
        this.jobDesc.setRef(LINK);
        VariableDescriptor varFasta = VariableDescriptor.createDescriptorFor((String)INPUT_FASTA_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFasta.isRequired = true;
        varFasta.setVariableName("FASTA");
        this.jobDesc.addVariable(varFasta);
        SelectionListVariableDescriptor varOption = VariableDescriptor.SelectionList((String)"auto", (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.isRequired = true;
        varOption.setVariableName("Change Mode");
        varOption.setCommandParamater(" ");
        varOption.addOptionValue("DNA-to-RNA", "-r", "DNA-to-RNA mode - change T's into U's");
        varOption.addOptionValue("RNA-to-DNA ", "-d", "RNA-to-DNA mode - change U's into T's");
        varOption.setHelpMsg("Change Mode");
        this.jobDesc.addVariable((VariableDescriptor)varOption);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        this.initJobFromDesc(this.jobDesc);
    }

    public void generateCommand(StringBuilder command) {
        String progName = Constants.PIPELINE_FASXTOOLKIT_FASTA_NUCLEOTIDES_CHANGER_EXE;
        command.append("cd " + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\n");
        String forBody = "inptFileBaseName=$(basename $_File | cut -d. -f1);\ninptFileExt=`rev <<< \"$_File\" | cut -d. -f1 | rev`;\n" + progName + " -i $_File  -o $inptFileBaseName.$inptFileExt " + this.getOptionParamaters();
        command.append(BashHelper.forEachValue((String)"_File", (String)this.getVariable(INPUT_FASTA_FILE).$("@"), (String)forBody));
    }
}

