/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.IntVariableDescriptor;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashConditions;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.JobVariable;

public class PreProcessingFastqMidCleanerJob
extends WorkflowJob {
    public static final String JOB_ID = "FastqMidCleaner";
    public static final String JOB_NAME = "FastqMidCleaner";
    private static final String INPUT_FASTQ_FILE = "INPUT_FASTQ_FILE";
    private static final String INPUT_ADAPTERS = "INPUT_5_ADAPTERS";
    private static final String INPUT_MID_FILE = "INPUT_MID_FILE";
    private static final String JAVA_MAX_HEAP_SIZE = "JAVA_MAX_HEAP_SIZE";

    public boolean isValid() {
        boolean valid = super.isValid();
        valid &= this.validateEqualNumberOfFiles(INPUT_FASTQ_FILE, INPUT_MID_FILE, 1);
        return valid &= this.validateEqualNumberOfFiles(INPUT_FASTQ_FILE, INPUT_ADAPTERS, 1);
    }

    public PreProcessingFastqMidCleanerJob() {
        this.jobName = "FastqMidCleaner";
        this.jobDesc = new JobDescriptor("FastqMidCleaner");
        this.jobDesc.setDesc("FastqMidCleaner :  Classifies sequences in a fastq depending on the presence of MID sequences in its sequences.It generates 3 output files ; one output for sequences than have one MID in forward or reverse mode but not both, one output for sequences that contains any MID in forward and reverse mode and One output for sequences that not contains any MIDs.");
        this.jobDesc.setDesc("FastqMidCleaner splits sequencing reads of a fastq file according to a set of given MIDs");
        VariableDescriptor varFastaQ = VariableDescriptor.createDescriptorFor((String)INPUT_FASTQ_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varFastaQ.isRequired = true;
        varFastaQ.setVariableName("FASTQ Files");
        varFastaQ.setCommandParamater("-i");
        varFastaQ.setHelpMsg("Input Fastq Files");
        this.jobDesc.addVariable(varFastaQ);
        VariableDescriptor varMIDFile = VariableDescriptor.createDescriptorFor((String)INPUT_MID_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Files, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varMIDFile.isRequired = true;
        varMIDFile.setVariableName("MID Files");
        varMIDFile.setHelpMsg("MID sequences are very short sequences known as multiplex identifiers for marking sequences.");
        varMIDFile.setCommandParamater("-m");
        this.jobDesc.addVariable(varMIDFile);
        VariableDescriptor varAdapters = VariableDescriptor.createDescriptorFor((String)INPUT_ADAPTERS, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Strings, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        varAdapters.isRequired = true;
        varAdapters.setVariableName("Adapters");
        varAdapters.setCommandParamater("-a");
        this.jobDesc.addVariable(varAdapters);
        VariableDescriptor varOption = VariableDescriptor.createDescriptorFor((String)JAVA_MAX_HEAP_SIZE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        varOption.setVariableName("Maximum Java Heap Size - GB");
        varOption.setHelpMsg("Maximum Memory allocated to Java Virtual Machine of unit GB, default value is 4GB");
        varOption.setCommandParamater("-Xmx");
        varOption.setVariableGroup("Java");
        varOption.setSubProgName("Java");
        varOption.setDefaultValue("4");
        ((IntVariableDescriptor)varOption).setMaxValue(128.0);
        ((IntVariableDescriptor)varOption).setMinValue(1.0);
        this.jobDesc.addVariable(varOption);
        VariableDescriptor outputfolderVar = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(outputfolderVar);
        this.initJobFromDesc(this.jobDesc);
    }

    public String getJobCommand() {
        this.autoConnentData();
        if (!this.isValid()) {
            return null;
        }
        String outputFolder = this.getJobDescID();
        this.getVariable("JOB_OUTPUT_FOLDER").setRelativeTo(this.getVariable("INPUT_OUTPUT_FOLDER"));
        this.setValue("JOB_OUTPUT_FOLDER", outputFolder);
        StringBuilder command = new StringBuilder();
        command.append(this.getVariable("JOB_OUTPUT_FOLDER").getBashVarDecleration());
        command.append(this.getVariable(INPUT_FASTQ_FILE).getBashVarDecleration());
        command.append(BashHelper.If((String)BashConditions.emptyStr((JobVariable)this.getVariable(JAVA_MAX_HEAP_SIZE))).Then(BashHelper.assign((JobVariable)this.getVariable(JAVA_MAX_HEAP_SIZE), (String)"4")));
        String maxHeapSize = this.getVariable(JAVA_MAX_HEAP_SIZE).$();
        String progName = "java  -Xmx" + maxHeapSize + "g -jar " + Constants.PIPELINE_BASE_PATH + "FastqMidCleaner.jar ";
        String forBody = String.valueOf(progName) + " -o " + this.getVariable("JOB_OUTPUT_FOLDER").$() + " " + this.getOptionParamaters() + "-i " + this.getVariable(INPUT_FASTQ_FILE).$("$_i");
        if (!this.getValue(INPUT_MID_FILE).isEmpty()) {
            command.append(this.getVariable(INPUT_MID_FILE).getBashVarDecleration());
            this.getVariable(INPUT_MID_FILE);
            forBody = JobVariable.numberOfLines((String)this.getVariable(INPUT_MID_FILE).getValue()) > 1 ? String.valueOf(forBody) + " -m " + this.getVariable(INPUT_MID_FILE).$("$_i") : String.valueOf(forBody) + " -m " + this.getVariable(INPUT_MID_FILE).$("0");
        }
        if (!this.getValue(INPUT_ADAPTERS).isEmpty()) {
            command.append(this.getVariable(INPUT_ADAPTERS).getBashVarDecleration());
            this.getVariable(INPUT_ADAPTERS);
            forBody = JobVariable.numberOfLines((String)this.getVariable(INPUT_ADAPTERS).getValue()) > 1 ? String.valueOf(forBody) + " -a " + this.getVariable(INPUT_ADAPTERS).$("$_i") : String.valueOf(forBody) + " -a " + this.getVariable(INPUT_ADAPTERS).$("0");
        }
        command.append(BashHelper.forEachIndex((String)"_i", (String)this.getVariable(INPUT_FASTQ_FILE).getBashVarName(), (String)forBody));
        command.append("\n");
        return command.toString();
    }
}

