/*
 * Decompiled with CFR 0.152.
 */
package com.biotechvana.shared.jobs.preprocessing;

import com.biotechvana.utils.Constants;
import com.biotechvana.workflow.Tracking;
import com.biotechvana.workflow.WorkflowJob;
import com.biotechvana.workflow.descriptors.JobDescriptor;
import com.biotechvana.workflow.descriptors.VariableDescriptor;
import com.biotechvana.workflow.executer.BashHelper;
import com.biotechvana.workflow.variables.FileListVariable;
import com.biotechvana.workflow.variables.FileVariable;

public class PreProcessingFASTAQCJob
extends WorkflowJob {
    public static final String JOB_ID = "FASTQC";
    public static final String JOB_NAME = "FASTQC";
    public static final String INPUT_FILES = "INPUT_FILES";
    public static final String OPTION_CONTAMINANTS_FILE = "OPTION_CONTAMINANTS_FILE";
    public static final String OUTPUT_FILES = "OUTPUT_FILES";
    public static final String OUTPUT_REPORT_FILES = "OUTPUT_REPORT_FILES";
    private static final String GROUP_FILTERS = "Filters";
    public static final String FILTER_OPT_Q = "Q_Filter";
    public static final String FILTER_OPT_QP = "QP_Filter";
    public static final String FILTER_OPT_SC = "SC_Filter";
    public static final String FILTER_OPT_GC = "GC_Filter";
    public static final String FILTER_OPT_OS = "OS_Filter";
    public static final String FILTER_OPT_AC = "AC_Filter";
    public static final String FILTER_OPT_KC = "KC_Filter";

    public PreProcessingFASTAQCJob() {
        this.jobName = "FASTQC";
        this.jobDesc = new JobDescriptor("FASTQC");
        this.jobDesc.setDesc("FASTQC: A quality control tool for high throughput sequence data.");
        this.jobDesc.setDesc("FastQC aims to provide a simple way to do some quality control checks on raw sequence data coming from high throughput sequencing pipelines. It provides a modular set of analyses, which you can use to give a quick impression of whether your data has any problems of which you should be aware before doing any further analysis.");
        this.jobDesc.setRef("Online docs: <a href=\"http://www.bioinformatics.babraham.ac.uk/projects/fastqc/\">http://www.bioinformatics.babraham.ac.uk/projects/fastqc/</a>");
        VariableDescriptor var = VariableDescriptor.createDescriptorFor((String)INPUT_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Input);
        var.isRequired = true;
        var.setVariableName("Input File(s)");
        var.addAcceptedFileFormat("FASTQ", false, false);
        var.addAcceptedFileFormat("BAM", false, false);
        var.addAcceptedFileFormat("SAM", false, false);
        var.setHelpMsg("File could be BAM , FASTQ or SAM Formats");
        this.jobDesc.addVariable(var);
        var = VariableDescriptor.createDescriptorFor((String)OPTION_CONTAMINANTS_FILE, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.File, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        var.setVariableName("Contaminants file");
        var.setHelpMsg("Contaminants file Optional ");
        var.setCommandParamater("-c");
        this.jobDesc.addVariable(var);
        VariableDescriptor filterOption = VariableDescriptor.createDescriptorFor((String)FILTER_OPT_Q, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        filterOption.setVariableGroup(GROUP_FILTERS);
        filterOption.setVariableName("Min Per base sequence quality Score - Q");
        filterOption.setHelpMsg("Min Per base sequence quality Score that should be in qp% of the positions");
        this.jobDesc.addVariable(filterOption);
        filterOption = VariableDescriptor.createDescriptorFor((String)FILTER_OPT_QP, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        filterOption.setVariableGroup(GROUP_FILTERS);
        filterOption.setVariableName("Percent of Positions with Q quality score - PQ ");
        filterOption.setHelpMsg("Percent of Positions QP that should have min qualty score of Q");
        this.jobDesc.addVariable(filterOption);
        filterOption = VariableDescriptor.createDescriptorFor((String)FILTER_OPT_SC, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        filterOption.setVariableGroup(GROUP_FILTERS);
        filterOption.setVariableName("Max deviation value for Per base sequence content - SC");
        filterOption.setHelpMsg("Per base sequence content for all nucleotides should not deviates around the mean in any position more than SC");
        this.jobDesc.addVariable(filterOption);
        filterOption = VariableDescriptor.createDescriptorFor((String)FILTER_OPT_GC, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.Int, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Option);
        filterOption.setVariableGroup(GROUP_FILTERS);
        filterOption.setVariableName("Max GC content deviation - GC");
        filterOption.setHelpMsg("Per sequence GC content deviation from the theoretical distribution should be max represent GC precent of the total sequences ");
        this.jobDesc.addVariable(filterOption);
        VariableDescriptor varOutputFolder = WorkflowJob.createJobOutputFolderVar();
        this.jobDesc.addVariable(varOutputFolder);
        VariableDescriptor varOutputFiles = VariableDescriptor.createDescriptorFor((String)OUTPUT_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varOutputFiles.setVariableName("Output Files");
        varOutputFiles.addAcceptedFileFormat("FASTQ", false, false);
        varOutputFiles.addAcceptedFileFormat("BAM", false, false);
        varOutputFiles.addAcceptedFileFormat("SAM", false, false);
        this.jobDesc.addVariable(varOutputFiles);
        varOutputFiles = VariableDescriptor.createDescriptorFor((String)OUTPUT_REPORT_FILES, (VariableDescriptor.VariableType)VariableDescriptor.VariableType.FileList, (VariableDescriptor.VariableRole)VariableDescriptor.VariableRole.Output);
        varOutputFiles.setVariableName("Output Reports");
        varOutputFiles.addAcceptedFileFormat("ZIP");
        this.jobDesc.addVariable(varOutputFiles);
        this.initJobFromDesc(this.jobDesc);
        this.addVariableMap(OUTPUT_FILES, this.getVariable(INPUT_FILES));
    }

    protected void generateCommand(StringBuilder command) {
        String parsedOptions = this.getOptionParamatersStrAs$();
        command.append("outputFolder=\"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "\"\n");
        command.append("cmdPart1=\"" + Constants.PIPELINE_FASTQC_PATH + " " + parsedOptions + " \"\n");
        command.append(BashHelper.Batcher_noLog((FileListVariable)((FileListVariable)this.getVariable(INPUT_FILES)), (String)("fileDirName=\"${outputFolder}/${inputFileBaseName}\" \n[ -d  \"${fileDirName}\" ] || mkdir \"${fileDirName}\" \n" + this.getVariable(OUTPUT_REPORT_FILES).getBashVarName("$_p,$_i") + "=\"${fileDirName}/${inputFileBaseName}_fastqc.zip\" \n"), (boolean)true));
        command.append(BashHelper.BatcherParallel((FileListVariable)((FileListVariable)this.getVariable(INPUT_FILES)), (String)"fileDirName=\"${outputFolder}/${inputFileBaseName}\" \n$cmdPart1 --outdir \"${fileDirName}\" ${_inputFile} "));
    }

    protected String getFilterCheckCommand() {
        String checkLevel = Tracking.TrackCheckLevels.Fail.toString();
        if (this.getParent() == null) {
            checkLevel = Tracking.TrackCheckLevels.Warning.toString();
        }
        String filterOption = "qcFilterOption=\" \"\n";
        filterOption = String.valueOf(filterOption) + "[ -n \"" + this.getVariable(FILTER_OPT_Q).$() + "\" ] && " + "qcFilterOption=\"${qcFilterOption}  -q " + this.getVariable(FILTER_OPT_Q).$() + " \" \n";
        filterOption = String.valueOf(filterOption) + "[ -n \"" + this.getVariable(FILTER_OPT_QP).$() + "\" ] && " + "qcFilterOption=\"${qcFilterOption}  -qp " + this.getVariable(FILTER_OPT_QP).$() + " \" \n";
        filterOption = String.valueOf(filterOption) + "[ -n \"" + this.getVariable(FILTER_OPT_GC).$() + "\" ] && " + "qcFilterOption=\"${qcFilterOption}  -gc " + this.getVariable(FILTER_OPT_GC).$() + " \" \n";
        filterOption = String.valueOf(filterOption) + "echo \"${qcFilterOption}\" \n";
        String statusVar = "_g_filter_status";
        String cmdCheck = "";
        cmdCheck = String.valueOf(cmdCheck) + filterOption + "\n";
        cmdCheck = String.valueOf(cmdCheck) + BashHelper.forEachValue((String)"_File", (String)this.getVariable(INPUT_FILES).$("@"), (String)("inputFileBaseName=" + BashHelper.getBaseName((String)"_File") + "\n" + "filter=$( fastqcFilter.py    \"" + this.getVariable("JOB_OUTPUT_FOLDER").$() + "/$inputFileBaseName/$inputFileBaseName\"_fastqc.zip   ${qcFilterOption} -v)\n" + "filter=${filter//%/%%}\n" + "printf \"$filter\\n\"\n" + BashHelper.forEachValue((String)"_line", (String)"${filter}", (String)("IFS=\"=\" read -r -a fres <<< \"$_line\"\n[ -z ${fres[1]} ] &&  fileName=${fres[0]}   || { \n" + Tracking.trackLogCheck((String)"${_File}", (String)"${fres[0]}", (Tracking.TrackCheckType)Tracking.TrackCheckType.Filter, (String)"${fres[1]}", (String)"${fres[1]}") + BashHelper.IF((String)" \"${fres[1]}\" = \"Fail\" ", (String)BashHelper.assign((String)statusVar, (String)checkLevel)) + "}\n"))));
        return cmdCheck;
    }

    protected void generateCommandWrapUp(StringBuilder builder) {
        builder.append(((FileVariable)this.getVariable(OUTPUT_FILES)).getFileFormatAsBashVar(this.getVariable(INPUT_FILES)));
    }
}

